/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.git.core;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.util.FS;
import org.eclipse.ptp.internal.rdt.sync.git.core.Activator;
import org.eclipse.ptp.internal.rdt.sync.git.core.CommandRunner;
import org.eclipse.ptp.internal.rdt.sync.git.core.EclipseGitProgressTransformer;
import org.eclipse.ptp.internal.rdt.sync.git.core.GitSyncFileFilter;
import org.eclipse.ptp.internal.rdt.sync.git.core.SyncFileTreeIterator;
import org.eclipse.ptp.internal.rdt.sync.git.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.RecursiveSubMonitor;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.exceptions.RemoteExecutionException;
import org.eclipse.ptp.rdt.sync.core.exceptions.RemoteSyncException;
import org.eclipse.ptp.rdt.sync.core.exceptions.RemoteSyncMergeConflictException;
import org.eclipse.ptp.remote.core.AbstractRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class GitRemoteSyncConnection {
    private static final String instanceScopeSyncNode = "org.eclipse.ptp.rdt.sync.core";
    private static final String GIT_LOCATION_NODE_NAME = "git-location";
    private final int MAX_FILES = 100;
    private static final String remoteProjectName = "eclipse_auto";
    private static final String commitMessage = Messages.GRSC_CommitMessage;
    public static final String gitDir = ".ptp-sync";
    private static final String gitArgs = "--git-dir=.ptp-sync --work-tree=.";
    private static final String remotePushBranch = "ptp-push";
    private final String localDirectory;
    private final SyncConfig syncConfig;
    GitSyncFileFilter fileFilter;
    private Git git;
    private TransportGitSsh transport;
    private final IProject project;
    private boolean mergeMapInitialized = false;
    private final Map<IPath, String[]> FileToMergePartsMap = new HashMap<IPath, String[]>();
    private int remoteGitVersion;

    public static Repository getLocalRepo(String localDirectory) throws IOException {
        File localDir = new File(localDirectory);
        FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
        File gitDirFile = new File(String.valueOf(localDirectory) + File.separator + gitDir);
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)repoBuilder.setWorkTree(localDir)).setGitDir(gitDirFile)).build();
        if (!gitDirFile.exists()) {
            repository.create(false);
        }
        return repository;
    }

    public GitRemoteSyncConnection(IProject proj, String localDir, SyncConfig bs, AbstractSyncFileFilter filter, IProgressMonitor monitor) throws RemoteSyncException, MissingConnectionException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.project = proj;
            this.localDirectory = localDir;
            this.syncConfig = bs;
            this.fileFilter = (GitSyncFileFilter)filter;
            try {
                subMon.subTask(Messages.GitRemoteSyncConnection_21);
                this.remoteGitVersion = this.getRemoteGitVersion((IProgressMonitor)subMon.newChild(10));
                subMon.subTask(Messages.GitRemoteSyncConnection_20);
                this.buildRepo((IProgressMonitor)subMon.newChild(80));
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteExecutionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            RemoteConfig remoteConfig = this.buildRemoteConfig(this.git.getRepository().getConfig());
            subMon.subTask(Messages.GitRemoteSyncConnection_4);
            this.buildTransport(remoteConfig, (IProgressMonitor)subMon.newChild(10));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private RemoteConfig buildRemoteConfig(StoredConfig config) {
        RemoteConfig rconfig = null;
        try {
            rconfig = new RemoteConfig((Config)config, remoteProjectName);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        RefSpec refSpecFetch = new RefSpec("+refs/heads/master:refs/remotes/eclipse_auto/master");
        RefSpec refSpecPush = new RefSpec("+master:ptp-push");
        rconfig.addFetchRefSpec(refSpecFetch);
        rconfig.addPushRefSpec(refSpecPush);
        return rconfig;
    }

    private Git buildRepo(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            subMon.subTask(Messages.GitRemoteSyncConnection_1);
            this.git = new Git(GitRemoteSyncConnection.getLocalRepo(this.localDirectory));
            subMon.subTask(Messages.GitRemoteSyncConnection_22);
            this.doCommit((IProgressMonitor)subMon.newChild(4));
            subMon.subTask(Messages.GitRemoteSyncConnection_23);
            final Thread refreshThread = GitRemoteSyncConnection.doRefresh(this.project, (IProgressMonitor)subMon.newChild(1));
            Thread setDerivedThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        refreshThread.join();
                        GitRemoteSyncConnection.this.project.getFolder(GitRemoteSyncConnection.gitDir).setDerived(true, null);
                    }
                    catch (InterruptedException e) {
                        Activator.log(e);
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                    }
                }
            }, "Set repo as derived thread");
            setDerivedThread.start();
            try {
                subMon.subTask(Messages.GitRemoteSyncConnection_24);
                CommandRunner.createRemoteDirectory(this.syncConfig.getRemoteConnection(), this.syncConfig.getLocation(this.project), (IProgressMonitor)subMon.newChild(5));
            }
            catch (CoreException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            subMon.subTask(Messages.GitRemoteSyncConnection_25);
            this.doRemoteInit((IProgressMonitor)subMon.newChild(5));
            subMon.subTask(Messages.GitRemoteSyncConnection_27);
            this.commitRemoteFiles((IProgressMonitor)subMon.newChild(5));
            Git git = this.git;
            return git;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean doRemoteInit(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        try {
            String commands = "git --git-dir=.ptp-sync init && git --git-dir=.ptp-sync config core.preloadindex true";
            CommandRunner.CommandResults commandResults = null;
            try {
                commandResults = this.executeRemoteCommand(commands, monitor);
            }
            catch (InterruptedException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
            if (commandResults.getExitCode() != 0) {
                throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitInitFailure) + commandResults.getStderr());
            }
            return commandResults.getStdout().contains("existing");
            {
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void commitRemoteFiles(IProgressMonitor monitor) throws RemoteSyncException, MissingConnectionException {
        try {
            try {
                String command;
                CommandRunner.CommandResults commandResults;
                String property = this.syncConfig.getProperty("remote_filter_is_dirty");
                if (property == null || property.equals("TRUE")) {
                    String command2;
                    IRemoteConnection conn = this.syncConfig.getRemoteConnection();
                    IRemoteServices remoteServices = conn.getRemoteServices();
                    Repository repository = this.git.getRepository();
                    File exclude = repository.getFS().resolve(repository.getDirectory(), "info/exclude");
                    IFileStore local = EFS.getLocalFileSystem().getStore((IPath)new Path(exclude.getAbsolutePath()));
                    String remoteExclude = String.valueOf(this.syncConfig.getLocation(this.project)) + "/" + gitDir + "/" + "info/exclude";
                    IFileStore remote = remoteServices.getFileManager(conn).getResource(remoteExclude);
                    local.copy(remote, 2, monitor);
                    if (this.remoteGitVersion >= 1080102) {
                        command2 = String.valueOf(this.gitCommand()) + " ls-files -X " + gitDir + "/" + "info/exclude" + " -i | " + this.gitCommand() + " update-index --force-remove --stdin ; " + this.gitCommand() + " commit --allow-empty -m \"" + commitMessage + "\"";
                        CommandRunner.CommandResults commandResults2 = this.executeRemoteCommand(command2, monitor);
                        if (commandResults2.getExitCode() != 0) {
                            throw new RemoteSyncException(String.valueOf(Messages.GRSC_GitRemoveFilteredFailure1) + commandResults2.getStderr());
                        }
                    } else {
                        command2 = String.valueOf(this.gitCommand()) + " rev-parse HEAD";
                        CommandRunner.CommandResults commandResults3 = this.executeRemoteCommand(command2, monitor);
                        ObjectId objectId = null;
                        if (commandResults3.getExitCode() == 0) {
                            objectId = repository.resolve(commandResults3.getStdout().trim());
                        }
                        RevTree ref = null;
                        try {
                            if (objectId != null) {
                                ref = new RevWalk(repository).parseTree((AnyObjectId)objectId);
                            }
                        }
                        catch (Exception exception) {}
                        if (ref != null) {
                            Set<String> filesToRemove = this.fileFilter.getIgnoredFiles(ref);
                            this.deleteRemoteFiles(filesToRemove, monitor);
                        }
                    }
                    this.syncConfig.setProperty("remote_filter_is_dirty", "FALSE");
                    try {
                        SyncConfigManager.saveConfigs((IProject)this.project);
                    }
                    catch (CoreException e) {
                        Activator.log(String.valueOf(Messages.GitRemoteSyncConnection_19) + this.project.getName(), e);
                    }
                }
                if ((commandResults = this.executeRemoteCommand(command = String.valueOf(this.gitCommand()) + " ls-files -X " + gitDir + "/" + "info/exclude" + " -o -m | " + this.gitCommand() + " update-index --add --remove --stdin ; " + this.gitCommand() + " commit -m \"" + commitMessage + "\"", monitor)).getExitCode() != 0 && !commandResults.getStdout().contains("nothing to commit")) {
                    throw new RemoteSyncException(String.valueOf(Messages.GRSC_GitCommitFailure) + commandResults.getStderr());
                }
            }
            catch (InterruptedException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (CoreException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteExecutionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void deleteRemoteFiles(Set<String> filesToDelete, IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        try {
            while (!filesToDelete.isEmpty()) {
                List<String> commandList = this.stringToList(String.valueOf(this.gitCommand()) + " rm --cached -f --");
                int count = 1;
                String[] stringArray = filesToDelete.toArray(new String[0]);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    if (count++ % 100 == 0) break;
                    commandList.add(fileName);
                    filesToDelete.remove(fileName);
                    ++n2;
                }
                CommandRunner.CommandResults commandResults = null;
                try {
                    commandResults = this.executeRemoteCommand(commandList, monitor);
                }
                catch (InterruptedException e) {
                    throw new RemoteExecutionException((Throwable)e);
                }
                catch (RemoteConnectionException e) {
                    throw new RemoteExecutionException((Throwable)e);
                }
                if (commandResults.getExitCode() == 0) continue;
                throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitRmFailure) + commandResults.getStderr());
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private List<String> stringToList(String command) {
        return new ArrayList<String>(Arrays.asList(command.split(" ")));
    }

    private void buildTransport(RemoteConfig remoteConfig, IProgressMonitor monitor) {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
        URIish uri = this.buildURI();
        try {
            try {
                subMon.subTask(Messages.GitRemoteSyncConnection_8);
                this.transport = (TransportGitSsh)Transport.open((Repository)this.git.getRepository(), (URIish)uri);
            }
            catch (NotSupportedException e) {
                throw new RuntimeException(e);
            }
            catch (TransportException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        this.transport.setSshSessionFactory(new SshSessionFactory(){

            public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
                return new PTPSession(uri);
            }
        });
        this.transport.applyConfig(remoteConfig);
    }

    private URIish buildURI() {
        return new URIish().setHost("none").setScheme("ssh").setPath(String.valueOf(this.syncConfig.getLocation(this.project)) + "/" + gitDir);
    }

    public void close() {
        this.transport.close();
        this.git.getRepository().close();
    }

    private boolean doCommit(IProgressMonitor monitor) throws RemoteSyncException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean addedOrRemovedFiles = false;
        try {
            GitSyncFileFilter.DiffFiles diffFiles = this.fileFilter.getDiffFiles();
            subMon.subTask(Messages.GitRemoteSyncConnection_9);
            if (!diffFiles.added.isEmpty()) {
                AddCommand addCommand = this.git.add();
                addCommand.setWorkingTreeIterator((WorkingTreeIterator)new SyncFileTreeIterator(this.git.getRepository(), this.fileFilter));
                for (String fileName : diffFiles.added) {
                    addCommand.addFilepattern(fileName);
                }
                addCommand.call();
                addedOrRemovedFiles = true;
            }
            subMon.worked(10);
            subMon.subTask(Messages.GitRemoteSyncConnection_10);
            if (!diffFiles.removed.isEmpty()) {
                RmCommand rmCommand = new RmCommand(this.git.getRepository());
                rmCommand.setCached(true);
                for (String fileName : diffFiles.removed) {
                    rmCommand.addFilepattern(fileName);
                }
                rmCommand.call();
                addedOrRemovedFiles = true;
            }
            subMon.worked(10);
            subMon.subTask(Messages.GitRemoteSyncConnection_11);
            if (addedOrRemovedFiles || this.inMergeState()) {
                CommitCommand commitCommand = this.git.commit();
                commitCommand.setMessage(commitMessage);
                commitCommand.call();
                return true;
            }
            return false;
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean inMergeState() throws IOException {
        try {
            return this.git.getRepository().resolve("MERGE_HEAD") != null;
        }
        catch (AmbiguousObjectException e) {
            Activator.log(e);
            return true;
        }
    }

    private void readMergeConflictFiles() throws RemoteSyncException {
        String repoPath = this.git.getRepository().getWorkTree().getAbsolutePath();
        if (!repoPath.endsWith(File.separator)) {
            repoPath = String.valueOf(repoPath) + File.separator;
        }
        this.FileToMergePartsMap.clear();
        this.mergeMapInitialized = true;
        RevWalk walk = null;
        try {
            if (!this.git.getRepository().getRepositoryState().equals((Object)RepositoryState.MERGING)) {
                return;
            }
            StatusCommand statusCommand = this.git.status();
            Status status = statusCommand.call();
            if (status.getConflicting().isEmpty()) {
                return;
            }
            try {
                walk = new RevWalk(this.git.getRepository());
                walk.setRevFilter(RevFilter.MERGE_BASE);
                ObjectId headSHA = this.git.getRepository().resolve("HEAD");
                ObjectId mergeHeadSHA = this.git.getRepository().resolve("MERGE_HEAD");
                RevCommit head = walk.parseCommit((AnyObjectId)headSHA);
                RevCommit mergeHead = walk.parseCommit((AnyObjectId)mergeHeadSHA);
                walk.markStart(head);
                walk.markStart(mergeHead);
                RevCommit mergeBase = walk.next();
                for (String s : status.getConflicting()) {
                    TreeWalk ancestorTreeWalk;
                    String localContents = "";
                    TreeWalk localTreeWalk = TreeWalk.forPath((Repository)this.git.getRepository(), (String)s, (RevTree)head.getTree());
                    if (localTreeWalk != null) {
                        ObjectId localId = localTreeWalk.getObjectId(0);
                        localContents = new String(this.git.getRepository().open((AnyObjectId)localId).getBytes());
                    }
                    String remoteContents = "";
                    TreeWalk remoteTreeWalk = TreeWalk.forPath((Repository)this.git.getRepository(), (String)s, (RevTree)mergeHead.getTree());
                    if (remoteTreeWalk != null) {
                        ObjectId remoteId = remoteTreeWalk.getObjectId(0);
                        remoteContents = new String(this.git.getRepository().open((AnyObjectId)remoteId).getBytes());
                    }
                    String ancestorContents = "";
                    if (mergeBase != null && (ancestorTreeWalk = TreeWalk.forPath((Repository)this.git.getRepository(), (String)s, (RevTree)mergeBase.getTree())) != null) {
                        ObjectId ancestorId = ancestorTreeWalk.getObjectId(0);
                        ancestorContents = new String(this.git.getRepository().open((AnyObjectId)ancestorId).getBytes());
                    }
                    String[] mergeParts = new String[]{localContents, remoteContents, ancestorContents};
                    this.FileToMergePartsMap.put((IPath)new Path(s), mergeParts);
                }
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (GitAPIException e) {
                throw new RemoteSyncException((Throwable)e);
            }
        }
        finally {
            if (walk != null) {
                walk.dispose();
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public IRemoteConnection getConnection() throws MissingConnectionException {
        return this.syncConfig.getRemoteConnection();
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public String getRemoteDirectory() {
        return this.syncConfig.getLocation(this.project);
    }

    public void syncLocalToRemote(IProgressMonitor monitor) throws RemoteSyncException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
        subMon.subTask(Messages.GitRemoteSyncConnection_sync_local_to_remote);
        try {
            this.doCommit((IProgressMonitor)subMon.newChild(1));
            try {
                if (this.git.branchList().call().size() > 0) {
                    this.transport.push((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMon.newChild(5)), null);
                    String command = String.valueOf(this.gitCommand()) + " merge " + remotePushBranch;
                    CommandRunner.CommandResults mergeResults = this.executeRemoteCommand(command, (IProgressMonitor)subMon.newChild(5));
                    if (mergeResults.getExitCode() != 0) {
                        throw new RemoteSyncException((Throwable)new RemoteExecutionException(String.valueOf(Messages.GRSC_GitMergeFailure) + mergeResults.getStderr()));
                    }
                }
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (GitAPIException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (MissingConnectionException missingConnectionException) {
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void syncRemoteToLocal(IProgressMonitor monitor, boolean includeUntrackedFiles) throws RemoteSyncException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setFileFilter(AbstractSyncFileFilter sff) {
        this.fileFilter = (GitSyncFileFilter)sff;
    }

    public void sync(IProgressMonitor monitor, boolean includeUntrackedFiles) throws RemoteSyncException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                block20: {
                    subMon.subTask(Messages.GitRemoteSyncConnection_12);
                    this.doCommit((IProgressMonitor)subMon.newChild(5));
                    subMon.subTask(Messages.GitRemoteSyncConnection_14);
                    this.commitRemoteFiles((IProgressMonitor)subMon.newChild(18));
                    try {
                        try {
                            subMon.subTask(Messages.GitRemoteSyncConnection_15);
                            this.transport.fetch((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMon.newChild(18)), null);
                            subMon.subTask(Messages.GitRemoteSyncConnection_16);
                            Ref remoteMasterRef = this.git.getRepository().getRef("refs/remotes/eclipse_auto/master");
                            MergeCommand mergeCommand = this.git.merge().include(remoteMasterRef);
                            mergeCommand.call();
                            this.readMergeConflictFiles();
                            if (!this.FileToMergePartsMap.isEmpty()) {
                                throw new RemoteSyncMergeConflictException(Messages.GitRemoteSyncConnection_2);
                            }
                        }
                        catch (TransportException e) {
                            if (!e.getMessage().startsWith("Remote does not have ")) {
                                throw new RemoteSyncException((Throwable)e);
                            }
                            subMon.setWorkRemaining(36);
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        subMon.setWorkRemaining(36);
                        throw throwable;
                    }
                    subMon.setWorkRemaining(36);
                }
                if (this.git.branchList().call().size() > 0) {
                    subMon.subTask(Messages.GitRemoteSyncConnection_17);
                    this.transport.push((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMon.newChild(18)), null);
                    String command = String.valueOf(this.gitCommand()) + " merge " + remotePushBranch;
                    subMon.subTask(Messages.GitRemoteSyncConnection_18);
                    CommandRunner.CommandResults mergeResults = this.executeRemoteCommand(command, (IProgressMonitor)subMon.newChild(18));
                    if (mergeResults.getExitCode() != 0) {
                        throw new RemoteSyncException((Throwable)new RemoteExecutionException(String.valueOf(Messages.GRSC_GitMergeFailure) + mergeResults.getStderr()));
                    }
                }
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (GitAPIException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (MissingConnectionException missingConnectionException) {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public Set<IPath> getMergeConflictFiles() throws RemoteSyncException {
        if (!this.mergeMapInitialized) {
            this.readMergeConflictFiles();
        }
        return this.FileToMergePartsMap.keySet();
    }

    public String[] getMergeConflictParts(IFile localFile) throws RemoteSyncException {
        if (!this.mergeMapInitialized) {
            this.readMergeConflictFiles();
        }
        return this.FileToMergePartsMap.get(localFile.getProjectRelativePath());
    }

    public void setMergeAsResolved(IPath[] paths) throws RemoteSyncException {
        AddCommand addCommand = this.git.add();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            addCommand.addFilepattern(p.toString());
            ++n2;
        }
        try {
            addCommand.call();
            StatusCommand statusCommand = this.git.status();
            Status status = statusCommand.call();
            IPath[] iPathArray2 = paths;
            int n3 = paths.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath p = iPathArray2[n4];
                if (!status.getConflicting().contains(p.toString())) {
                    this.FileToMergePartsMap.remove(p);
                }
                ++n4;
            }
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
    }

    public int getRemoteGitVersion(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        String command = String.valueOf(this.gitCommand()) + " --version";
        CommandRunner.CommandResults commandResults = null;
        try {
            try {
                IRemoteConnection conn = this.syncConfig.getRemoteConnection();
                commandResults = CommandRunner.executeRemoteCommand(conn, command, null, monitor);
            }
            catch (InterruptedException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        if (commandResults.getExitCode() != 0) {
            throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitInitFailure) + commandResults.getStderr());
        }
        Matcher m = Pattern.compile("git version ([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.?([0-9]*)").matcher(commandResults.getStdout().trim());
        if (m.matches()) {
            int patch = 0;
            if (m.group(4).length() > 0) {
                patch = Integer.parseInt(m.group(4));
            }
            return Integer.parseInt(m.group(1)) * 1000000 + Integer.parseInt(m.group(2)) * 10000 + Integer.parseInt(m.group(3)) * 100 + patch;
        }
        return 0;
    }

    public void checkout(IPath[] paths) throws RemoteSyncException {
        CheckoutCommand checkoutCommand = this.git.checkout();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            checkoutCommand.addPath(p.toString());
            ++n2;
        }
        checkoutCommand.setStartPoint("HEAD");
        try {
            checkoutCommand.call();
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        GitRemoteSyncConnection.doRefresh(this.project, null);
    }

    public void checkoutRemoteCopy(IPath[] paths) throws RemoteSyncException {
        CheckoutCommand checkoutCommand = this.git.checkout();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            checkoutCommand.addPath(p.toString());
            ++n2;
        }
        checkoutCommand.setStartPoint("refs/remotes/eclipse_auto/master");
        try {
            checkoutCommand.call();
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        GitRemoteSyncConnection.doRefresh(this.project, null);
    }

    private static Thread doRefresh(final IProject project, final IProgressMonitor subMon) {
        Thread refreshWorkspaceThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    project.refreshLocal(2, subMon);
                }
                catch (CoreException e) {
                    Activator.log(Messages.GitRemoteSyncConnection_0, e);
                }
            }
        }, "Refresh workspace thread");
        refreshWorkspaceThread.start();
        return refreshWorkspaceThread;
    }

    private CommandRunner.CommandResults executeRemoteCommand(String command, IProgressMonitor monitor) throws RemoteSyncException, IOException, InterruptedException, RemoteConnectionException, MissingConnectionException {
        IRemoteConnection conn = this.syncConfig.getRemoteConnection();
        String remoteDirectory = this.syncConfig.getLocation(this.project);
        return CommandRunner.executeRemoteCommand(conn, command, remoteDirectory, monitor);
    }

    private CommandRunner.CommandResults executeRemoteCommand(List<String> command, IProgressMonitor monitor) throws RemoteSyncException, IOException, InterruptedException, RemoteConnectionException, MissingConnectionException {
        IRemoteConnection conn = this.syncConfig.getRemoteConnection();
        String remoteDirectory = this.syncConfig.getLocation(this.project);
        return CommandRunner.executeRemoteCommand(conn, command, remoteDirectory, monitor);
    }

    private String gitCommand() {
        String gitBinary = "git";
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences prefSyncNode = context.getNode(instanceScopeSyncNode);
        if (prefSyncNode == null) {
            Activator.log(Messages.GitRemoteSyncConnection_28);
        } else {
            try {
                if (prefSyncNode.nodeExists(GIT_LOCATION_NODE_NAME)) {
                    Preferences prefGitNode = prefSyncNode.node(GIT_LOCATION_NODE_NAME);
                    gitBinary = prefGitNode.get(this.syncConfig.getRemoteConnection().getName(), "git");
                }
            }
            catch (BackingStoreException e) {
                Activator.log(Messages.GitRemoteSyncConnection_29, e);
            }
            catch (MissingConnectionException missingConnectionException) {}
        }
        return String.valueOf(gitBinary) + " " + gitArgs;
    }

    public class PTPSession
    implements RemoteSession {
        private final URIish uri;

        public PTPSession(URIish uri) {
            this.uri = uri;
        }

        public Process exec(String command, int timeout) throws TransportException {
            LinkedList<String> commandList = new LinkedList<String>();
            commandList.add("sh");
            commandList.add("-c");
            commandList.add(command);
            try {
                IRemoteConnection connection = GitRemoteSyncConnection.this.syncConfig.getRemoteConnection();
                if (!connection.isOpen()) {
                    connection.open(null);
                }
                return (AbstractRemoteProcess)connection.getRemoteServices().getProcessBuilder(connection, commandList).start();
            }
            catch (IOException e) {
                throw new TransportException(this.uri, e.getMessage(), (Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new TransportException(this.uri, e.getMessage(), (Throwable)e);
            }
            catch (MissingConnectionException e) {
                throw new TransportException(this.uri, String.valueOf(Messages.GitRemoteSyncConnection_3) + e.getConnectionName(), (Throwable)e);
            }
        }

        public void disconnect() {
        }
    }
}

