/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.remotetools.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsConnectionManager;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsFileManager;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsProcessBuilder;
import org.eclipse.ptp.remote.core.AbstractRemoteServices;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.IRemoteServicesDescriptor;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsServices
extends AbstractRemoteServices {
    public static final String REMOTE_TOOLS_ID = "org.eclipse.ptp.remote.RemoteTools";
    private static final String TARGET_ELEMENT_NAME = "Remote Host";
    private final RemoteToolsConnectionManager connMgr = new RemoteToolsConnectionManager((IRemoteServices)this);
    private final Map<String, RemoteToolsFileManager> fileMgrs = new HashMap<String, RemoteToolsFileManager>();

    public static TargetTypeElement getTargetTypeElement() {
        TargetEnvironmentManager targetMgr = EnvironmentPlugin.getDefault().getTargetsManager();
        for (Object obj : targetMgr.getTypeElements()) {
            TargetTypeElement element = (TargetTypeElement)obj;
            if (!element.getName().equals(TARGET_ELEMENT_NAME)) continue;
            return element;
        }
        return null;
    }

    public RemoteToolsServices(IRemoteServicesDescriptor descriptor) {
        super(descriptor);
    }

    public IRemoteProcess getCommandShell(IRemoteConnection conn, int flags) throws IOException {
        throw new IOException("Not currently implemented");
    }

    public IRemoteConnectionManager getConnectionManager() {
        return this.connMgr;
    }

    public IRemoteFileManager getFileManager(IRemoteConnection conn) {
        RemoteToolsFileManager fileMgr = this.fileMgrs.get(conn.getName());
        if (fileMgr == null) {
            fileMgr = new RemoteToolsFileManager((RemoteToolsConnection)conn);
            this.fileMgrs.put(conn.getName(), fileMgr);
        }
        return fileMgr;
    }

    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, List<String> command) {
        return new RemoteToolsProcessBuilder((RemoteToolsConnection)conn, (RemoteToolsFileManager)this.getFileManager(conn), command);
    }

    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, String ... command) {
        return new RemoteToolsProcessBuilder((RemoteToolsConnection)conn, (RemoteToolsFileManager)this.getFileManager(conn), command);
    }

    public boolean initialize(IProgressMonitor monitor) {
        return true;
    }
}

