/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.core.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.ptp.internal.rm.lml.core.JAXBUtil;
import org.eclipse.ptp.internal.rm.lml.core.events.LguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.elements.CellType;
import org.eclipse.ptp.rm.lml.core.elements.ColumnType;
import org.eclipse.ptp.rm.lml.core.elements.InfoType;
import org.eclipse.ptp.rm.lml.core.elements.InfodataType;
import org.eclipse.ptp.rm.lml.core.elements.InformationType;
import org.eclipse.ptp.rm.lml.core.elements.LayoutRequestType;
import org.eclipse.ptp.rm.lml.core.elements.LayoutRoot;
import org.eclipse.ptp.rm.lml.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.core.elements.ObjectFactory;
import org.eclipse.ptp.rm.lml.core.elements.ObjectType;
import org.eclipse.ptp.rm.lml.core.elements.ObjectsType;
import org.eclipse.ptp.rm.lml.core.elements.RequestType;
import org.eclipse.ptp.rm.lml.core.elements.RowType;
import org.eclipse.ptp.rm.lml.core.elements.TableType;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiHandler;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.IPattern;
import org.eclipse.ptp.rm.lml.core.model.LayoutAccess;
import org.eclipse.ptp.rm.lml.core.model.NodedisplayAccess;
import org.eclipse.ptp.rm.lml.core.model.OIDToInformation;
import org.eclipse.ptp.rm.lml.core.model.OIDToObject;
import org.eclipse.ptp.rm.lml.core.model.ObjectStatus;
import org.eclipse.ptp.rm.lml.core.model.OverviewAccess;
import org.eclipse.ptp.rm.lml.core.model.TableHandler;

public class LguiItem
implements ILguiItem {
    private String name;
    private volatile LguiType lgui;
    private final List<ILguiListener> listeners = new LinkedList<ILguiListener>();
    private final Map<String, List<IPattern>> filters = new HashMap<String, List<IPattern>>();
    private final Map<Class<? extends ILguiHandler>, ILguiHandler> lguiHandlers = Collections.synchronizedMap(new HashMap());
    private final Map<String, JobStatusData> fJobMap = Collections.synchronizedMap(new TreeMap());
    private final JAXBUtil jaxbUtil = JAXBUtil.getInstance();
    private RequestType request;
    private String username = null;
    private boolean lockUpdate = false;
    private boolean lockPattern = false;

    public LguiItem(LguiType lgui) {
        this.lgui = lgui;
        this.createLguiHandlers();
    }

    public LguiItem(String name, String username) {
        this.name = name;
        this.username = username;
    }

    @Override
    public void addListener(ILguiListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addUserJob(String jobId, JobStatusData status, boolean force) {
        JobStatusData jobStatus = this.fJobMap.get(jobId);
        if (jobStatus == null) {
            TableType table;
            TableHandler handler;
            String oid;
            OverviewAccess overview;
            if (force && (overview = this.getOverviewAccess()) != null && (oid = overview.getOIDByJobId(jobId)) == null && (handler = this.getTableHandler()) != null && (table = handler.getTable(this.getGidFromJobStatus(status.getState()))) != null) {
                oid = this.generateOid();
                status.setOid(oid);
                this.addJobToTable(table, oid, status);
            }
            this.fJobMap.put(jobId, status);
        }
    }

    @Override
    public String[] getColumnTitlePattern(String gid) {
        ArrayList<String> titles = new ArrayList<String>();
        List<IPattern> patternList = this.filters.get(gid);
        if (patternList != null) {
            for (IPattern pattern : patternList) {
                titles.add(pattern.getColumnTitle());
            }
        }
        return titles.toArray(new String[titles.size()]);
    }

    @Override
    public void getCurrentLayout(OutputStream output) {
        while (this.lockPattern) {
            System.out.print("");
        }
        this.lockUpdate = true;
        LayoutRoot layout = null;
        if (this.lgui == null) {
            layout = this.firstRequest();
        } else {
            layout = this.getLayoutAccess().generateRequestFromModel();
            layout.setRequest(this.request);
        }
        this.jaxbUtil.marshal(layout, output);
    }

    @Override
    public LayoutAccess getLayoutAccess() {
        if (this.lguiHandlers.get(LayoutAccess.class) == null) {
            return null;
        }
        return (LayoutAccess)this.lguiHandlers.get(LayoutAccess.class);
    }

    public LguiType getLguiType() {
        return this.lgui;
    }

    @Override
    public String[] getMessageOfTheDay() {
        String type = new String();
        String message = new String();
        LinkedList<String> oidList = new LinkedList<String>();
        if (this.getOverviewAccess() != null) {
            if (this.getOverviewAccess().getObjects() != null) {
                for (ObjectsType objects : this.getOverviewAccess().getObjects()) {
                    for (ObjectType object : objects.getObject()) {
                        if (!object.getType().value().equals("system")) continue;
                        oidList.add(object.getId());
                    }
                }
            }
            for (String oid : oidList) {
                for (InfodataType data : this.getOverviewAccess().getInformation(oid).getData()) {
                    if (data.getKey().equals("motd")) {
                        type = "motd";
                        message = data.getValue();
                        message = message.replaceAll("&#10;", "\n");
                        message = message.replaceAll("&lt;", "<");
                        message = message.replaceAll("&gt;", ">");
                        message = message.replaceAll("&amp;", "&");
                        message = message.replaceAll("&apos;", "'");
                        message = message.replaceAll("&quot", "\"");
                        continue;
                    }
                    if (!data.getKey().equals("error")) continue;
                    return new String[]{"error", data.getValue()};
                }
            }
        }
        return new String[]{type, message};
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NodedisplayAccess getNodedisplayAccess() {
        if (this.lguiHandlers.get(NodedisplayAccess.class) == null) {
            return null;
        }
        return (NodedisplayAccess)this.lguiHandlers.get(NodedisplayAccess.class);
    }

    @Override
    public ObjectStatus getObjectStatus() {
        if (this.lguiHandlers.get(ObjectStatus.class) == null) {
            return null;
        }
        return (ObjectStatus)this.lguiHandlers.get(ObjectStatus.class);
    }

    @Override
    public OIDToInformation getOIDToInformation() {
        if (this.lguiHandlers.get(OIDToInformation.class) == null) {
            return null;
        }
        return (OIDToInformation)this.lguiHandlers.get(OIDToInformation.class);
    }

    @Override
    public OIDToObject getOIDToObject() {
        if (this.lguiHandlers.get(OIDToObject.class) == null) {
            return null;
        }
        return (OIDToObject)this.lguiHandlers.get(OIDToObject.class);
    }

    @Override
    public OverviewAccess getOverviewAccess() {
        if (this.lguiHandlers.get(OverviewAccess.class) == null) {
            return null;
        }
        return (OverviewAccess)this.lguiHandlers.get(OverviewAccess.class);
    }

    @Override
    public TableHandler getTableHandler() {
        if (this.lguiHandlers.get(TableHandler.class) == null) {
            return null;
        }
        return (TableHandler)this.lguiHandlers.get(TableHandler.class);
    }

    @Override
    public JobStatusData getUserJob(String jobId) {
        return this.fJobMap.get(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatusData[] getUserJobs() {
        Map<String, JobStatusData> map = this.fJobMap;
        synchronized (map) {
            return this.fJobMap.values().toArray(new JobStatusData[this.fJobMap.values().size()]);
        }
    }

    @Override
    public String getUsername() {
        if (this.username == null) {
            return new String();
        }
        return this.username;
    }

    @Override
    public String getVersion() {
        return this.lgui.getVersion();
    }

    @Override
    public boolean isEmpty() {
        TableHandler handler = this.getTableHandler();
        if (handler != null) {
            if (handler.getTables().size() == 0) {
                return true;
            }
            return handler.getTables().get(0).getRow().size() == 0;
        }
        return true;
    }

    @Override
    public boolean isFilterOwnJobActive(String gid) {
        List<IPattern> filters = this.getTableHandler().getPattern(gid);
        if (filters.size() > 0) {
            for (IPattern filter : filters) {
                if (!filter.getColumnTitle().equals("owner")) continue;
                return filter.getRelationOperator().equals("=") && filter.getRelationValue().equals(this.username);
            }
        }
        return false;
    }

    @Override
    public boolean isLayout() {
        return this.lgui != null && this.lgui.isLayout();
    }

    @Override
    public void lockPattern() {
        while (this.lockUpdate) {
            System.out.print("");
        }
        this.lockPattern = true;
    }

    @Override
    public void notifyListeners() {
        LguiUpdatedEvent event = new LguiUpdatedEvent(this, this.lgui);
        for (ILguiListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    @Override
    public void reloadLastLayout(String layout) {
        LayoutRoot layoutRoot = null;
        if (layout.length() > 0) {
            layoutRoot = this.jaxbUtil.unmarshalLayout(layout.toString());
        }
        if (layoutRoot != null) {
            this.lgui = this.jaxbUtil.convertLayoutToLgui(layoutRoot);
            if (this.listeners.isEmpty()) {
                this.createLguiHandlers();
            }
        }
    }

    public void removeListener(ILguiListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removeUserJob(String jobId) {
        TableHandler handler;
        JobStatusData status = this.fJobMap.get(jobId);
        if (status != null && (handler = this.getTableHandler()) != null) {
            TableType table = handler.getTable(this.getGidFromJobStatus(status.getState()));
            if (table != null) {
                int index = -1;
                int i = 0;
                while (i < table.getRow().size()) {
                    RowType row = table.getRow().get(i);
                    String rowJobId = handler.getCellValue(table, row, "step");
                    if (rowJobId.equals(jobId)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index >= 0) {
                    table.getRow().remove(index);
                }
            }
            status.setRemoved();
        }
    }

    @Override
    public String saveCurrentLayout() {
        StringWriter writer = new StringWriter();
        LayoutRoot layoutLgui = null;
        layoutLgui = this.lgui == null ? this.firstRequest() : this.getLayoutAccess().generateRequestFromModel();
        this.jaxbUtil.marshal(layoutLgui, writer);
        return writer.getBuffer().toString();
    }

    @Override
    public void setRequest(RequestType request) {
        this.request = request;
        if (this.lgui != null) {
            LayoutRequestType layoutReq = new LayoutRequestType();
            layoutReq.setGetDefaultData(true);
            this.request.setLayoutManagement(layoutReq);
            this.lgui.setRequest(this.request);
        }
    }

    @Override
    public void unlockPattern() {
        this.lockPattern = false;
    }

    @Override
    public void update(InputStream stream) {
        StringBuilder xmlStream;
        block18: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            xmlStream = new StringBuilder();
            try {
                try {
                    String s;
                    while ((s = reader.readLine()) != null) {
                        xmlStream.append(String.valueOf(s) + "\n");
                    }
                }
                catch (IOException iOException) {
                    xmlStream = new StringBuilder();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {
                            xmlStream = new StringBuilder();
                        }
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        xmlStream = new StringBuilder();
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    xmlStream = new StringBuilder();
                }
            }
        }
        if (xmlStream.length() > 0) {
            this.lgui = this.jaxbUtil.unmarshal(xmlStream.toString());
            if (this.listeners.isEmpty()) {
                this.createLguiHandlers();
            }
            this.fireUpdatedEvent();
            if (!this.cidSet()) {
                this.setCid();
            }
            this.updateJobData();
        }
        this.lockUpdate = false;
    }

    @Override
    public void updateUserJob(String jobId, String status, String detail) {
        JobStatusData jobStatus = this.fJobMap.get(jobId);
        if (jobStatus != null && status != null) {
            String gidOld = this.getGidFromJobStatus(jobStatus.getState());
            String gidNew = this.getGidFromJobStatus(status);
            TableHandler handler = this.getTableHandler();
            if (handler != null) {
                TableType tableOld = handler.getTable(gidOld);
                if (tableOld != null) {
                    TableType tableNew;
                    RowType rowOld = null;
                    int index = -1;
                    if (tableOld.getRow() != null) {
                        int i = 0;
                        while (i < tableOld.getRow().size()) {
                            RowType row = tableOld.getRow().get(i);
                            String id = handler.getCellValue(tableOld, row, "step");
                            if (id != null && id.equals(jobId)) {
                                handler.setCellValue(tableOld, row, "status", status);
                                rowOld = row;
                                index = i;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (!gidOld.equals(gidNew) && (tableNew = handler.getTable(gidNew)) != null && index >= 0 && rowOld != null) {
                        RowType rowNew = new RowType();
                        rowNew.setOid(rowOld.getOid());
                        for (ColumnType columnOld : tableOld.getColumn()) {
                            CellType cellNew = new CellType();
                            cellNew.setCid(columnOld.getId());
                            boolean filled = false;
                            block2: for (ColumnType columnNew : tableNew.getColumn()) {
                                if (!columnOld.getName().equals(columnNew.getName())) continue;
                                for (CellType cellOld : rowOld.getCell()) {
                                    if (!cellOld.getCid().equals(columnOld.getId())) continue;
                                    cellNew.setValue(cellOld.getValue());
                                    filled = true;
                                    continue block2;
                                }
                            }
                            if (!filled) {
                                cellNew.setValue("?");
                            }
                            rowNew.getCell().add(cellNew);
                        }
                        tableNew.getRow().add(rowNew);
                        tableOld.getRow().remove(index);
                    }
                }
                jobStatus.updateState(status, detail);
            }
        }
    }

    private void addCellToRow(RowType row, ColumnType column, String value) {
        CellType cell = new CellType();
        cell.setCid(column.getId());
        if (value == null) {
            value = "?";
        }
        cell.setValue(value);
        row.getCell().add(cell);
    }

    private void addJobToTable(TableType table, String oid, JobStatusData status) {
        RowType row = new RowType();
        row.setOid(oid);
        for (ColumnType column : table.getColumn()) {
            if (column.getName().equals("step")) {
                this.addCellToRow(row, column, status.getJobId());
                continue;
            }
            if (column.getName().equals("status")) {
                this.addCellToRow(row, column, status.getState());
                continue;
            }
            if (column.getName().equals("owner")) {
                this.addCellToRow(row, column, status.getString("owner"));
                continue;
            }
            if (column.getName().equals("queue")) {
                String queue = status.getString("queueName");
                if (queue == null || queue.equals("") && status.getString("queue") != null) {
                    queue = status.getString("queue");
                }
                this.addCellToRow(row, column, queue);
                continue;
            }
            String value = status.getString(column.getName());
            if (value == null) continue;
            this.addCellToRow(row, column, value);
        }
        table.getRow().add(row);
    }

    private void checkTables(TableHandler handler) {
        if (handler != null) {
            if (handler.getTable("org.eclipse.ptp.rm.lml.ui.ActiveJobsView") == null) {
                handler.generateDefaultTable("org.eclipse.ptp.rm.lml.ui.ActiveJobsView");
            }
            if (handler.getTable("org.eclipse.ptp.rm.lml.ui.InactiveJobsView") == null) {
                handler.generateDefaultTable("org.eclipse.ptp.rm.lml.ui.InactiveJobsView");
            }
        }
    }

    private boolean cidSet() {
        TableHandler handler = this.getTableHandler();
        if (handler != null) {
            for (TableType table : handler.getTables()) {
                for (RowType row : table.getRow()) {
                    for (CellType cell : row.getCell()) {
                        if (cell.getCid() != null) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private void createLguiHandlers() {
        this.lguiHandlers.put(OverviewAccess.class, new OverviewAccess(this, this.lgui));
        this.lguiHandlers.put(LayoutAccess.class, new LayoutAccess(this, this.lgui));
        this.lguiHandlers.put(OIDToObject.class, new OIDToObject(this, this.lgui));
        this.lguiHandlers.put(ObjectStatus.class, new ObjectStatus(this, this.lgui));
        this.lguiHandlers.put(OIDToInformation.class, new OIDToInformation(this, this.lgui));
        this.lguiHandlers.put(TableHandler.class, new TableHandler(this, this.lgui));
        this.lguiHandlers.put(NodedisplayAccess.class, new NodedisplayAccess(this, this.lgui));
    }

    private void fireUpdatedEvent() {
        LguiUpdatedEvent e = new LguiUpdatedEvent(this, this.lgui);
        for (ILguiListener listener : this.listeners) {
            listener.handleEvent(e);
        }
    }

    private LayoutRoot firstRequest() {
        ObjectFactory objectFactory = new ObjectFactory();
        LayoutRoot result = objectFactory.createLayoutRoot();
        result.setVersion("1");
        LayoutRequestType layoutReq = objectFactory.createLayoutRequestType();
        layoutReq.setGetDefaultData(true);
        this.request.setLayoutManagement(layoutReq);
        result.setRequest(this.request);
        return result;
    }

    private String generateOid() {
        return UUID.randomUUID().toString();
    }

    private String getGidFromJobStatus(String status) {
        if (status.equals("RUNNING")) {
            return "org.eclipse.ptp.rm.lml.ui.ActiveJobsView";
        }
        return "org.eclipse.ptp.rm.lml.ui.InactiveJobsView";
    }

    private void setCid() {
        TableHandler handler = this.getTableHandler();
        if (handler != null) {
            for (TableType table : handler.getTables()) {
                for (RowType row : table.getRow()) {
                    int cid = 1;
                    for (CellType cell : row.getCell()) {
                        if (cell.getCid() == null) {
                            cell.setCid(BigInteger.valueOf(cid));
                        } else {
                            cid = cell.getCid().intValue();
                        }
                        ++cid;
                    }
                }
            }
        }
    }

    private void updateJobData() {
        HashSet<String> jobsInTable = new HashSet<String>();
        for (InformationType information : this.getOverviewAccess().getInformations()) {
            for (InfoType info : information.getInfo()) {
                JobStatusData status;
                String jobId = this.getOverviewAccess().getInfodataValue(info, "step");
                if (jobId == null || (status = this.fJobMap.get(jobId)) == null) continue;
                if (!status.isRemoved()) {
                    status.putString("oid", info.getOid());
                    status.setState(this.getOverviewAccess().getInfodataValue(info, "status"));
                }
                jobsInTable.add(status.getJobId());
            }
        }
        TableHandler handler = this.getTableHandler();
        if (handler != null) {
            this.checkTables(handler);
            handler.forwardRowToJobData();
            TableType table = handler.getTable("org.eclipse.ptp.rm.lml.ui.InactiveJobsView");
            if (table != null) {
                JobStatusData[] jobStatusDataArray = this.getUserJobs();
                int n = jobStatusDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JobStatusData status = jobStatusDataArray[n2];
                    if (!jobsInTable.contains(status.getJobId())) {
                        if (!status.isRemoved()) {
                            if (!status.isCompleted()) {
                                status.setState("COMPLETED");
                                status.putString("oid", this.generateOid());
                            }
                            this.addJobToTable(table, status.getString("oid"), status);
                        } else {
                            this.fJobMap.remove(status.getJobId());
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

