/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.info;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.AbstractDataAdapter;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.EventIdCache;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InfoAdapter
extends AbstractDataAdapter {
    public static final String HELP_EVENTS = "help_events";
    public static final String INFO = "info";
    public static final String DEFAULTS = "defaults";
    public static final String NUM_COUNTERS = "num-counters";
    public static final String CPU_FREQUENCY = "cpu-frequency";
    public static final String TIMER_MODE = "timer-mode";
    public static final String TIMER = "timer";
    public static final String EVENT_LIST = "event-list";
    public static final String COUNTER = "counter";
    public static final String EVENT = "event";
    public static final String EVENT_NAME = "event_name";
    public static final String NAME = "name";
    public static final String DESC = "desc";
    public static final String DESCRIPTION = "description";
    public static final String MIN_COUNT = "min_count";
    public static final String MINIMUM = "minimum";
    public static final String VALUE = "value";
    public static final String UNIT_MASKS = "unit_masks";
    public static final String UNITMASK = "unit-mask";
    public static final String DEFAULT = "default";
    public static final String TYPE = "type";
    public static final String UNIT_MASK = "unit_mask";
    public static final String MASK = "mask";
    public static final String SAMPLE_DIR = "sample-dir";
    public static final String LOCK_FILE = "lock-file";
    public static final String LOG_FILE = "log-file";
    public static final String DUMP_STATUS = "dump-status";
    public static final String CPUINFO = "/proc/cpuinfo";
    public static String DEV_OPROFILE = "/dev/oprofile/";
    public static String CPUTYPE = String.valueOf(DEV_OPROFILE) + "cpu_type";
    public static final String OP_SHARE = "/usr/share/oprofile/";
    public static final String EVENTS = "events";
    public static final String SAMPLE_DIR_VAL = "/var/lib/oprofile/samples/";
    public static final String LOCK_FILE_VAL = "/var/lib/oprofile/lock";
    public static final String LOG_FILE_VAL = "/var/lib/oprofile/samples/oprofiled.log";
    public static final String DUMP_STATUS_VAL = "/var/lib/oprofile/complete_dump";
    private Document newDoc;
    private Element oldRoot;
    private Element newRoot;
    private static IRemoteFileProxy proxy;
    private static boolean hasTimerSupport;

    public InfoAdapter() {
        try {
            if (InfoAdapter.hasTimerSupport()) {
                this.createDOM(null);
            } else {
                Process p = RuntimeProcessFactory.getFactory().exec("ophelp -X", Oprofile.OprofileProject.getProject());
                if (p != null) {
                    InputStream is = p.getInputStream();
                    this.createDOM(is);
                } else {
                    this.createDOM(null);
                }
            }
        }
        catch (IOException e) {
            this.createDOM(null);
        }
    }

    public InfoAdapter(IFileStore resourceFile) {
        InputStream inputStream = null;
        try {
            inputStream = resourceFile.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
            this.createDOM(inputStream);
            this.setEventIdCacheDoc(this.oldRoot);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public InfoAdapter(File resourceFile) {
        try {
            FileInputStream fileInpStr = new FileInputStream(resourceFile);
            this.createDOM(fileInpStr);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void createDOM(InputStream is) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            try {
                if (is != null) {
                    Element elem;
                    Document oldDoc = builder.parse(is);
                    this.oldRoot = elem = (Element)oldDoc.getElementsByTagName(HELP_EVENTS).item(0);
                }
                this.newDoc = builder.newDocument();
                this.newRoot = this.newDoc.createElement(INFO);
                this.newDoc.appendChild(this.newRoot);
            }
            catch (Exception e) {
                e.printStackTrace();
                OpcontrolException opcontrolException = new OpcontrolException(OprofileCorePlugin.createErrorStatus("opcontrolRun", null));
                OprofileCorePlugin.showErrorDialog("opcontrolProvider", opcontrolException);
            }
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
    }

    public void process() {
        if (this.getNrCounters() == -1) {
            Element numCountersTag = this.newDoc.createElement(NUM_COUNTERS);
            numCountersTag.setTextContent("error");
            this.newRoot.appendChild(numCountersTag);
            return;
        }
        this.createHeaders();
        if (!InfoAdapter.hasTimerSupport() && this.oldRoot != null) {
            this.createXML();
        }
    }

    private void createHeaders() {
        String numCounters = String.valueOf(this.getNrCounters());
        Element numCountersTag = this.newDoc.createElement(NUM_COUNTERS);
        numCountersTag.setTextContent(String.valueOf(numCounters));
        this.newRoot.appendChild(numCountersTag);
        int cpuFreq = this.getCPUFrequency();
        Element cpuFreqTag = this.newDoc.createElement(CPU_FREQUENCY);
        cpuFreqTag.setTextContent(String.valueOf(cpuFreq));
        this.newRoot.appendChild(cpuFreqTag);
        Element defaultsTag = this.newDoc.createElement(DEFAULTS);
        Element sampleDirTag = this.newDoc.createElement(SAMPLE_DIR);
        sampleDirTag.setTextContent(SAMPLE_DIR_VAL);
        defaultsTag.appendChild(sampleDirTag);
        Element lockFileTag = this.newDoc.createElement(LOCK_FILE);
        lockFileTag.setTextContent(LOCK_FILE_VAL);
        defaultsTag.appendChild(lockFileTag);
        Element logFileTag = this.newDoc.createElement(LOG_FILE);
        logFileTag.setTextContent(LOG_FILE_VAL);
        defaultsTag.appendChild(logFileTag);
        Element dumpStatusTag = this.newDoc.createElement(DUMP_STATUS);
        dumpStatusTag.setTextContent(DUMP_STATUS_VAL);
        defaultsTag.appendChild(dumpStatusTag);
        this.newRoot.appendChild(defaultsTag);
        Element timerModeTag = this.newDoc.createElement(TIMER_MODE);
        timerModeTag.setTextContent(String.valueOf(InfoAdapter.hasTimerSupport()));
        this.newRoot.appendChild(timerModeTag);
    }

    public static void setOprofileDir(String dir) {
        DEV_OPROFILE = dir;
        CPUTYPE = String.valueOf(DEV_OPROFILE) + "cpu_type";
    }

    public static boolean hasTimerSupport() {
        return hasTimerSupport;
    }

    public static void checkTimerSupport() {
        try {
            proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
            IFileStore fileStore = proxy.getResource(CPUTYPE);
            if (fileStore.fetchInfo().exists()) {
                InputStream is = fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
                BufferedReader bi = new BufferedReader(new InputStreamReader(is));
                String cpuType = bi.readLine();
                bi.close();
                hasTimerSupport = cpuType.equals(TIMER);
            }
        }
        catch (FileNotFoundException e) {
            hasTimerSupport = true;
        }
        catch (IOException e) {
            hasTimerSupport = true;
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    private int getCPUFrequency() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 35[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getNrCounters() {
        if (Oprofile.OprofileProject.getProfilingBinary().equals("operf")) {
            return 1;
        }
        try {
            proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        int MAXCPUS = Integer.MAX_VALUE;
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            IFileStore fileStore = proxy.getResource(String.valueOf(DEV_OPROFILE) + i);
            if (!fileStore.fetchInfo().exists()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createXML() {
        NodeList eventList = this.oldRoot.getElementsByTagName(EVENT);
        Element newEventList = this.newDoc.createElement(EVENT_LIST);
        int i = 0;
        while (i < eventList.getLength()) {
            Element defaultValTag;
            Element typeTag;
            Element newUnitMaskTag;
            String type;
            String defaultVal;
            Element event = (Element)eventList.item(i);
            String name = event.getAttribute(EVENT_NAME);
            String desc = event.getAttribute(DESC);
            String min_count = event.getAttribute(MIN_COUNT);
            Element newEventTag = this.newDoc.createElement(EVENT);
            Element nameTag = this.newDoc.createElement(NAME);
            nameTag.setTextContent(name);
            Element descTag = this.newDoc.createElement(DESCRIPTION);
            descTag.setTextContent(desc);
            Element minimumTag = this.newDoc.createElement(MINIMUM);
            minimumTag.setTextContent(min_count);
            newEventTag.appendChild(nameTag);
            newEventTag.appendChild(descTag);
            newEventTag.appendChild(minimumTag);
            Element unitMaskTag = (Element)event.getElementsByTagName(UNIT_MASKS).item(0);
            if (unitMaskTag != null) {
                defaultVal = unitMaskTag.getAttribute(DEFAULT);
                type = EventIdCache.getInstance().getUnitMaskType(name);
                newUnitMaskTag = this.newDoc.createElement(UNITMASK);
                typeTag = this.newDoc.createElement(TYPE);
                typeTag.setTextContent(type);
                defaultValTag = this.newDoc.createElement(DEFAULT);
                defaultValTag.setTextContent(defaultVal);
                newUnitMaskTag.appendChild(typeTag);
                newUnitMaskTag.appendChild(defaultValTag);
                newEventTag.appendChild(newUnitMaskTag);
                NodeList unitMaskList = unitMaskTag.getElementsByTagName(UNIT_MASK);
                int j = 0;
                while (j < unitMaskList.getLength()) {
                    Element unitMask = (Element)unitMaskList.item(j);
                    String maskVal = unitMask.getAttribute(MASK);
                    String maskDesc = unitMask.getAttribute(DESC);
                    Element newMask = this.newDoc.createElement(MASK);
                    Element newVal = this.newDoc.createElement(VALUE);
                    newVal.setTextContent(maskVal);
                    Element newDesc = this.newDoc.createElement(DESCRIPTION);
                    newDesc.setTextContent(maskDesc);
                    newMask.appendChild(newVal);
                    newMask.appendChild(newDesc);
                    newUnitMaskTag.appendChild(newMask);
                    ++j;
                }
            } else {
                defaultVal = "0";
                type = "mandatory";
                newUnitMaskTag = this.newDoc.createElement(UNITMASK);
                typeTag = this.newDoc.createElement(TYPE);
                typeTag.setTextContent(type);
                defaultValTag = this.newDoc.createElement(DEFAULT);
                defaultValTag.setTextContent(defaultVal);
                newUnitMaskTag.appendChild(typeTag);
                newUnitMaskTag.appendChild(defaultValTag);
                newEventTag.appendChild(newUnitMaskTag);
                Element newMask = this.newDoc.createElement(MASK);
                Element newVal = this.newDoc.createElement(VALUE);
                newVal.setTextContent("0");
                Element newDesc = this.newDoc.createElement(DESCRIPTION);
                newDesc.setTextContent("No unit mask");
                newMask.appendChild(newVal);
                newMask.appendChild(newDesc);
                newUnitMaskTag.appendChild(newMask);
            }
            newEventList.appendChild(newEventTag);
            ++i;
        }
        i = 0;
        while (i < this.getNrCounters()) {
            Element eventListTag = (Element)newEventList.cloneNode(true);
            eventListTag.setAttribute(COUNTER, String.valueOf(i));
            this.newRoot.appendChild(eventListTag);
            ++i;
        }
    }

    public Document getDocument() {
        return this.newDoc;
    }

    public void setEventIdCacheDoc(Element elem) {
        EventIdCache.getInstance().setCacheDoc(elem);
    }
}

