/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory;

import java.io.PrintStream;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.core.resources.IFile;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.StatementMap;

public class FileStatementMap
extends StatementMap {
    protected IASTTranslationUnit tu_ = null;
    protected String filename_ = "";

    public FileStatementMap(IFile file) throws IASTServiceProvider.UnsupportedDialectException {
        this.tu_ = CDOM.getInstance().getTranslationUnit(file);
        this.filename_ = this.tu_.getFilePath();
    }

    public FileStatementMap(IASTTranslationUnit tu) {
        this.tu_ = tu;
        this.filename_ = this.tu_.getFilePath();
    }

    public void buildMap() {
        Visitor v = new Visitor();
        this.tu_.accept((ASTVisitor)v);
    }

    private String getShortClassName(Class c) {
        String n = c.toString();
        int lastIndex = n.lastIndexOf(46);
        return n.substring(lastIndex + 1);
    }

    protected class Visitor
    extends ASTVisitor {
        public Visitor() {
            this.shouldVisitStatements = true;
        }

        public int visit(IASTStatement statement) {
            if (FileStatementMap.this.filename_ == null || !FileStatementMap.this.filename_.equals(statement.getContainingFilename())) {
                return 3;
            }
            if (statement instanceof IASTIfStatement) {
                this.processIfStatement((IASTIfStatement)statement);
                return 1;
            }
            if (statement instanceof IASTSwitchStatement) {
                this.processSwitchStatement((IASTSwitchStatement)statement);
                return 1;
            }
            if (statement instanceof IASTCaseStatement) {
                this.processCaseStatement((IASTCaseStatement)statement);
                return 3;
            }
            if (statement instanceof IASTForStatement) {
                this.processForStatement((IASTForStatement)statement);
                return 1;
            }
            if (statement instanceof IASTWhileStatement) {
                this.processWhileStatement((IASTWhileStatement)statement);
                return 1;
            }
            if (statement instanceof IASTDoStatement) {
                this.processDoStatement((IASTDoStatement)statement);
                return 1;
            }
            if (statement instanceof IASTCompoundStatement) {
                return 3;
            }
            if (statement instanceof IASTBreakStatement) {
                FileStatementMap.this.add((IASTNode)statement);
                return 3;
            }
            if (statement instanceof IASTContinueStatement) {
                FileStatementMap.this.add((IASTNode)statement);
                return 3;
            }
            if (statement instanceof IASTReturnStatement) {
                FileStatementMap.this.add((IASTNode)statement);
                return 3;
            }
            FileStatementMap.this.add((IASTNode)statement);
            return 3;
        }

        protected void processIfStatement(IASTIfStatement statement) {
            FileStatementMap.this.add((IASTNode)statement.getConditionExpression());
            if (statement.getThenClause() != null) {
                Visitor thenVisitor = new Visitor();
                statement.getThenClause().accept((ASTVisitor)thenVisitor);
            }
            if (statement.getElseClause() != null) {
                Visitor elseVisitor = new Visitor();
                statement.getElseClause().accept((ASTVisitor)elseVisitor);
            }
        }

        protected void processSwitchStatement(IASTSwitchStatement statement) {
            FileStatementMap.this.add((IASTNode)statement.getControllerExpression());
            Visitor bodyVisitor = new Visitor();
            statement.getBody().accept((ASTVisitor)bodyVisitor);
        }

        protected void processCaseStatement(IASTCaseStatement statement) {
            FileStatementMap.this.add((IASTNode)statement.getExpression());
        }

        protected void processForStatement(IASTForStatement statement) {
            FileStatementMap.this.add((IASTNode)statement.getConditionExpression());
            FileStatementMap.this.add((IASTNode)statement.getIterationExpression());
            if (statement.getInitializerStatement() != null) {
                Visitor initVisitor = new Visitor();
                statement.getInitializerStatement().accept((ASTVisitor)initVisitor);
            }
            if (statement.getBody() != null) {
                Visitor bodyVisitor = new Visitor();
                statement.getBody().accept((ASTVisitor)bodyVisitor);
            }
        }

        protected void processWhileStatement(IASTWhileStatement statement) {
            FileStatementMap.this.add((IASTNode)statement.getCondition());
            if (statement.getBody() != null) {
                Visitor bodyVisitor = new Visitor();
                statement.getBody().accept((ASTVisitor)bodyVisitor);
            }
        }

        protected void processDoStatement(IASTDoStatement statement) {
            FileStatementMap.this.add((IASTNode)statement.getCondition());
            if (statement.getBody() != null) {
                Visitor bodyVisitor = new Visitor();
                statement.getBody().accept((ASTVisitor)bodyVisitor);
            }
        }

        protected void printInformation(IASTNode node, PrintStream out) {
            StatementMap.Location l = FileStatementMap.this.getLocation(node);
            System.out.println("Statement: " + FileStatementMap.this.getShortClassName(node.getClass()) + " loc=(" + l.low_ + "," + l.high_ + ")   file=" + node.getContainingFilename());
        }
    }
}

