/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyHelper {
    private static final Map<String, Method> NOTNESTEDCACHE = new HashMap<String, Method>();

    public static Object getProperty(Object bean, String attr) throws Exception {
        Method readMethod;
        String key = String.valueOf(bean.getClass().getName()) + "#" + attr;
        if (attr.indexOf(46) == -1 && (readMethod = NOTNESTEDCACHE.get(key)) != null) {
            return readMethod.invoke(bean, new Object[0]);
        }
        readMethod = null;
        Object value = null;
        value = bean;
        String[] stringArray = attr.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            PropertyDescriptor desc = PropertyHelper.getPropertyDescriptor(value.getClass(), part);
            if (desc != null) {
                readMethod = desc.getReadMethod();
            }
            if (readMethod == null) {
                throw new IllegalArgumentException("Attribute '" + part + "' is not known in '" + value + "'");
            }
            value = readMethod.invoke(value, new Object[0]);
            ++n2;
        }
        if (attr.indexOf(46) == -1) {
            NOTNESTEDCACHE.put(key, readMethod);
        }
        return value;
    }

    private static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String name) throws IntrospectionException {
        PropertyDescriptor[] descs;
        PropertyDescriptor[] propertyDescriptorArray = descs = PropertyHelper.getPropertyDescriptor(clazz);
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor desc = propertyDescriptorArray[n2];
            if (desc.getName().equals(name)) {
                return desc;
            }
            ++n2;
        }
        return null;
    }

    private static PropertyDescriptor[] getPropertyDescriptor(Class<?> clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
    }
}

