/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.preferences;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.etfw.ETFWUtils;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.internal.etfw.Activator;
import org.eclipse.ptp.internal.etfw.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class ExternalToolPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IToolLaunchConfigurationConstants {
    protected List XMLLocs = null;
    protected Button browseXMLButton = null;
    protected Button removeItemButton = null;
    protected Combo parser = null;
    protected WidgetListener listener = new WidgetListener();

    public ExternalToolPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createGridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)this.spanGridData(768, 2));
        this.createParserSelection(composite);
        this.createTauConf(composite);
        this.loadSaved();
        this.defaultSetting();
        return composite;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    private void createParserSelection(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        group.setLayoutData((Object)this.spanGridData(768, 2));
        group.setText(Messages.ExternalToolPreferencePage_ToolParser);
        Composite content = new Composite((Composite)group, 0);
        content.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        content.setLayoutData((Object)this.spanGridData(768, 64));
        Label parserLbl = new Label(content, 0);
        parserLbl.setText(Messages.ExternalToolPreferencePage_ETFW_PARSER);
        this.parser = new Combo(content, 8);
        this.parser.add("sax-parser");
        this.parser.add("jaxb-parser");
    }

    private void createTauConf(Composite parent) {
        Group aGroup = new Group(parent, 16);
        aGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        aGroup.setLayoutData((Object)this.spanGridData(768, 2));
        aGroup.setText(Messages.ExternalToolPreferencePage_ExToolConf);
        Composite xmlcom = new Composite((Composite)aGroup, 0);
        xmlcom.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        xmlcom.setLayoutData((Object)this.spanGridData(768, 5));
        Label tauarchComment = new Label(xmlcom, 64);
        tauarchComment.setText(Messages.ExternalToolPreferencePage_ToolDefFile);
        this.XMLLocs = new List(xmlcom, 2560);
        this.XMLLocs.setLayoutData((Object)new GridData(768));
        this.browseXMLButton = new Button(xmlcom, 8);
        this.browseXMLButton.setText(Messages.ExternalToolPreferencePage_Add);
        this.browseXMLButton.addSelectionListener((SelectionListener)this.listener);
        this.removeItemButton = new Button(xmlcom, 8);
        this.removeItemButton.setText(Messages.ExternalToolPreferencePage_Remove);
        this.removeItemButton.addSelectionListener((SelectionListener)this.listener);
    }

    protected void defaultSetting() {
    }

    public void dispose() {
        super.dispose();
    }

    protected String getFieldContent(String text) {
        if (text == null) {
            return null;
        }
        if (text.trim().length() == 0 || text.equals("")) {
            return null;
        }
        return text;
    }

    protected void handleRemoveItem() {
        this.XMLLocs.remove(this.XMLLocs.getSelectionIndices());
    }

    protected void handleXMLBrowseButtonSelected() {
        IFileStore test;
        FileDialog dialog = new FileDialog(this.getShell());
        IFileStore path = null;
        String correctPath = null;
        int maxXDex = this.XMLLocs.getItemCount() - 1;
        if (maxXDex >= 0) {
            correctPath = this.getFieldContent(this.XMLLocs.getItem(maxXDex));
        }
        if (correctPath != null) {
            try {
                path = EFS.getStore((URI)new URI(correctPath));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException uRISyntaxException) {
                path = EFS.getLocalFileSystem().getStore((IPath)new Path(correctPath));
            }
            if (path != null && path.fetchInfo().exists()) {
                dialog.setFilterPath(!path.fetchInfo().isDirectory() ? correctPath : path.getParent().toURI().getPath());
            }
        }
        dialog.setText(Messages.ExternalToolPreferencePage_SelectToolDefXML);
        String out = this.getFieldContent(dialog.open());
        if (out != null && (test = EFS.getLocalFileSystem().getStore((IPath)new Path(out))).fetchInfo().exists() && !test.fetchInfo().isDirectory()) {
            this.XMLLocs.add(out);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void loadSaved() {
        String[] files;
        IPreferencesService service = Platform.getPreferencesService();
        String fiList = service.getString("org.eclipse.ptp.etfw", "tool_def_xml_location", "", null);
        String[] stringArray = files = fiList.split(",,,");
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.XMLLocs.add(s);
            ++n2;
        }
        String etfwVersion = Preferences.getString((String)"org.eclipse.ptp.etfw", (String)"ETFW_VERSION");
        int index = 0;
        while (index < this.parser.getItemCount()) {
            if (this.parser.getItem(index).equals(etfwVersion)) {
                this.parser.select(index);
                break;
            }
            ++index;
        }
    }

    public void performDefaults() {
        this.defaultSetting();
        this.updateApplyButton();
    }

    public boolean performOk() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ptp.etfw");
        String fiList = "";
        int i = 0;
        while (i < this.XMLLocs.getItemCount()) {
            fiList = String.valueOf(fiList) + this.XMLLocs.getItem(i);
            if (i < this.XMLLocs.getItemCount() - 1) {
                fiList = String.valueOf(fiList) + ",,,";
            }
            ++i;
        }
        preferences.put("tool_def_xml_location", fiList);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        ETFWUtils.refreshTools(Activator.getDefault().getPreferenceStore());
        Preferences.setString((String)"org.eclipse.ptp.etfw", (String)"ETFW_VERSION", (String)this.parser.getItem(this.parser.getSelectionIndex()));
        return true;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected void updatePreferencePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setValid(true);
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            ExternalToolPreferencePage.this.updatePreferencePage();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                ExternalToolPreferencePage.this.updatePreferencePage();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ExternalToolPreferencePage.this.browseXMLButton) {
                ExternalToolPreferencePage.this.handleXMLBrowseButtonSelected();
            }
            if (source == ExternalToolPreferencePage.this.removeItemButton) {
                ExternalToolPreferencePage.this.handleRemoveItem();
            }
            ExternalToolPreferencePage.this.updatePreferencePage();
        }
    }
}

