/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.charts;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.GraphingAPIUIPlugin;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.swtchart.Chart;
import org.swtchart.ITitle;

public abstract class AbstractChartBuilder
extends Composite
implements IUpdateListener {
    protected static final String FONT_NAME = "MS Sans Serif";
    protected int maxItems;
    protected double scale = 1.0;
    protected IAdapter adapter = null;
    protected int xseries;
    protected int[] yseries;
    protected static final Color WHITE = Display.getDefault().getSystemColor(1);
    protected static final Color BLACK = Display.getDefault().getSystemColor(2);
    protected static final Color RED = Display.getDefault().getSystemColor(3);
    protected static final Color[] COLORS = new Color[]{RED, Display.getDefault().getSystemColor(5), Display.getDefault().getSystemColor(9), Display.getDefault().getSystemColor(7), Display.getDefault().getSystemColor(11), Display.getDefault().getSystemColor(13), BLACK, new Color((Device)Display.getDefault(), 64, 128, 128), new Color((Device)Display.getDefault(), 255, 165, 0), new Color((Device)Display.getDefault(), 128, 128, 128)};
    protected Chart chart = null;
    protected String title = null;

    public abstract void updateDataSet();

    public AbstractChartBuilder(IAdapter adapter, Composite parent, int style, String title) {
        super(parent, style);
        this.adapter = adapter;
        this.title = title;
        this.setLayout((Layout)new FillLayout());
        IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
        this.maxItems = Math.min(store.getInt("ViewableDataItems"), store.getInt("MaxDataItems"));
    }

    public void build() {
        this.createChart();
        this.buildPlot();
        this.buildLegend();
        this.buildTitle();
        this.buildXAxis();
        this.buildYAxis();
        this.buildXSeries();
        this.buildYSeries();
        this.updateDataSet();
    }

    protected void createChart() {
        this.chart = new Chart((Composite)this, this.getStyle());
    }

    protected void buildPlot() {
        this.chart.setBackground(WHITE);
        this.chart.setBackgroundInPlotArea(WHITE);
    }

    protected void buildXAxis() {
    }

    protected void buildYAxis() {
    }

    protected void buildXSeries() {
    }

    protected void buildYSeries() {
    }

    protected void buildLegend() {
        this.chart.getLegend().setPosition(131072);
    }

    protected void buildTitle() {
        ITitle ctitle = this.chart.getTitle();
        ctitle.setForeground(BLACK);
        ctitle.setText(this.title);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.handleUpdateEvent();
    }

    protected Double getDoubleValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        try {
            return new Double(o.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void handleUpdateEvent() {
        if (!this.chart.isDisposed()) {
            this.repaint();
        }
    }

    protected void repaint() {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractChartBuilder.this.updateDataSet();
            }
        });
    }
}

