/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.charts;

import org.eclipse.linuxtools.dataviewers.piechart.PieChart;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.charts.AbstractChartWithoutAxisBuilder;
import org.eclipse.swt.widgets.Composite;

public class PieChartBuilder
extends AbstractChartWithoutAxisBuilder {
    public static final String ID = "org.eclipse.linuxtools.systemtap.graphingapi.ui.charts.piechartbuilder";

    public PieChartBuilder(Composite parent, int style, String title, IAdapter adapter) {
        super(adapter, parent, style, title);
    }

    @Override
    protected void createChart() {
        String[] allNames = this.adapter.getLabels();
        String[] ySeriesNames = new String[allNames.length - 1];
        int i = 0;
        while (i < ySeriesNames.length) {
            ySeriesNames[i] = allNames[i + 1];
            ++i;
        }
        this.chart = new PieChart((Composite)this, this.getStyle(), ySeriesNames);
    }

    @Override
    protected void buildXSeries() {
        Object[][] data = this.adapter.getData();
        if (data == null || data.length == 0 || data[0].length == 0) {
            return;
        }
        int start = 0;
        int len = Math.min(this.maxItems, data.length);
        int leny = data[0].length - 1;
        if (this.maxItems < data.length) {
            start = data.length - this.maxItems;
        }
        Double[][] all_values = new Double[len][leny];
        String[] all_labels = new String[len];
        int i = 0;
        while (i < all_labels.length) {
            if (data[i].length < 2) {
                return;
            }
            Object label = data[start + i][0];
            if (label != null) {
                all_labels[i] = data[start + i][0].toString();
                int j = 1;
                while (j < data[start + i].length) {
                    Double val = this.getDoubleValue(data[start + i][j]);
                    if (val == null) {
                        all_labels[i] = null;
                        break;
                    }
                    all_values[i][j - 1] = val;
                    ++j;
                }
            }
            ++i;
        }
        double[][] values = new double[len][leny];
        String[] labels = new String[len];
        int len_trim = 0;
        int i2 = 0;
        while (i2 < len) {
            if (all_labels[i2] != null) {
                labels[len_trim] = all_labels[i2];
                int j = 0;
                while (j < leny) {
                    values[len_trim][j] = all_values[i2][j];
                    ++j;
                }
                ++len_trim;
            }
            ++i2;
        }
        double[][] values_trim = new double[len_trim][leny];
        String[] labels_trim = new String[len_trim];
        int i3 = 0;
        while (i3 < len_trim) {
            labels_trim[i3] = labels[i3];
            int j = 0;
            while (j < leny) {
                values_trim[i3][j] = values[i3][j];
                ++j;
            }
            ++i3;
        }
        ((PieChart)this.chart).addPieChartSeries(labels_trim, values_trim);
        this.chart.redraw();
    }

    @Override
    public void updateDataSet() {
        this.buildXSeries();
    }
}

