/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.GraphModel;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.SelectGraphAndSeriesWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class SelectGraphAndSeriesWizard
extends Wizard
implements INewWizard {
    public SelectGraphAndSeriesWizardPage selectGraphandSeriesPage;
    public GraphModel model;
    private boolean edit;

    public SelectGraphAndSeriesWizard(IDataSet data, GraphData gdata) {
        this.model = new GraphModel(data);
        boolean bl = this.edit = gdata != null;
        if (this.edit) {
            this.model.setGraph(gdata.graphID);
            this.model.setKey(gdata.key);
            this.model.setTitle(gdata.title);
            this.model.setXSeries(gdata.xSeries);
            this.model.setYSeries(gdata.ySeries);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Localization.getString(!this.edit ? "SelectGraphAndSeriesWizard.CreateGraph" : "SelectGraphAndSeriesWizard.EditGraph"));
        this.selectGraphandSeriesPage = new SelectGraphAndSeriesWizardPage();
        this.addPage((IWizardPage)this.selectGraphandSeriesPage);
    }

    public boolean canFinish() {
        return this.selectGraphandSeriesPage.isPageComplete();
    }

    public boolean performCancel() {
        this.model.destroy();
        return true;
    }

    public boolean performFinish() {
        return true;
    }

    public GraphData getGraphData() {
        return this.model.getGraphData();
    }

    public boolean isEditing() {
        return this.edit;
    }
}

