/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.graphing.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.systemtap.ui.graphing.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IFilteredDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

@Deprecated
public class ImportDataSetAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private String id;
    private String[] labels;

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction act) {
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 4096);
        dialog.setText(Localization.getString("ImportDataSetAction.OpenDataSetFile"));
        String fileName = dialog.open();
        File f = null;
        if (fileName == null || fileName.length() <= 0) {
            return;
        }
        f = new File(fileName);
        if (!f.exists() || !f.canRead()) {
            return;
        }
        IDataSet dataSet = this.readFile(f);
        if (dataSet == null) {
            MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Localization.getString("ImportDataSetAction.Problem"), (String)Localization.getString("ImportDataSetAction.ErrorReadingDataSet"));
            return;
        }
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor");
        ((GraphSelectorEditor)ivp).createScriptSet(fileName, dataSet);
    }

    public void selectionChanged(IAction a, ISelection s) {
    }

    private IDataSet readFile(File f) {
        this.readHeader(f);
        if (this.labels == null || this.id == null) {
            return null;
        }
        IFilteredDataSet data = DataSetFactory.createFilteredDataSet((String)this.id, (String[])this.labels);
        data.readFromFile(f);
        return data;
    }

    private void readHeader(File f) {
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            this.id = br.readLine();
            String line = br.readLine();
            br.close();
            this.labels = line.split(", ");
        }
        catch (FileNotFoundException fnfe) {
            ExceptionErrorDialog.openError((String)Localization.getString("ImportDataSetAction.UnableToReadHeader"), (Exception)fnfe);
        }
        catch (IOException ioe) {
            ExceptionErrorDialog.openError((String)Localization.getString("ImportDataSetAction.UnableToReadHeader"), (Exception)ioe);
        }
    }

    public void dispose() {
        this.fWindow = null;
    }
}

