/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPerspective;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.RunScriptHandler;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.ChartStreamDaemon;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.listeners.IGobblerListener;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class RunScriptChartHandler
extends RunScriptHandler {
    private List<IDataSetParser> parsers;
    private List<IDataSet> dataSets;
    private List<String> names;
    private List<LinkedList<GraphData>> graphs;

    public RunScriptChartHandler(List<IDataSetParser> parsers, List<IDataSet> dataSet, List<String> names, List<LinkedList<GraphData>> graphs) {
        this.parsers = parsers;
        this.dataSets = dataSet;
        this.names = names;
        this.graphs = graphs;
    }

    @Override
    protected void scriptConsoleInitialized(ScriptConsole console) {
        int n = this.parsers.size();
        int i = 0;
        while (i < n) {
            console.getCommand().addInputStreamListener((IGobblerListener)new ChartStreamDaemon(this.dataSets.get(i), this.parsers.get(i)));
            ++i;
        }
        try {
            String name = console.getName();
            String title = name.substring(name.lastIndexOf(47) + 1);
            IWorkbenchPage p = PlatformUI.getWorkbench().showPerspective(IDEPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            GraphSelectorEditor ivp = (GraphSelectorEditor)p.openEditor((IEditorInput)new GraphSelectorEditorInput(title), "org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor");
            String scriptName = console.getName();
            ivp.createScriptSets(scriptName, this.names, this.dataSets);
            int i2 = 0;
            while (i2 < n) {
                for (GraphData graph : this.graphs.get(i2)) {
                    ivp.getDisplaySet(i2).addGraph(graph);
                }
                ++i2;
            }
        }
        catch (WorkbenchException we) {
            ExceptionErrorDialog.openError((String)Messages.RunScriptChartAction_couldNotSwitchToGraphicPerspective, (Exception)((Object)we));
        }
    }
}

