/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.RunScriptChartHandler;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.RunScriptHandler;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.SystemTapScriptGraphOptionsTab;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.IDEPreferenceConstants;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;

public class SystemTapScriptLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    static final String CONFIGURATION_TYPE = "org.eclipse.linuxtools.systemtap.ui.ide.SystemTapLaunchConfigurationType";
    private IProject[] scriptProject;

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) {
        return this.scriptProject;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IProject[] iProjectArray;
        IPath path = Path.fromOSString((String)configuration.getAttribute("ScriptPath", null));
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (file == null) {
            iProjectArray = null;
        } else {
            IProject[] iProjectArray2 = new IProject[1];
            iProjectArray = iProjectArray2;
            iProjectArray2[0] = file.getProject();
        }
        this.scriptProject = iProjectArray;
        if (this.scriptProject != null) {
            return super.preLaunchCheck(configuration, mode, monitor);
        }
        return true;
    }

    private String getPluginID() {
        return ((Object)((Object)this)).getClass().getPackage().getName();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        RunScriptHandler action;
        if (!SystemTapScriptGraphOptionsTab.isValidLaunch(configuration)) {
            throw new CoreException((IStatus)new Status(4, this.getPluginID(), Messages.SystemTapScriptLaunchError_graph));
        }
        IPreferenceStore preferenceStore = ConsoleLogPlugin.getDefault().getPreferenceStore();
        boolean runWithChart = configuration.getAttribute("runWithChart", false);
        int numGraphs = configuration.getAttribute("numberOfRegexs", 0);
        if (runWithChart && numGraphs > 0) {
            ArrayList<IDataSetParser> parsers = SystemTapScriptGraphOptionsTab.createDatasetParsers(configuration);
            ArrayList<IDataSet> dataSets = SystemTapScriptGraphOptionsTab.createDataset(configuration);
            ArrayList<String> names = SystemTapScriptGraphOptionsTab.createDatasetNames(configuration);
            ArrayList<LinkedList<GraphData>> graphs = SystemTapScriptGraphOptionsTab.createGraphsFromConfiguration(configuration);
            action = new RunScriptChartHandler(parsers, dataSets, names, graphs);
        } else {
            action = new RunScriptHandler();
        }
        Path scriptPath = new Path(configuration.getAttribute("ScriptPath", ""));
        if (!scriptPath.toFile().exists()) {
            throw new CoreException((IStatus)new Status(4, this.getPluginID(), MessageFormat.format(Messages.SystemTapScriptLaunchError_fileNotFound, scriptPath.toString())));
        }
        String extension = scriptPath.getFileExtension();
        if (extension == null || !extension.equals("stp")) {
            throw new CoreException((IStatus)new Status(4, this.getPluginID(), MessageFormat.format(Messages.SystemTapScriptLaunchError_fileNotStp, scriptPath.toString())));
        }
        action.setPath((IPath)scriptPath);
        String userName = configuration.getAttribute("userName", "");
        preferenceStore.setValue("scpuser", userName);
        String password = configuration.getAttribute("userPassword", "");
        preferenceStore.setValue("scppassword", password);
        boolean runAsCurrentUser = configuration.getAttribute("executeAsCurrentUser", true);
        boolean runLocal = configuration.getAttribute("executeOnLocalHost", true);
        action.setLocalScript(runLocal && runAsCurrentUser);
        String hostName = configuration.getAttribute("hostName", "localhost");
        preferenceStore.setValue("host", hostName);
        String value = configuration.getAttribute(IDEPreferenceConstants.STAP_CMD_OPTION[2], "");
        if (!value.isEmpty()) {
            action.addComandLineOptions(String.valueOf(IDEPreferenceConstants.STAP_CMD_OPTION[0]) + " " + value);
        }
        int i = 0;
        while (i < IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length) {
            boolean flag = configuration.getAttribute(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][2], false);
            if (flag) {
                action.addComandLineOptions(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][0]);
            }
            ++i;
        }
        i = 0;
        while (i < IDEPreferenceConstants.STAP_STRING_OPTIONS.length) {
            value = configuration.getAttribute(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][2], "");
            if (!value.isEmpty()) {
                action.addComandLineOptions(String.valueOf(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][0]) + " " + value);
            }
            ++i;
        }
        value = configuration.getAttribute("MiscComandLineOptions", "");
        if (!value.isEmpty()) {
            action.addComandLineOptions(value);
        }
        action.execute(null);
    }
}

