/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDECloseMonitor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class IDEPlugin
extends AbstractUIPlugin {
    private IWorkbenchListener workbenchListener;
    private static IDEPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.systemtap.ui.ide";
    public static final String SPACE = "space";
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String TAB = "tab";

    public IDEPlugin() {
        plugin = this;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.workbenchListener = new IDECloseMonitor();
        plugin.getWorkbench().addWorkbenchListener(this.workbenchListener);
        TapsetLibrary.init();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        TapsetLibrary.stop();
        ScriptConsole.stopAll();
        plugin.getWorkbench().removeWorkbenchListener(this.workbenchListener);
        plugin = null;
    }

    public static IDEPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public URI createRemoteUri(String path) {
        IPreferenceStore p = ConsoleLogPlugin.getDefault().getPreferenceStore();
        String user = p.getString("scpuser");
        String host = p.getString("host");
        if (path == null) {
            path = "";
        }
        try {
            URI uri = new URI("ssh", user, host, -1, path, null, null);
            return uri;
        }
        catch (URISyntaxException uri) {
            return null;
        }
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        IDEPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }

    public static void logException(Throwable e, final String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PLUGIN_ID, 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        final IStatus fstatus = status;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError(null, (String)title, null, (IStatus)fstatus);
            }
        });
    }

    public static void logException(Throwable e) {
        IDEPlugin.logException(e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PLUGIN_ID, 0, e.getMessage(), e);
        IDEPlugin.log(status);
    }
}

