/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.git.core;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ptp.internal.rdt.sync.git.core.Activator;
import org.eclipse.ptp.internal.rdt.sync.git.core.GitRemoteSyncConnection;
import org.eclipse.ptp.internal.rdt.sync.git.core.GitSyncFileFilter;
import org.eclipse.ptp.internal.rdt.sync.git.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.exceptions.RemoteSyncException;
import org.eclipse.ptp.rdt.sync.core.services.AbstractSynchronizeService;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeServiceDescriptor;

public class GitSyncService
extends AbstractSynchronizeService {
    private boolean hasBeenSynced = false;
    private static final ReentrantLock syncLock = new ReentrantLock();
    private Integer fWaitingThreadsCount = 0;
    private Integer syncTaskId = -1;
    private int finishedSyncTaskId = -1;
    private final Map<ProjectAndScenario, GitRemoteSyncConnection> syncConnectionMap = Collections.synchronizedMap(new HashMap());

    public GitSyncService(ISynchronizeServiceDescriptor descriptor) {
        super(descriptor);
    }

    public void checkout(IProject project, SyncConfig syncConfig, IPath[] paths) throws RemoteSyncException {
        GitRemoteSyncConnection fSyncConnection = this.getSyncConnection(project, syncConfig, null);
        if (fSyncConnection != null) {
            fSyncConnection.checkout(paths);
        }
    }

    public void checkoutRemoteCopy(IProject project, SyncConfig syncConfig, IPath[] paths) throws RemoteSyncException {
        GitRemoteSyncConnection fSyncConnection = this.getSyncConnection(project, syncConfig, null);
        if (fSyncConnection != null) {
            fSyncConnection.checkoutRemoteCopy(paths);
        }
    }

    public void close(IProject project) {
        for (Map.Entry<ProjectAndScenario, GitRemoteSyncConnection> entry : this.syncConnectionMap.entrySet()) {
            if (entry.getKey().project != project) continue;
            entry.getValue().close();
        }
    }

    public Set<IPath> getMergeConflictFiles(IProject project, SyncConfig syncConfig) throws RemoteSyncException {
        GitRemoteSyncConnection fSyncConnection = this.getSyncConnection(project, syncConfig, null);
        if (fSyncConnection == null) {
            return new HashSet<IPath>();
        }
        return fSyncConnection.getMergeConflictFiles();
    }

    public String[] getMergeConflictParts(IProject project, SyncConfig syncConfig, IFile file) throws RemoteSyncException {
        GitRemoteSyncConnection fSyncConnection = this.getSyncConnection(project, syncConfig, null);
        if (fSyncConnection == null) {
            return null;
        }
        return fSyncConnection.getMergeConflictParts(file);
    }

    private synchronized GitRemoteSyncConnection getSyncConnection(IProject project, SyncConfig syncConfig, IProgressMonitor monitor) throws RemoteSyncException {
        try {
            if (syncConfig.getSyncProviderId() == null) {
                return null;
            }
            ProjectAndScenario pas = new ProjectAndScenario(project, syncConfig);
            if (!this.syncConnectionMap.containsKey(pas)) {
                try {
                    GitRemoteSyncConnection grsc = new GitRemoteSyncConnection(project, project.getLocation().toString(), syncConfig, this.getSyncFileFilter(project), monitor);
                    this.syncConnectionMap.put(pas, grsc);
                }
                catch (MissingConnectionException missingConnectionException) {
                    if (monitor != null) {
                        monitor.done();
                    }
                    return null;
                }
            }
            GitRemoteSyncConnection fSyncConnection = this.syncConnectionMap.get(pas);
            fSyncConnection.setFileFilter(this.getSyncFileFilter(project));
            GitRemoteSyncConnection gitRemoteSyncConnection = fSyncConnection;
            return gitRemoteSyncConnection;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean irrelevantPath(IProject project, IResource resource) {
        if (SyncManager.getFileFilter((IProject)project).shouldIgnore(resource)) {
            return true;
        }
        String path = resource.getFullPath().toString();
        if (path.endsWith("/.ptp-sync")) {
            return true;
        }
        if (path.endsWith("/.git")) {
            return true;
        }
        return path.endsWith("/.settings");
    }

    public void setMergeAsResolved(IProject project, SyncConfig syncConfig, IPath[] paths) throws RemoteSyncException {
        GitRemoteSyncConnection fSyncConnection = this.getSyncConnection(project, syncConfig, null);
        if (fSyncConnection != null) {
            fSyncConnection.setMergeAsResolved(paths);
        }
    }

    /*
     * Exception decompiling
     */
    public void synchronize(IProject project, SyncConfig syncConfig, IResourceDelta delta, IProgressMonitor monitor, EnumSet<SyncFlag> syncFlags) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AbstractSyncFileFilter getSyncFileFilter(IProject project) {
        return GitSyncFileFilter.getFilter(project);
    }

    public void setSyncFileFilter(IProject project, AbstractSyncFileFilter filter) {
        Repository repository;
        try {
            repository = GitRemoteSyncConnection.getLocalRepo(project.getLocation().toString());
        }
        catch (IOException e) {
            Activator.log("Unable to save file filter for project " + project.getName(), e);
            return;
        }
        assert (repository != null) : Messages.GitSyncService_0;
        GitSyncFileFilter.setFilter(project, filter, repository);
    }

    private static class ProjectAndScenario {
        private final IProject project;
        private final SyncConfig scenario;
        private final String projectLocation;

        ProjectAndScenario(IProject p, SyncConfig bs) {
            this.project = p;
            this.scenario = bs;
            this.projectLocation = p.getLocation().toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectAndScenario other = (ProjectAndScenario)obj;
            if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
                return false;
            }
            if (this.projectLocation == null ? other.projectLocation != null : !this.projectLocation.equals(other.projectLocation)) {
                return false;
            }
            return !(this.scenario == null ? other.scenario != null : !this.scenario.equals((Object)other.scenario));
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            result = 31 * result + (this.projectLocation == null ? 0 : this.projectLocation.hashCode());
            result = 31 * result + (this.scenario == null ? 0 : this.scenario.hashCode());
            return result;
        }
    }
}

