/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class AggregateLayoutAlgorithm
extends GridLayoutAlgorithm {
    protected ArrayList<Long> list = new ArrayList();
    protected Long totalTime;
    protected int graphWidth;

    public AggregateLayoutAlgorithm(int styles, TreeSet<Map.Entry<String, Long>> entries, Long time, int width) {
        super(styles);
        for (Map.Entry<String, Long> ent : entries) {
            this.list.add(ent.getValue());
        }
        this.totalTime = time;
        this.graphWidth = width;
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
        int minimumSize = 40;
        double xcursor = 0.0;
        double ycursor = 0.0;
        InternalNode[] internalNodeArray = entitiesToLayout;
        int n = entitiesToLayout.length;
        int n2 = 0;
        while (n2 < n) {
            InternalNode sn = internalNodeArray[n2];
            Long time = this.list.remove(0);
            double percent = (double)time.longValue() / (double)this.totalTime.longValue();
            double snWidth = sn.getInternalWidth() * percent + 40.0;
            double snHeight = sn.getInternalHeight() * percent + 40.0;
            sn.setSize(snWidth, snHeight);
            if (xcursor + snWidth > (double)this.graphWidth) {
                xcursor = 0.0;
                sn.setLocation(xcursor, ycursor += snHeight);
            } else {
                sn.setLocation(xcursor, ycursor);
                xcursor += snWidth;
            }
            ++n2;
        }
    }
}

