/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.nio.ByteOrder;
import org.eclipse.linuxtools.ctf.core.event.types.FloatDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;

public class FloatDeclaration
implements IDeclaration {
    private final int mant;
    private final int exp;
    private final ByteOrder byteOrder;
    private final long alignment;

    public FloatDeclaration(int exponent, int mantissa, ByteOrder byteOrder, long alignment) {
        this.mant = mantissa;
        this.exp = exponent;
        this.byteOrder = byteOrder;
        this.alignment = Math.max(alignment, 1L);
    }

    public int getMantissa() {
        return this.mant;
    }

    public int getExponent() {
        return this.exp;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public long getAlignment() {
        return this.alignment;
    }

    @Override
    public FloatDefinition createDefinition(IDefinitionScope definitionScope, String fieldName) {
        return new FloatDefinition(this, definitionScope, fieldName);
    }

    public String toString() {
        return "[declaration] float[" + Integer.toHexString(this.hashCode()) + ']';
    }
}

