/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.listeners.IGobblerListener;
import org.eclipse.linuxtools.systemtap.structures.runnable.Command;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ScpExec;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ConsoleStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ErrorStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;
import org.eclipse.linuxtools.systemtap.ui.consolelog.views.ErrorView;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;

public class ScriptConsole
extends IOConsole {
    private static final long RETRY_STOP_TIME = 500L;
    private Command cmd = null;
    private Runnable stopCommand;
    private Thread stopCommandThread;
    private Thread onCmdStopThread;
    private Thread onCmdStartThread;
    private String moduleName;
    private ErrorStreamDaemon errorDaemon;
    private ConsoleStreamDaemon consoleDaemon;
    private final LinkedList<ScriptConsoleObserver> activeConsoleObservers = new LinkedList();

    public static ScriptConsole getInstance(String name) {
        ScriptConsole console = null;
        try {
            IConsole[] ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            if (ic != null) {
                IConsole[] iConsoleArray = ic;
                int n = ic.length;
                int n2 = 0;
                while (n2 < n) {
                    ScriptConsole activeConsole;
                    IConsole consoleIterator = iConsoleArray[n2];
                    if (consoleIterator instanceof ScriptConsole && (activeConsole = (ScriptConsole)consoleIterator).getName().endsWith(name)) {
                        if (activeConsole.isRunning()) {
                            activeConsole.onCmdStopThread.interrupt();
                            activeConsole.stop();
                            if (activeConsole.errorDaemon != null) {
                                activeConsole.cmd.removeErrorStreamListener((IGobblerListener)activeConsole.errorDaemon);
                            }
                            activeConsole.cmd.removeInputStreamListener((IGobblerListener)activeConsole.consoleDaemon);
                        }
                        activeConsole.clearConsole();
                        activeConsole.setName(name);
                        console = activeConsole;
                    }
                    ++n2;
                }
            }
            if (console == null) {
                console = new ScriptConsole(name, null);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            }
        }
        catch (NullPointerException npe) {
            console = null;
        }
        return console;
    }

    public static boolean anyRunning() {
        IConsole[] ic;
        IConsole[] iConsoleArray = ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = ic.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptConsole console;
            IConsole con = iConsoleArray[n2];
            if (con instanceof ScriptConsole && (console = (ScriptConsole)con).isRunning()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void stopAll() {
        IConsole[] ic;
        IConsole[] iConsoleArray = ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = ic.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole con = iConsoleArray[n2];
            if (con instanceof ScriptConsole) {
                ScriptConsole console = (ScriptConsole)con;
                console.stop();
            }
            ++n2;
        }
    }

    ScriptConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
    }

    protected void createConsoleDaemon() {
        this.consoleDaemon = new ConsoleStreamDaemon(this);
    }

    protected void createErrorDaemon(IErrorParser parser) {
        ErrorView errorView = null;
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.consolelog.views.ErrorView");
        if (ivp instanceof ErrorView) {
            errorView = (ErrorView)ivp;
        }
        this.errorDaemon = new ErrorStreamDaemon(this, errorView, parser);
    }

    public void run(String[] command, String[] envVars, IErrorParser errorParser) {
        if (this.onCmdStartThread != null && this.onCmdStartThread.isAlive()) {
            return;
        }
        this.cmd = new ScpExec(command);
        this.stopCommand = new Runnable(){
            private final Command stopcmd;
            private final String stopString;
            {
                this.stopcmd = ScriptConsole.this.cmd;
                this.stopString = ScriptConsole.this.getStopString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ScpExec stop = new ScpExec(new String[]{this.stopString});
                try {
                    do {
                        stop.start();
                        Command command = this.stopcmd;
                        synchronized (command) {
                            this.stopcmd.wait(500L);
                        }
                    } while (this.stopcmd.isRunning());
                }
                catch (CoreException coreException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.run(this.cmd, errorParser);
    }

    public void runLocally(String[] command, String[] envVars, IErrorParser errorParser) {
        this.runLocally(command, envVars, errorParser, null);
    }

    public void runLocally(String[] command, String[] envVars, IErrorParser errorParser, IProject project) {
        if (this.onCmdStartThread != null && this.onCmdStartThread.isAlive()) {
            return;
        }
        this.cmd = new Command(command, envVars, project);
        final IProject proj = project;
        this.stopCommand = new Runnable(){
            private final Command stopcmd;
            String stopString;
            {
                this.stopcmd = ScriptConsole.this.cmd;
                this.stopString = ScriptConsole.this.getStopString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    do {
                        RuntimeProcessFactory.getFactory().exec(this.stopString, null, proj);
                        Command command = this.stopcmd;
                        synchronized (command) {
                            this.stopcmd.wait(500L);
                        }
                    } while (this.stopcmd.isRunning());
                }
                catch (IOException e) {
                    ExceptionErrorDialog.openError((String)Localization.getString("ScriptConsole.ErrorKillingStap"), (Exception)e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.run(this.cmd, errorParser);
    }

    private void run(final Command cmd, IErrorParser errorParser) {
        final Runnable onCmdStop = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Command command = cmd;
                    synchronized (command) {
                        cmd.wait();
                    }
                    ScriptConsole.this.onCmdStopActions();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        Runnable onCmdStart = new Runnable(){

            @Override
            public void run() {
                if (ScriptConsole.this.stopCommandThread != null && ScriptConsole.this.stopCommandThread.isAlive()) {
                    try {
                        ScriptConsole.this.stopCommandThread.join();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                ScriptConsole.this.createConsoleDaemon();
                if (ScriptConsole.this.errorDaemon != null) {
                    cmd.addErrorStreamListener((IGobblerListener)ScriptConsole.this.errorDaemon);
                }
                cmd.addInputStreamListener((IGobblerListener)ScriptConsole.this.consoleDaemon);
                try {
                    cmd.start();
                }
                catch (CoreException e) {
                    ExceptionErrorDialog.openError((String)e.getMessage(), (Exception)((Object)e));
                    ScriptConsole.this.notifyConsoleObservers(false);
                    cmd.dispose();
                    return;
                }
                ScriptConsole.this.notifyConsoleObservers(true);
                ScriptConsole.this.onCmdStopThread = new Thread(onCmdStop);
                ScriptConsole.this.onCmdStopThread.start();
            }
        };
        if (errorParser != null) {
            this.createErrorDaemon(errorParser);
        }
        this.activate();
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this);
        this.onCmdStartThread = new Thread(onCmdStart);
        this.onCmdStartThread.start();
    }

    private final void onCmdStopActions() {
        this.notifyConsoleObservers(false);
    }

    void notifyConsoleObservers(boolean running) {
        for (ScriptConsoleObserver observer : this.activeConsoleObservers) {
            observer.runningStateChanged(running);
        }
    }

    public void addScriptConsoleObserver(ScriptConsoleObserver observer) {
        this.activeConsoleObservers.add(observer);
    }

    public boolean isRunning() {
        if (this.cmd == null) {
            return false;
        }
        return this.cmd.isRunning();
    }

    public boolean isDisposed() {
        if (this.cmd == null) {
            return true;
        }
        return this.cmd.isDisposed();
    }

    public void saveStream(File file) {
        if (this.isRunning() && !this.cmd.saveLog(file)) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Localization.getString("ScriptConsole.Problem"), (String)Localization.getString("ScriptConsole.ErrorSavingLog"));
        }
    }

    public Command getCommand() {
        return this.cmd;
    }

    public synchronized void stop() {
        if (this.isRunning() && (this.stopCommandThread == null || !this.stopCommandThread.isAlive())) {
            this.stopCommandThread = new Thread(this.stopCommand);
            this.stopCommandThread.start();
            this.setName(String.valueOf(Localization.getString("ScriptConsole.Terminated")) + super.getName());
        }
    }

    private String getModuleName() {
        if (this.moduleName == null) {
            int lastDot;
            this.moduleName = this.getName();
            int lastSlash = this.moduleName.lastIndexOf(47) + 1;
            if (lastSlash < 0) {
                lastSlash = 0;
            }
            if ((lastDot = this.moduleName.indexOf(".stp")) > 0) {
                this.moduleName = this.moduleName.substring(lastSlash, lastDot);
            }
        }
        return this.moduleName;
    }

    private String getStopString() {
        return "pkill -SIGINT -f stapio.*" + this.getModuleName();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            if (this.cmd != null) {
                this.cmd.dispose();
            }
            this.cmd = null;
            if (this.errorDaemon != null) {
                this.errorDaemon.dispose();
            }
            this.errorDaemon = null;
            if (this.consoleDaemon != null) {
                this.consoleDaemon.dispose();
            }
            this.consoleDaemon = null;
        }
    }

    public void setName(String name) {
        super.setName(name);
        if (ConsolePlugin.getDefault() != null) {
            ConsolePlugin.getDefault().getConsoleManager().refresh((IConsole)this);
        }
    }

    public static interface ScriptConsoleObserver {
        public void runningStateChanged(boolean var1);
    }
}

