/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.charts;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.GraphingAPIUIPlugin;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IAxis;
import org.swtchart.ISeries;
import org.swtchart.ITitle;
import org.swtchart.LineStyle;

public abstract class AbstractChartWithAxisBuilder
extends AbstractChartBuilder {
    protected String xTitle = null;
    protected boolean xLineGrid;
    protected boolean yLineGrid;

    protected abstract ISeries createChartISeries(int var1);

    public AbstractChartWithAxisBuilder(IAdapter adapter, Composite parent, int style, String title) {
        super(adapter, parent, style, title);
        IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
        this.xLineGrid = store.getBoolean("ShowXGridLines");
        this.yLineGrid = store.getBoolean("ShowYGridLines");
    }

    @Override
    protected void buildXAxis() {
        String[] labels = this.adapter.getLabels();
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        if (this.xLineGrid) {
            xAxis.getGrid().setStyle(LineStyle.SOLID);
        } else {
            xAxis.getGrid().setStyle(LineStyle.NONE);
        }
        xAxis.getTick().setForeground(BLACK);
        ITitle xTitle = xAxis.getTitle();
        xTitle.setForeground(BLACK);
        if (labels.length > 0) {
            xTitle.setText(labels[0]);
        } else {
            xTitle.setText("");
        }
    }

    @Override
    protected void buildYAxis() {
        IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
        yAxis.getTitle().setText("");
        if (this.yLineGrid) {
            yAxis.getGrid().setStyle(LineStyle.SOLID);
        } else {
            yAxis.getGrid().setStyle(LineStyle.NONE);
        }
        yAxis.getTick().setForeground(BLACK);
    }

    @Override
    protected void buildXSeries() {
        Object[][] data = this.adapter.getData();
        if (data == null || data.length == 0) {
            return;
        }
        int totalMaxItems = (int)Math.round((double)this.maxItems * this.scale);
        int start = 0;
        int len = Math.min(totalMaxItems, data.length);
        int leny = data[0].length - 1;
        if (totalMaxItems < data.length) {
            start = data.length - totalMaxItems;
        }
        Double[] all_valx = new Double[len];
        Double[][] all_valy = new Double[leny][len];
        ISeries[] allSeries = this.chart.getSeriesSet().getSeries();
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < leny + 1) {
                Double val = this.getDoubleValue(data[start + i][j]);
                if (j == 0) {
                    if (val == null) break;
                    all_valx[i] = val;
                } else if (val != null) {
                    all_valy[j - 1][i] = val;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < leny) {
            ISeries series = i >= allSeries.length ? this.createChartISeries(i) : this.chart.getSeriesSet().getSeries()[i];
            double[] valx = new double[len];
            double[] valy = new double[len];
            int len_trim = 0;
            int j = 0;
            while (j < len) {
                if (all_valx[j] != null && all_valy[i][j] != null) {
                    valx[len_trim] = all_valx[j];
                    valy[len_trim] = all_valy[i][j];
                    ++len_trim;
                }
                ++j;
            }
            double[] valx_trim = new double[len_trim];
            double[] valy_trim = new double[len_trim];
            int j2 = 0;
            while (j2 < len_trim) {
                valx_trim[j2] = valx[j2];
                valy_trim[j2] = valy[j2];
                ++j2;
            }
            series.setXSeries(valx_trim);
            series.setYSeries(valy_trim);
            ++i;
        }
        this.chart.getAxisSet().adjustRange();
        this.chart.redraw();
    }
}

