/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.provisional.IChildrenRequestMonitor;

class ChildrenRequestMonitor
extends AsynchronousRequestMonitor
implements IChildrenRequestMonitor {
    private boolean fFirstUpdate = true;
    private List fChildren = new ArrayList();

    ChildrenRequestMonitor(ModelNode parent, AsynchronousModel model) {
        super(parent, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Object child) {
        List list = this.fChildren;
        synchronized (list) {
            this.fChildren.add(child);
        }
        this.scheduleViewerUpdate(250L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren(Object[] children) {
        List list = this.fChildren;
        synchronized (list) {
            int i = 0;
            while (i < children.length) {
                this.fChildren.add(children[i]);
                ++i;
            }
        }
        this.scheduleViewerUpdate(0L);
    }

    protected boolean contains(AsynchronousRequestMonitor update) {
        return update instanceof ChildrenRequestMonitor && this.contains(update.getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performUpdate() {
        List list = this.fChildren;
        synchronized (list) {
            if (this.fFirstUpdate) {
                this.getModel().setChildren(this.getNode(), this.fChildren);
                this.fFirstUpdate = false;
            } else {
                Iterator iter = this.fChildren.iterator();
                while (iter.hasNext()) {
                    Object child = iter.next();
                    this.getModel().add(this.getNode(), child);
                }
            }
            this.fChildren.clear();
        }
    }
}

