/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.linuxtools.internal.tmf.ui.commands.ExportToTextJob;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class ExportToTextCommandHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.exportToText";
    public static final String TMF_EVENT_TABLE_PARAMETER_ID = "org.eclipse.linuxtools.tmf.ui.exportToText.table";
    public static final String TMF_EVENT_TABLE_HEADER_ID = "org.eclipse.linuxtools.tmf.ui.exportToText.header";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String header = ExportToTextCommandHandler.getHeader(event.getApplicationContext());
        TmfEventsTable table = ExportToTextCommandHandler.getTable(event.getApplicationContext());
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        ITmfFilter filter = TmfTraceManager.getInstance().getCurrentFilter();
        if (trace != null) {
            FileDialog fd = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
            fd.setFilterExtensions(new String[]{"*.csv", "*.*", "*"});
            fd.setOverwrite(true);
            String s = fd.open();
            if (s != null) {
                ExportToTextJob j = new ExportToTextJob(trace, filter, table, header, s);
                j.setUser(true);
                j.schedule();
            }
        }
        return null;
    }

    private static String getHeader(Object evaluationContext) {
        Object s;
        if (evaluationContext instanceof IEvaluationContext && (s = ((IEvaluationContext)evaluationContext).getVariable(TMF_EVENT_TABLE_HEADER_ID)) instanceof String) {
            return s.toString();
        }
        return null;
    }

    private static TmfEventsTable getTable(Object evaluationContext) {
        Object o;
        if (evaluationContext instanceof IEvaluationContext && (o = ((IEvaluationContext)evaluationContext).getVariable(TMF_EVENT_TABLE_PARAMETER_ID)) instanceof TmfEventsTable) {
            return (TmfEventsTable)o;
        }
        return null;
    }
}

