/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.dialogs;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.tmf.ui.project.dialogs.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class SelectSupplementaryResourcesDialog
extends Dialog {
    private CheckboxTreeViewer fTreeViewer;
    private final IResource[] fAvailableResources;
    private IResource[] fReturndResources;

    public SelectSupplementaryResourcesDialog(Shell shell, IResource[] resources) {
        super(shell);
        this.fAvailableResources = Arrays.copyOf(resources, resources.length);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    public IResource[] getResources() {
        return Arrays.copyOf(this.fReturndResources, this.fReturndResources.length);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SelectSpplementaryResources_DialogTitle);
        newShell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group contextGroup = new Group(composite, 32);
        contextGroup.setText(Messages.SelectSpplementaryResources_ResourcesGroupTitle);
        contextGroup.setLayout((Layout)new GridLayout(2, false));
        contextGroup.setLayoutData((Object)new GridData(1808));
        this.fTreeViewer = new CheckboxTreeViewer((Composite)contextGroup, 770);
        GridData data = new GridData(1808);
        Tree tree = this.fTreeViewer.getTree();
        tree.setLayoutData((Object)data);
        this.fTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return element instanceof IResource[];
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IResource[]) {
                    return (Object[])parentElement;
                }
                return null;
            }
        });
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IResource) {
                    IResource resource = (IResource)element;
                    return String.valueOf(resource.getParent().getName()) + File.separator + resource.getName();
                }
                return super.getText(element);
            }
        });
        this.fTreeViewer.setInput((Object)this.fAvailableResources);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectSupplementaryResourcesDialog.this.updateOKButtonEnablement();
            }
        });
        Composite btComp = new Composite((Composite)contextGroup, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 4;
        btComp.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        btComp.setLayoutData((Object)gd);
        Button selectAll = new Button(btComp, 8);
        selectAll.setText(Messages.Dialog_SelectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource[] items;
                IResource[] iResourceArray = items = SelectSupplementaryResourcesDialog.this.fAvailableResources;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource treeItem = iResourceArray[n2];
                    SelectSupplementaryResourcesDialog.this.fTreeViewer.setChecked((Object)treeItem, true);
                    ++n2;
                }
                SelectSupplementaryResourcesDialog.this.updateOKButtonEnablement();
            }
        });
        Button deselectAll = new Button(btComp, 8);
        deselectAll.setText(Messages.Dialog_DeselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource[] items;
                IResource[] iResourceArray = items = SelectSupplementaryResourcesDialog.this.fAvailableResources;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource treeItem = iResourceArray[n2];
                    SelectSupplementaryResourcesDialog.this.fTreeViewer.setChecked((Object)treeItem, false);
                    ++n2;
                }
                SelectSupplementaryResourcesDialog.this.updateOKButtonEnablement();
            }
        });
        this.getShell().setMinimumSize(new Point(300, 150));
        return composite;
    }

    private void updateOKButtonEnablement() {
        Object[] checked = this.fTreeViewer.getCheckedElements();
        this.getButton(0).setEnabled(checked.length > 0);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.updateOKButtonEnablement();
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void okPressed() {
        Object[] checked = this.fTreeViewer.getCheckedElements();
        this.fReturndResources = new IResource[checked.length];
        int i = 0;
        while (i < checked.length) {
            this.fReturndResources[i] = (IResource)checked[i];
            ++i;
        }
        super.okPressed();
    }
}

