/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import java.text.ParseException;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramTextControl;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramView;
import org.eclipse.swt.widgets.Composite;

public class HistogramCurrentTimeControl
extends HistogramTextControl {
    public HistogramCurrentTimeControl(HistogramView parentView, Composite parent, String label, long value) {
        super(parentView, parent, label, value);
        TmfSignalManager.register((Object)this);
    }

    @Override
    public void dispose() {
        TmfSignalManager.deregister((Object)this);
    }

    @Override
    protected void updateValue() {
        if (this.getValue() == Long.MIN_VALUE) {
            this.fTextValue.setText("");
            return;
        }
        String string = this.fTextValue.getText();
        long value = this.getValue();
        try {
            value = TmfTimestampFormat.getDefaulTimeFormat().parseValue(string, this.getValue());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.getValue() != value) {
            ITmfTrace trace = this.fParentView.getTrace();
            if (trace != null) {
                TmfTimeRange range = trace.getTimeRange();
                long startTime = range.getStartTime().normalize(0L, -9).getValue();
                long endTime = range.getEndTime().normalize(0L, -9).getValue();
                if (value < startTime) {
                    value = startTime;
                } else if (value > endTime) {
                    value = endTime;
                }
            }
            this.setValue(value);
            this.updateSelectionTime(value);
        } else {
            this.setValue(value);
        }
    }

    protected void updateSelectionTime(long time) {
        this.fParentView.updateSelectionTime(time, time);
    }

    @Override
    public void setValue(long time) {
        if (time != Long.MIN_VALUE) {
            super.setValue(time, new TmfTimestamp(time, -9).toString());
        } else {
            super.setValue(time, "");
        }
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        this.setValue(this.getValue());
    }
}

