/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSymbol;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSymbol;
import org.eclipse.swt.graphics.Image;

public class UiModelImage
implements IUiModelElement {
    private IUiModelElement parent;
    private OpModelImage image;
    private UiModelSymbol[] symbols;
    private int totalCount;
    private int depCount;

    public UiModelImage(IUiModelElement parent, OpModelImage image, int totalCount, int depCount) {
        this.parent = parent;
        this.image = image;
        this.symbols = null;
        this.totalCount = totalCount + depCount;
        this.depCount = depCount;
        this.refreshModel();
    }

    private void refreshModel() {
        OpModelSymbol[] dataModelSymbols = this.image.getSymbols();
        if (dataModelSymbols != null) {
            this.symbols = new UiModelSymbol[dataModelSymbols.length];
            int i = 0;
            while (i < dataModelSymbols.length) {
                this.symbols[i] = new UiModelSymbol(this, dataModelSymbols[i], this.totalCount);
                ++i;
            }
        }
    }

    public String toString() {
        if (this.image.getCount() == -1) {
            return OprofileUiMessages.getString("opxmlParse.error.multipleImages");
        }
        double countPercentage = (double)this.image.getCount() / (double)this.totalCount;
        String percentage = OprofileUiPlugin.getPercentageString(countPercentage);
        return String.valueOf(percentage) + " " + OprofileUiMessages.getString("uimodel.percentage.in") + this.image.getName();
    }

    public String getLabelText() {
        return this.toString();
    }

    public IUiModelElement[] getChildren() {
        IUiModelElement[] children = null;
        if (this.symbols != null) {
            children = new IUiModelElement[this.symbols.length];
            int i = 0;
            while (i < this.symbols.length) {
                children[i] = this.symbols[i];
                ++i;
            }
        }
        return children;
    }

    public boolean hasChildren() {
        return this.symbols != null && this.symbols.length != 0;
    }

    public IUiModelElement getParent() {
        return this.parent;
    }

    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/image.gif").createImage();
    }
}

