/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.daemon;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpEvent;
import org.eclipse.linuxtools.internal.oprofile.core.linux.LinuxOpxmlProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpInfo {
    public static final String DEFAULT_SAMPLE_DIR = "sample-dir";
    public static final String DEFAULT_LOCK_FILE = "lock-file";
    public static final String DEFAULT_LOG_FILE = "log-file";
    public static final String DEFAULT_DUMP_STATUS = "dump-status";
    private int nrCounters;
    private HashMap<String, String> defaults;
    private OpEvent[][] eventList;
    private double cpuSpeed;
    private boolean timerMode;

    public static OpInfo getInfo() {
        OpInfo info = new OpInfo();
        try {
            LinuxOpxmlProvider.OpInfoRunner opxml = (LinuxOpxmlProvider.OpInfoRunner)OprofileCorePlugin.getDefault().getOpxmlProvider().info(info);
            boolean ret = opxml.run0(null);
            if (!ret) {
                info = null;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return info;
    }

    public void setNrCounters(int ctrs) {
        this.nrCounters = ctrs;
        this.eventList = new OpEvent[this.nrCounters][];
    }

    public void setCPUSpeed(double freq) {
        this.cpuSpeed = freq;
    }

    public void setDefaults(HashMap<String, String> map) {
        this.defaults = map;
    }

    public void setEvents(int counterNum, OpEvent[] events) {
        if (counterNum < this.eventList.length) {
            this.eventList[counterNum] = events;
            Arrays.sort(this.eventList[counterNum], new SortEventComparator());
        }
    }

    public void setTimerMode(boolean timerMode) {
        this.timerMode = timerMode;
    }

    public int getNrCounters() {
        return this.nrCounters;
    }

    public double getCPUSpeed() {
        return this.cpuSpeed;
    }

    public String getDefault(String what) {
        return this.defaults.get(what);
    }

    public OpEvent[] getEvents(int num) {
        if (num >= 0 && num < this.eventList.length) {
            return this.eventList[num];
        }
        return new OpEvent[0];
    }

    public boolean getTimerMode() {
        return this.timerMode;
    }

    public OpEvent findEvent(String name) {
        int counter = 0;
        while (counter < this.getNrCounters()) {
            int idx = Arrays.binarySearch(this.getEvents(counter), name, new SearchEventComparator());
            if (idx >= 0) {
                return this.eventList[counter][idx];
            }
            ++counter;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchEventComparator
    implements Comparator<Object> {
        private SearchEventComparator() {
        }

        @Override
        public int compare(Object a, Object b) {
            String bstr;
            String astr;
            if (a instanceof String) {
                astr = (String)a;
                bstr = ((OpEvent)b).getText();
            } else {
                astr = ((OpEvent)a).getText();
                bstr = (String)b;
            }
            return astr.compareTo(bstr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortEventComparator
    implements Comparator<OpEvent> {
        private SortEventComparator() {
        }

        @Override
        public int compare(OpEvent o1, OpEvent o2) {
            return o1.getText().compareTo(o2.getText());
        }
    }
}

