/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.core.control.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IBaseEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IFieldInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceEventType;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceLogLevel;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.FieldInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.TraceInfo;

public class BaseEventInfo
extends TraceInfo
implements IBaseEventInfo {
    private TraceEventType fEventType = TraceEventType.UNKNOWN;
    private TraceLogLevel fLogLevel = TraceLogLevel.TRACE_DEBUG;
    private final List<IFieldInfo> fFields = new ArrayList<IFieldInfo>();
    private String fFilterExpression;

    public BaseEventInfo(String name) {
        super(name);
    }

    public BaseEventInfo(BaseEventInfo other) {
        super(other);
        this.fEventType = other.fEventType;
        for (IFieldInfo field : other.fFields) {
            if (field instanceof FieldInfo) {
                this.fFields.add(new FieldInfo((FieldInfo)field));
                continue;
            }
            this.fFields.add(field);
        }
        this.fFilterExpression = other.fFilterExpression;
    }

    @Override
    public TraceEventType getEventType() {
        return this.fEventType;
    }

    @Override
    public void setEventType(TraceEventType type) {
        this.fEventType = type;
    }

    @Override
    public void setEventType(String typeName) {
        this.fEventType = TraceEventType.TRACEPOINT.getInName().equals(typeName) ? TraceEventType.TRACEPOINT : (TraceEventType.SYSCALL.getInName().equals(typeName) ? TraceEventType.SYSCALL : (TraceEventType.PROBE.getInName().equals(typeName) ? TraceEventType.PROBE : (TraceEventType.FUNCTION.getInName().equals(typeName) ? TraceEventType.FUNCTION : TraceEventType.UNKNOWN)));
    }

    @Override
    public TraceLogLevel getLogLevel() {
        return this.fLogLevel;
    }

    @Override
    public void setLogLevel(TraceLogLevel level) {
        this.fLogLevel = level;
    }

    @Override
    public void setLogLevel(String levelName) {
        this.fLogLevel = TraceLogLevel.TRACE_EMERG.getInName().equals(levelName) ? TraceLogLevel.TRACE_EMERG : (TraceLogLevel.TRACE_ALERT.getInName().equals(levelName) ? TraceLogLevel.TRACE_ALERT : (TraceLogLevel.TRACE_CRIT.getInName().equals(levelName) ? TraceLogLevel.TRACE_CRIT : (TraceLogLevel.TRACE_ERR.getInName().equals(levelName) ? TraceLogLevel.TRACE_ERR : (TraceLogLevel.TRACE_WARNING.getInName().equals(levelName) ? TraceLogLevel.TRACE_WARNING : (TraceLogLevel.TRACE_NOTICE.getInName().equals(levelName) ? TraceLogLevel.TRACE_NOTICE : (TraceLogLevel.TRACE_INFO.getInName().equals(levelName) ? TraceLogLevel.TRACE_INFO : (TraceLogLevel.TRACE_DEBUG_SYSTEM.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_SYSTEM : (TraceLogLevel.TRACE_DEBUG_PROGRAM.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_PROGRAM : (TraceLogLevel.TRACE_DEBUG_PROCESS.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_PROCESS : (TraceLogLevel.TRACE_DEBUG_MODULE.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_MODULE : (TraceLogLevel.TRACE_DEBUG_UNIT.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_UNIT : (TraceLogLevel.TRACE_DEBUG_FUNCTION.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_FUNCTION : (TraceLogLevel.TRACE_DEBUG_LINE.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_LINE : (TraceLogLevel.TRACE_DEBUG.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG : (TraceLogLevel.LEVEL_UNKNOWN.getInName().equals(levelName) ? TraceLogLevel.LEVEL_UNKNOWN : TraceLogLevel.TRACE_DEBUG)))))))))))))));
    }

    @Override
    public IFieldInfo[] getFields() {
        return this.fFields.toArray(new IFieldInfo[this.fFields.size()]);
    }

    @Override
    public void addField(IFieldInfo field) {
        this.fFields.add(field);
    }

    @Override
    public void setFields(List<IFieldInfo> fields) {
        this.fFields.clear();
        for (IFieldInfo fieldInfo : fields) {
            this.fFields.add(fieldInfo);
        }
    }

    @Override
    public String getFilterExpression() {
        return this.fFilterExpression;
    }

    @Override
    public void setFilterExpression(String filter) {
        this.fFilterExpression = filter;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fEventType == null ? 0 : this.fEventType.hashCode());
        result = 31 * result + this.fFields.hashCode();
        result = 31 * result + (this.fFilterExpression == null ? 0 : this.fFilterExpression.hashCode());
        result = 31 * result + (this.fLogLevel == null ? 0 : this.fLogLevel.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseEventInfo other = (BaseEventInfo)obj;
        if (this.fEventType != other.fEventType) {
            return false;
        }
        if (!this.fFields.equals(other.fFields)) {
            return false;
        }
        if (this.fFilterExpression == null ? other.fFilterExpression != null : !this.fFilterExpression.equals(other.fFilterExpression)) {
            return false;
        }
        return this.fLogLevel == other.fLogLevel;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[BaseEventInfo(");
        output.append(super.toString());
        output.append(",type=");
        output.append((Object)this.fEventType);
        output.append(",level=");
        output.append((Object)this.fLogLevel);
        if (!this.fFields.isEmpty()) {
            output.append(",Fields=");
            for (IFieldInfo field : this.fFields) {
                output.append(field.toString());
            }
        }
        if (this.fFilterExpression != null) {
            output.append(",Filter=");
            output.append(this.fFilterExpression);
        }
        output.append(")]");
        return output.toString();
    }
}

