/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCapture;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class CPPASTCapture
extends ASTNode
implements ICPPASTCapture {
    private boolean fByReference;
    private boolean fPackExpansion;
    private IASTName fIdentifier;

    @Override
    public CPPASTCapture copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTCapture copy(IASTNode.CopyStyle style) {
        CPPASTCapture copy = new CPPASTCapture();
        if (this.fIdentifier != null) {
            copy.setIdentifier(this.fIdentifier.copy(style));
        }
        copy.fByReference = this.fByReference;
        copy.fPackExpansion = this.fPackExpansion;
        return this.copy(copy, style);
    }

    @Override
    public boolean capturesThisPointer() {
        return this.fIdentifier == null;
    }

    @Override
    public boolean isByReference() {
        return this.fByReference;
    }

    @Override
    public boolean isPackExpansion() {
        return this.fPackExpansion;
    }

    @Override
    public IASTName getIdentifier() {
        return this.fIdentifier;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (visitor.shouldVisitCaptures) {
            switch (visitor.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fIdentifier != null && !this.fIdentifier.accept(visitor)) {
            return false;
        }
        return !visitor.shouldVisitCaptures || visitor.leave(this) != 2;
    }

    @Override
    public void setIdentifier(IASTName identifier) {
        this.assertNotFrozen();
        if (identifier != null) {
            identifier.setParent(this);
            identifier.setPropertyInParent(IDENTIFIER);
        }
        this.fIdentifier = identifier;
    }

    @Override
    public void setIsByReference(boolean value) {
        this.assertNotFrozen();
        this.fByReference = value;
    }

    @Override
    public void setIsPackExpansion(boolean val) {
        this.assertNotFrozen();
        this.fPackExpansion = val;
    }
}

