/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlighting;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingPresenter;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightings;
import org.eclipse.cdt.internal.ui.text.CPresentationReconciler;
import org.eclipse.cdt.internal.ui.text.CSourceViewerScalableConfiguration;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.internal.rdt.editor.RemoteCEditor;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteSemanticHighlightingReconciler;
import org.eclipse.ui.texteditor.ITextEditor;

public class RemoteSemanticHighlightingManager
extends SemanticHighlightingManager {
    private RemoteSemanticHighlightingReconciler fRemoteReconciler;
    private RemoteCEditor remoteCEditor;

    public void install(RemoteCEditor editor, CSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore) {
        this.remoteCEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fColorManager = colorManager;
        this.fPreferenceStore = preferenceStore;
        if (this.remoteCEditor != null) {
            this.fConfiguration = new CSourceViewerScalableConfiguration(colorManager, preferenceStore, (ITextEditor)editor, "___c_partitioning");
            this.fPresentationReconciler = (CPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)sourceViewer);
        } else {
            this.fConfiguration = null;
            this.fPresentationReconciler = null;
        }
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    public void install(CSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore, SemanticHighlightingManager.HighlightedRange[][] hardcodedRanges) {
        this.fHardcodedRanges = hardcodedRanges;
        this.install(null, sourceViewer, colorManager, preferenceStore);
    }

    protected void enable() {
        this.initializeHighlightings();
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.remoteCEditor != null) {
            this.fRemoteReconciler = new RemoteSemanticHighlightingReconciler();
            this.fRemoteReconciler.install(this.remoteCEditor, (ISourceViewer)this.fSourceViewer, this.fPresenter, this.fSemanticHighlightings, this.fHighlightings);
        } else {
            this.fPresenter.updatePresentation(null, this.createHardcodedPositions(), new SemanticHighlightingManager.HighlightedPosition[0]);
        }
    }

    public void uninstall() {
        this.disable();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        this.remoteCEditor = null;
        this.fSourceViewer = null;
        this.fColorManager = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
        this.fHardcodedRanges = null;
    }

    protected void disable() {
        if (this.fRemoteReconciler != null) {
            this.fRemoteReconciler.uninstall();
            this.fRemoteReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
        if (this.fSemanticHighlightings != null) {
            this.disposeHighlightings();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.handlePropertyChangeEvent(event);
    }

    protected boolean handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fPreferenceStore == null) {
            return false;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration.handlePropertyChangeEvent(event);
        }
        if (SemanticHighlightings.affectsEnablement((IPreferenceStore)this.fPreferenceStore, (PropertyChangeEvent)event)) {
            if (this.isEnabled()) {
                this.enable();
            } else {
                this.disable();
            }
        }
        if (!this.isEnabled()) {
            return false;
        }
        boolean refreshNeeded = false;
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            String colorKey = SemanticHighlightings.getColorPreferenceKey((SemanticHighlighting)semanticHighlighting);
            if (colorKey.equals(event.getProperty())) {
                this.adaptToTextForegroundChange(this.fHighlightings[i], event);
                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                refreshNeeded = true;
            } else {
                String boldKey = SemanticHighlightings.getBoldPreferenceKey((SemanticHighlighting)semanticHighlighting);
                if (boldKey.equals(event.getProperty())) {
                    this.adaptToTextStyleChange(this.fHighlightings[i], event, 1);
                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                    refreshNeeded = true;
                } else {
                    String italicKey = SemanticHighlightings.getItalicPreferenceKey((SemanticHighlighting)semanticHighlighting);
                    if (italicKey.equals(event.getProperty())) {
                        this.adaptToTextStyleChange(this.fHighlightings[i], event, 2);
                        this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                        refreshNeeded = true;
                    } else {
                        String strikethroughKey = SemanticHighlightings.getStrikethroughPreferenceKey((SemanticHighlighting)semanticHighlighting);
                        if (strikethroughKey.equals(event.getProperty())) {
                            this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x20000000);
                            this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                            refreshNeeded = true;
                        } else {
                            String underlineKey = SemanticHighlightings.getUnderlinePreferenceKey((SemanticHighlighting)semanticHighlighting);
                            if (underlineKey.equals(event.getProperty())) {
                                this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x40000000);
                                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                refreshNeeded = true;
                            } else {
                                String enabledKey = SemanticHighlightings.getEnabledPreferenceKey((SemanticHighlighting)semanticHighlighting);
                                if (enabledKey.equals(event.getProperty())) {
                                    this.adaptToEnablementChange(this.fHighlightings[i], event);
                                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                    refreshNeeded = true;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (refreshNeeded && this.fRemoteReconciler != null) {
            this.fRemoteReconciler.refresh();
        }
        return refreshNeeded;
    }

    public void refresh() {
        if (this.fRemoteReconciler != null) {
            this.fRemoteReconciler.refresh();
        }
    }
}

