/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.tmf.core.component.TmfDataProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;

public class TmfProviderManager {
    private static Map<Class<? extends ITmfEvent>, List<TmfDataProvider>> fProviders = new HashMap<Class<? extends ITmfEvent>, List<TmfDataProvider>>();

    private TmfProviderManager() {
    }

    public static <T extends ITmfEvent> void register(Class<T> eventType, TmfDataProvider provider) {
        if (fProviders.get(eventType) == null) {
            fProviders.put(eventType, new ArrayList());
        }
        fProviders.get(eventType).add(provider);
    }

    public static <T extends ITmfEvent> void deregister(Class<T> eventType, TmfDataProvider provider) {
        List<TmfDataProvider> list = fProviders.get(eventType);
        if (list != null) {
            list.remove(provider);
            if (list.size() == 0) {
                fProviders.remove(eventType);
            }
        }
    }

    public static TmfDataProvider[] getProviders(Class<? extends ITmfEvent> eventType) {
        List<TmfDataProvider> list = fProviders.get(eventType);
        if (list == null) {
            list = new ArrayList<TmfDataProvider>();
        }
        TmfDataProvider[] result = new TmfDataProvider[list.size()];
        return list.toArray(result);
    }

    public static TmfDataProvider[] getProviders(Class<? extends ITmfEvent> eventType, Class<? extends TmfDataProvider> providerType) {
        if (providerType == null) {
            return TmfProviderManager.getProviders(eventType);
        }
        TmfDataProvider[] list = TmfProviderManager.getProviders(eventType);
        ArrayList<TmfDataProvider> result = new ArrayList<TmfDataProvider>();
        if (list != null) {
            TmfDataProvider[] tmfDataProviderArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                TmfDataProvider provider = tmfDataProviderArray[n2];
                if (provider.getClass() == providerType) {
                    result.add(provider);
                }
                ++n2;
            }
        }
        TmfDataProvider[] array = new TmfDataProvider[result.size()];
        return result.toArray(array);
    }
}

