/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.shells;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.rse.internal.services.Activator;
import org.eclipse.rse.internal.services.shells.CommandPattern;
import org.eclipse.rse.internal.services.shells.OutputPattern;
import org.eclipse.rse.services.shells.ParsedOutput;
import org.osgi.framework.Bundle;

public class Patterns {
    private ArrayList _theCommands = new ArrayList();
    private String _currentCommand;

    public Patterns() {
        this.parsePatterns();
    }

    private void parsePatterns() {
        Bundle bundle = Activator.getDefault().getBundle();
        URL patterns = bundle.getEntry("/patterns.dat");
        if (patterns != null) {
            try {
                String curLine;
                InputStream in = patterns.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                this._theCommands.clear();
                CommandPattern curCommand = null;
                while ((curLine = reader.readLine()) != null) {
                    if ((curLine = curLine.trim()).length() == 0 || curLine.charAt(0) == '#') continue;
                    if (curLine.startsWith("command")) {
                        int colon = curLine.indexOf(":");
                        if (colon == curLine.length() - 1) continue;
                        Pattern thePattern = Pattern.compile(curLine.substring(colon + 1, curLine.length()).trim());
                        curCommand = new CommandPattern(thePattern);
                        this._theCommands.add(curCommand);
                        continue;
                    }
                    int firstSpace = curLine.indexOf(" ");
                    int patternWord = curLine.indexOf("pattern");
                    int firstEquals = curLine.indexOf("=");
                    if (firstEquals == -1 || firstEquals == curLine.length() - 1) continue;
                    String objType = curLine.substring(0, firstSpace);
                    String matchOrder = curLine.substring(firstSpace + 1, patternWord).trim();
                    String patternString = curLine.substring(firstEquals + 1, curLine.length());
                    Pattern thePattern = Pattern.compile(patternString.trim());
                    if (curCommand == null) continue;
                    curCommand.addOutputPattern(new OutputPattern(objType, matchOrder, thePattern));
                }
                in.close();
            }
            catch (IOException e) {
                Activator.getDefault().logException(e);
            }
        }
    }

    public void refresh(String theCommand) {
        this._currentCommand = theCommand;
        this.parsePatterns();
    }

    public void update(String theCommand) {
        this._currentCommand = theCommand;
    }

    public ParsedOutput matchLine(String theLine) {
        ParsedOutput matchedOutput = null;
        int commands = this._theCommands.size();
        if (this._currentCommand != null) {
            int i = 0;
            while (i < commands) {
                CommandPattern curCommand = (CommandPattern)this._theCommands.get(i);
                if (curCommand.matchCommand(this._currentCommand)) {
                    matchedOutput = curCommand.matchLine(theLine);
                }
                if (matchedOutput != null) {
                    return matchedOutput;
                }
                ++i;
            }
        }
        return null;
    }
}

