/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.model;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfNavigatorContentProvider;

public class TmfImportHelper {
    public static IResource createLink(IFolder parentFolder, IPath location, String targetName) throws CoreException {
        File source = new File(location.toString());
        IResource res = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (source.isDirectory()) {
            IFolder folder = parentFolder.getFolder(targetName);
            IStatus result = workspace.validateLinkLocation((IResource)folder, location);
            if (result.isOK()) {
                folder.createLink(location, 256, (IProgressMonitor)new NullProgressMonitor());
            } else {
                Activator.getDefault().logError(result.getMessage());
            }
        } else {
            IFile file = parentFolder.getFile(targetName);
            IStatus result = workspace.validateLinkLocation((IResource)file, location);
            if (result.isOK()) {
                file.createLink(location, 256, (IProgressMonitor)new NullProgressMonitor());
            } else {
                Activator.getDefault().logError(result.getMessage());
            }
        }
        TmfImportHelper.forceFolderRefresh(parentFolder);
        res = parentFolder.findMember(targetName);
        return res;
    }

    public static void forceFolderRefresh(IFolder parentFolder) {
        TmfNavigatorContentProvider ncp = new TmfNavigatorContentProvider();
        ncp.getChildren(parentFolder.getProject());
    }
}

