/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageBookmarkElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFileElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TracePackageExtractManifestOperation
extends AbstractTracePackageOperation {
    private static final String SCHEMA_FOLDER_NAME = "schema";
    private static final String EXPORT_MANIFEST_SCHEMA_FILE_NAME = "export-manifest.xsd";
    private TracePackageElement[] fResultElements;

    public TracePackageExtractManifestOperation(String fileName) {
        super(fileName);
    }

    @Override
    public void run(IProgressMonitor progressMonitor) {
        TracePackageElement[] elements = null;
        try {
            progressMonitor.worked(1);
            AbstractTracePackageOperation.ArchiveFile archiveFile = this.getSpecifiedArchiveFile();
            progressMonitor.worked(1);
            if (archiveFile == null) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackageExtractManifestOperation_InvalidFormat));
                return;
            }
            Enumeration<? extends AbstractTracePackageOperation.ArchiveEntry> entries = archiveFile.entries();
            boolean found = false;
            while (entries.hasMoreElements()) {
                ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                AbstractTracePackageOperation.ArchiveEntry entry = entries.nextElement();
                Path p = new Path(entry.getName());
                p = p.removeFirstSegments(1);
                if (entry.getName().endsWith("export-manifest.xml")) {
                    found = true;
                    InputStream inputStream = archiveFile.getInputStream(entry);
                    TracePackageExtractManifestOperation.validateManifest(inputStream);
                    inputStream = archiveFile.getInputStream(entry);
                    elements = TracePackageExtractManifestOperation.loadElementsFromManifest(inputStream);
                    break;
                }
                progressMonitor.worked(1);
            }
            if (found) {
                this.setStatus(Status.OK_STATUS);
            } else {
                elements = this.generateElementsFromArchive();
                if (elements.length > 0) {
                    this.setStatus(Status.OK_STATUS);
                } else {
                    this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", MessageFormat.format(Messages.TracePackageExtractManifestOperation_ErrorManifestNotFound, "export-manifest.xml")));
                }
            }
            this.fResultElements = elements;
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCEL_STATUS);
        }
        catch (Exception e) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackageExtractManifestOperation_ErrorReadingManifest, (Throwable)e));
        }
    }

    private TracePackageElement[] generateElementsFromArchive() {
        AbstractTracePackageOperation.ArchiveFile archiveFile = this.getSpecifiedArchiveFile();
        Enumeration<? extends AbstractTracePackageOperation.ArchiveEntry> entries = archiveFile.entries();
        HashSet<String> traceFileNames = new HashSet<String>();
        while (entries.hasMoreElements()) {
            AbstractTracePackageOperation.ArchiveEntry entry = entries.nextElement();
            String entryName = entry.getName();
            Path fullArchivePath = new Path(entryName);
            if (fullArchivePath.hasTrailingSeparator() || fullArchivePath.segmentCount() <= 0) continue;
            traceFileNames.add(fullArchivePath.segment(0));
        }
        ArrayList<TracePackageTraceElement> packageElements = new ArrayList<TracePackageTraceElement>();
        for (String traceFileName : traceFileNames) {
            TracePackageTraceElement traceElement = new TracePackageTraceElement(null, traceFileName, null);
            traceElement.setChildren(new TracePackageElement[]{new TracePackageFilesElement((TracePackageElement)traceElement, traceFileName)});
            packageElements.add(traceElement);
        }
        return packageElements.toArray(new TracePackageElement[0]);
    }

    public TracePackageElement[] getResultElement() {
        return this.fResultElements;
    }

    private static void validateManifest(InputStream xml) throws IOException {
        URL schemaFileUrl = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(SCHEMA_FOLDER_NAME).append(EXPORT_MANIFEST_SCHEMA_FILE_NAME), null);
        if (schemaFileUrl == null) {
            throw new IOException(MessageFormat.format(Messages.TracePackageExtractManifestOperation_SchemaFileNotFound, EXPORT_MANIFEST_SCHEMA_FILE_NAME));
        }
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(schemaFileUrl.openStream()));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xml));
        }
        catch (SAXException e) {
            throw new IOException(Messages.TracePackageExtractManifestOperation_ErrorManifestNotValid, e);
        }
        catch (IOException e) {
            throw new IOException(Messages.TracePackageExtractManifestOperation_ErrorManifestNotValid, e);
        }
    }

    private static TracePackageElement[] loadElementsFromManifest(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        ArrayList<TracePackageTraceElement> packageElements = new ArrayList<TracePackageTraceElement>();
        TracePackageTraceElement element = null;
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        NodeList traceElements = doc.getDocumentElement().getElementsByTagName("trace");
        int i = 0;
        while (i < traceElements.getLength()) {
            Node traceNode = traceElements.item(i);
            if (traceNode.getNodeType() == 1) {
                Element traceElement = (Element)traceNode;
                String traceName = traceElement.getAttribute("name");
                String traceType = traceElement.getAttribute("type");
                element = new TracePackageTraceElement(null, traceName, traceType);
                ArrayList<TracePackageElement> children = new ArrayList<TracePackageElement>();
                NodeList fileElements = traceElement.getElementsByTagName("file");
                int j = 0;
                while (j < fileElements.getLength()) {
                    Node fileNode = fileElements.item(j);
                    if (fileNode.getNodeType() == 1) {
                        Element fileElement = (Element)fileNode;
                        String fileName = fileElement.getAttribute("name");
                        children.add(new TracePackageFilesElement((TracePackageElement)element, fileName));
                    }
                    ++j;
                }
                TracePackageSupplFilesElement supplFilesElement = new TracePackageSupplFilesElement(element);
                ArrayList<TracePackageSupplFileElement> suppFiles = new ArrayList<TracePackageSupplFileElement>();
                NodeList suppFilesElements = traceElement.getElementsByTagName("supplementary-file");
                int j2 = 0;
                while (j2 < suppFilesElements.getLength()) {
                    Node suppFileNode = suppFilesElements.item(j2);
                    if (suppFileNode.getNodeType() == 1) {
                        Element suppFileElement = (Element)suppFileNode;
                        String fileName = suppFileElement.getAttribute("name");
                        TracePackageSupplFileElement supplFile = new TracePackageSupplFileElement(fileName, (TracePackageElement)supplFilesElement);
                        suppFiles.add(supplFile);
                    }
                    ++j2;
                }
                if (!suppFiles.isEmpty()) {
                    supplFilesElement.setChildren(suppFiles.toArray(new TracePackageElement[0]));
                    children.add(supplFilesElement);
                }
                ArrayList<Map<String, String>> bookmarkAttribs = new ArrayList<Map<String, String>>();
                NodeList bookmarksElements = traceElement.getElementsByTagName("bookmarks");
                int j3 = 0;
                while (j3 < bookmarksElements.getLength()) {
                    Node bookmarksNode = bookmarksElements.item(j3);
                    if (bookmarksNode.getNodeType() == 1) {
                        NodeList bookmarkElements = traceElement.getElementsByTagName("bookmark");
                        int k = 0;
                        while (k < bookmarkElements.getLength()) {
                            Node bookmarkNode = bookmarkElements.item(k);
                            if (bookmarkNode.getNodeType() == 1) {
                                Element bookmarkElement = (Element)bookmarkNode;
                                NamedNodeMap attributesMap = bookmarkElement.getAttributes();
                                HashMap<String, String> attribs = new HashMap<String, String>();
                                int l = 0;
                                while (l < attributesMap.getLength()) {
                                    Node item = attributesMap.item(l);
                                    attribs.put(item.getNodeName(), item.getNodeValue());
                                    ++l;
                                }
                                bookmarkAttribs.add(attribs);
                            }
                            ++k;
                        }
                    }
                    ++j3;
                }
                if (!bookmarkAttribs.isEmpty()) {
                    children.add(new TracePackageBookmarkElement(element, bookmarkAttribs));
                }
                element.setChildren(children.toArray(new TracePackageElement[0]));
                packageElements.add(element);
            }
            ++i;
        }
        return packageElements.toArray(new TracePackageElement[0]);
    }
}

