/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.model.TmfImportHelper;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceValidationHelper;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.FileAndName;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.ImportTraceContentProvider;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.ImportTraceWizard;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.ImportTraceWizardPageOptions;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.ImportTraceWizardScanPage;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.ImportTraceWizardSelectDirectoriesPage;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.ImportTraceWizardSelectTraceTypePage;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class BatchImportTraceWizard
extends ImportTraceWizard {
    private static final int WIN_HEIGHT = 400;
    private static final int WIN_WIDTH = 800;
    private static final Status CANCEL_STATUS = new Status(8, "org.eclipse.linuxtools.tmf.ui", "");
    private static final int TOTALWORK = 65536;
    private static final int MAX_FILES = 65535;
    private static final String BATCH_IMPORT_WIZARD = "BatchImportTraceWizard";
    private IWizardPage fSelectDirectoriesPage;
    private ImportTraceWizardScanPage fScanPage;
    private IWizardPage fSelectTypePage;
    private IWizardPage fOptions;
    private final List<String> fTraceTypesToScan = new ArrayList<String>();
    private final Set<String> fParentFilesToScan = new HashSet<String>();
    private ImportTraceContentProvider fScannedTraces = new ImportTraceContentProvider(this.fTraceTypesToScan, this.fParentFilesToScan);
    private final Map<TraceValidationHelper, Boolean> fResults = new HashMap<TraceValidationHelper, Boolean>();
    private boolean fOverwrite = true;
    private boolean fLinked = true;
    private BlockingQueue<TraceValidationHelper> fTracesToScan;
    private final Set<FileAndName> fTraces = new TreeSet<FileAndName>();
    private Map<String, Set<String>> fParentFiles = new HashMap<String, Set<String>>();
    private IFolder fTargetFolder;

    public ImportTraceContentProvider getScannedTraces() {
        return this.fScannedTraces;
    }

    public BatchImportTraceWizard() {
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(BATCH_IMPORT_WIZARD);
        if (section == null) {
            section = workbenchSettings.addNewSection(BATCH_IMPORT_WIZARD);
        }
        this.setDialogSettings(section);
        this.setNeedsProgressMonitor(true);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelectDirectoriesPage = new ImportTraceWizardSelectDirectoriesPage(workbench, selection);
        this.fScanPage = new ImportTraceWizardScanPage(workbench, selection);
        this.fSelectTypePage = new ImportTraceWizardSelectTraceTypePage(workbench, selection);
        this.fOptions = new ImportTraceWizardPageOptions(workbench, selection);
        for (Object selected : selection) {
            if (!(selected instanceof TmfTraceFolder)) continue;
            this.fTargetFolder = ((TmfTraceFolder)selected).getResource();
            break;
        }
        this.fResults.clear();
    }

    @Override
    public void addPages() {
        this.addPage(this.fSelectTypePage);
        this.addPage(this.fSelectDirectoriesPage);
        this.addPage((IWizardPage)this.fScanPage);
        this.addPage(this.fOptions);
        WizardDialog container = (WizardDialog)this.getContainer();
        if (container != null) {
            container.setPageSize(800, 400);
        }
    }

    public void addFileToScan(String fileName) {
        String absolutePath = new File(fileName).getAbsolutePath();
        if (!this.fParentFiles.containsKey(absolutePath)) {
            this.fParentFiles.put(absolutePath, new HashSet());
            this.startUpdateTask(String.valueOf(Messages.BatchImportTraceWizardAdd) + ' ' + absolutePath, absolutePath);
        }
    }

    public void removeFile(String fileName) {
        this.fParentFiles.remove(fileName);
        this.fParentFilesToScan.remove(fileName);
        this.startUpdateTask(String.valueOf(Messages.BatchImportTraceWizardRemove) + ' ' + fileName, null);
    }

    private void startUpdateTask(final String taskName, final String fileAbsolutePath) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    BatchImportTraceWizard batchImportTraceWizard = BatchImportTraceWizard.this;
                    synchronized (batchImportTraceWizard) {
                        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor);
                        sm.setTaskName(taskName);
                        sm.setWorkRemaining(65536);
                        BatchImportTraceWizard.this.updateFiles((IProgressMonitor)sm, fileAbsolutePath);
                        sm.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError(Messages.ImportTraceWizardImportProblem, e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Set<String> getFileNames() {
        return this.fParentFilesToScan;
    }

    public void clearTraces() {
        this.fTraces.clear();
    }

    @Override
    public boolean performFinish() {
        if (this.fTraces.isEmpty()) {
            return false;
        }
        boolean success = this.importTraces();
        return success;
    }

    private boolean importTraces() {
        boolean success = false;
        IOverwriteQuery overwriteQuery = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return BatchImportTraceWizard.this.fOverwrite ? "ALL" : "NOALL";
            }
        };
        FileSystemStructureProvider fileSystemStructureProvider = FileSystemStructureProvider.INSTANCE;
        for (FileAndName traceToImport : this.fTraces) {
            try {
                File[] fileList;
                if (this.fLinked) {
                    if (TmfImportHelper.createLink(this.fTargetFolder, Path.fromOSString((String)traceToImport.getFile().getAbsolutePath()), traceToImport.getName()) == null) {
                        success = false;
                        continue;
                    }
                    success = this.setTraceType(traceToImport).isOK();
                    continue;
                }
                ArrayList<File> subList = new ArrayList<File>();
                IPath path = this.fTargetFolder.getFullPath();
                File parentFile = traceToImport.getFile();
                boolean isFile = parentFile.isFile();
                if (isFile) {
                    IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile(path.append(traceToImport.getName()));
                    if (!this.fOverwrite && resource.exists()) continue;
                    subList.add(parentFile);
                    parentFile = parentFile.getParentFile();
                    FileInputStream source = new FileInputStream(traceToImport.getFile());
                    if (resource.exists()) {
                        resource.delete(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                    resource.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
                    source.close();
                    this.setTraceType(traceToImport);
                    success = true;
                    continue;
                }
                subList.add(traceToImport.getFile());
                File[] fileArray = fileList = traceToImport.getFile().listFiles();
                int n = fileList.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    subList.add(child);
                    ++n2;
                }
                Collections.sort(subList, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
                    }
                });
                ImportOperation operation = new ImportOperation(path, (Object)parentFile.getParentFile(), (IImportStructureProvider)fileSystemStructureProvider, overwriteQuery, subList);
                operation.setContext(this.getShell());
                operation.setCreateContainerStructure(false);
                if (!this.executeImportOperation(operation)) continue;
                this.setTraceType(traceToImport);
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus setTraceType(FileAndName traceToImport) {
        IStatus validate = Status.OK_STATUS;
        IPath path = this.fTargetFolder.getFullPath().append(traceToImport.getName());
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource == null) return validate;
        try {
            TmfTraceElement traceElement;
            TmfProjectElement tmfProject;
            String traceTypeId = traceToImport.getTraceTypeId();
            TraceTypeHelper traceType = TmfTraceType.getInstance().getTraceType(traceTypeId);
            if (traceType != null) {
                TmfTraceType.setTraceType(path, traceType);
            }
            if ((tmfProject = TmfProjectRegistry.getProject(resource.getProject())) == null) return validate;
            TmfTraceFolder tracesFolder = tmfProject.getTracesFolder();
            tracesFolder.refresh();
            List<TmfTraceElement> traces = tracesFolder.getTraces();
            boolean found = false;
            for (TmfTraceElement traceElement2 : traces) {
                if (!traceElement2.getName().equals(resource.getName())) continue;
                traceElement2.refreshTraceType();
                found = true;
                break;
            }
            if (found) return validate;
            TmfTraceElement te = new TmfTraceElement(traceToImport.getName(), resource, tracesFolder);
            te.refreshTraceType();
            traces = tracesFolder.getTraces();
            Iterator<TmfTraceElement> iterator = traces.iterator();
            do {
                if (iterator.hasNext()) continue;
                return validate;
            } while (!(traceElement = iterator.next()).getName().equals(resource.getName()));
            traceElement.refreshTraceType();
            ITmfTrace tmfTrace = null;
            try {
                tmfTrace = traceElement.instantiateTrace();
                if (tmfTrace != null) {
                    validate = tmfTrace.validate(tmfProject.getResource(), traceElement.getLocation().getPath());
                    return validate;
                }
                Status status = new Status(4, traceElement.getName(), "File does not exist : " + traceElement.getLocation().getPath());
                return status;
            }
            finally {
                if (tmfTrace != null) {
                    tmfTrace.dispose();
                }
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(String.valueOf(Messages.BatchImportTraceWizardErrorImportingTraceResource) + ' ' + resource.getName(), e);
        }
        return validate;
    }

    public boolean canFinish() {
        return super.canFinish() && this.hasTracesToImport() && !this.hasConflicts() && this.fTargetFolder != null;
    }

    public boolean hasTracesToImport() {
        return this.fTraces.size() > 0;
    }

    public void clearFilesToScan() {
        this.fTracesToScan.clear();
    }

    public void setTraceTypesToScan(List<String> tracesToScan) {
        ArrayList<String> added = new ArrayList<String>();
        for (String traceLoc : tracesToScan) {
            if (this.fTraceTypesToScan.contains(traceLoc)) continue;
            added.add(traceLoc);
        }
        this.fTraceTypesToScan.clear();
        this.fTraceTypesToScan.addAll(tracesToScan);
        this.updateTracesToScan(added);
    }

    public List<String> getTraceTypesToScan() {
        return this.fTraceTypesToScan;
    }

    public void addFileToImport(FileAndName element) {
        this.fTraces.add(element);
        this.updateConflicts();
    }

    public void removeFileToImport(FileAndName element) {
        this.fTraces.remove(element);
        element.setConflictingName(false);
        this.updateConflicts();
    }

    public void updateConflicts() {
        FileAndName[] fChildren = this.fTraces.toArray(new FileAndName[0]);
        int i = 0;
        while (i < fChildren.length) {
            fChildren[i].setConflictingName(false);
            ++i;
        }
        i = 1;
        while (i < fChildren.length) {
            int j = 0;
            while (j < i) {
                if (fChildren[i].getName().equals(fChildren[j].getName())) {
                    fChildren[i].setConflictingName(true);
                    fChildren[j].setConflictingName(true);
                }
                ++j;
            }
            ++i;
        }
        this.getContainer().updateButtons();
    }

    boolean hasConflicts() {
        boolean conflict = false;
        for (FileAndName child : this.fTraces) {
            conflict |= child.isConflictingName();
        }
        return conflict;
    }

    private boolean executeImportOperation(ImportOperation op) {
        BatchImportTraceWizard.initializeOperation(op);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError(Messages.ImportTraceWizardImportProblem, e);
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.ImportTraceWizardImportProblem, null, (IStatus)status);
            return false;
        }
        return true;
    }

    private static void initializeOperation(ImportOperation op) {
        op.setCreateContainerStructure(false);
        op.setOverwriteResources(false);
        op.setVirtualFolders(false);
    }

    public void setOverwrite(boolean selection) {
        this.fOverwrite = selection;
    }

    public void setLinked(boolean isLink) {
        this.fLinked = isLink;
    }

    public void setTracesToScan(BlockingQueue<TraceValidationHelper> tracesToScan) {
        this.fTracesToScan = tracesToScan;
    }

    public boolean hasScanned(TraceValidationHelper traceToScan) {
        return this.fResults.containsKey(traceToScan);
    }

    public void addResult(TraceValidationHelper traceToScan, boolean validate) {
        this.fResults.put(traceToScan, validate);
    }

    public Boolean getResult(TraceValidationHelper traceToScan) {
        return this.fResults.get(traceToScan);
    }

    public int getNumberOfResults() {
        return this.fResults.size();
    }

    private void updateTracesToScan(List<String> added) {
        TreeSet<String> filesToScan = new TreeSet<String>();
        for (String name : this.fParentFiles.keySet()) {
            filesToScan.addAll((Collection<String>)this.fParentFiles.get(name));
        }
        NullProgressMonitor pm = new NullProgressMonitor();
        try {
            this.updateScanQueue((IProgressMonitor)pm, filesToScan, added);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized IStatus updateFiles(IProgressMonitor monitor, String traceToScanAbsPath) {
        TreeSet<String> filesToScan = new TreeSet<String>();
        int workToDo = 1;
        for (String name : this.fParentFiles.keySet()) {
            File file = new File(name);
            File[] listFiles = file.listFiles();
            if (listFiles == null) continue;
            workToDo += listFiles.length;
        }
        int step = 65536 / workToDo;
        try {
            for (String name : this.fParentFiles.keySet()) {
                File fileToAdd = new File(name);
                Set<String> parentFilesToScan = this.fParentFiles.get(fileToAdd.getAbsolutePath());
                this.recurse(parentFilesToScan, fileToAdd, monitor, step);
                if (!monitor.isCanceled()) continue;
                this.fParentFilesToScan.remove(traceToScanAbsPath);
                this.fParentFiles.remove(traceToScanAbsPath);
                return CANCEL_STATUS;
            }
            filesToScan.clear();
            for (String name : this.fParentFiles.keySet()) {
                filesToScan.addAll((Collection<String>)this.fParentFiles.get(name));
                this.fParentFilesToScan.add(name);
            }
            IStatus cancelled = this.updateScanQueue(monitor, filesToScan, this.fTraceTypesToScan);
            if (cancelled.matches(8)) {
                this.fParentFilesToScan.remove(traceToScanAbsPath);
                this.fParentFiles.remove(traceToScanAbsPath);
            }
        }
        catch (InterruptedException e) {
            monitor.done();
            return new Status(4, "org.eclipse.linuxtools.tmf.ui", e.getMessage(), (Throwable)e);
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private IStatus updateScanQueue(IProgressMonitor monitor, Set<String> filesToScan, List<String> traceTypes) throws InterruptedException {
        for (String fileToScan : filesToScan) {
            for (String traceCat : traceTypes) {
                TraceValidationHelper tv = new TraceValidationHelper(fileToScan, traceCat);
                if (this.fResults.containsKey(tv) || this.fTracesToScan.contains(tv)) continue;
                this.fTracesToScan.put(tv);
                monitor.subTask(tv.getTraceToScan());
                if (!monitor.isCanceled()) continue;
                this.fScanPage.refresh();
                return CANCEL_STATUS;
            }
        }
        this.fScanPage.refresh();
        return Status.OK_STATUS;
    }

    private IStatus recurse(Set<String> filesToScan, File fileToAdd, IProgressMonitor monitor, int step) {
        String absolutePath = fileToAdd.getAbsolutePath();
        if (!filesToScan.contains(absolutePath) && filesToScan.size() < 65535) {
            filesToScan.add(absolutePath);
            File[] listFiles = fileToAdd.listFiles();
            if (listFiles != null) {
                File[] fileArray = listFiles;
                int n = listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    monitor.subTask(child.getName());
                    if (monitor.isCanceled()) {
                        return CANCEL_STATUS;
                    }
                    IStatus retVal = this.recurse(filesToScan, child, monitor);
                    if (retVal.matches(8)) {
                        return retVal;
                    }
                    monitor.worked(step);
                    ++n2;
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus recurse(Set<String> filesToScan, File fileToAdd, IProgressMonitor monitor) {
        String absolutePath = fileToAdd.getAbsolutePath();
        if (!filesToScan.contains(absolutePath) && filesToScan.size() < 65535) {
            filesToScan.add(absolutePath);
            File[] listFiles = fileToAdd.listFiles();
            if (listFiles != null) {
                File[] fileArray = listFiles;
                int n = listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    if (monitor.isCanceled()) {
                        return CANCEL_STATUS;
                    }
                    IStatus retVal = this.recurse(filesToScan, child, monitor);
                    if (retVal.matches(8)) {
                        return retVal;
                    }
                    ++n2;
                }
            }
        }
        return Status.OK_STATUS;
    }

    public void setTraceFolder(IFolder targetFolder) {
        this.fTargetFolder = targetFolder;
        if (this.getContainer() != null && this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public IFolder getTargetFolder() {
        return this.fTargetFolder;
    }
}

