/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.twiki.core.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.twiki.core.validation.Messages;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.core.validation.ValidationRule;

public class ListWhitespaceValidationRule
extends ValidationRule {
    private static final Pattern almostListPattern = Pattern.compile("^((?: |\t)*)(\\*|((i|I|a|A|1)\\.))(\\S)?", 8);

    public ValidationProblem findProblem(String markup, int offset, int length) {
        Matcher matcher = almostListPattern.matcher(markup);
        if (offset > 0 || length != markup.length()) {
            matcher.region(offset, offset + length);
        }
        while (matcher.find()) {
            String spaces = matcher.group(1);
            if (spaces == null || spaces.length() == 0 || spaces.length() % 3 != 0 || this.containsNonSpace(spaces)) {
                int problemOffset = matcher.start();
                int problemLength = Math.max(2, matcher.end(2) - problemOffset);
                return new ValidationProblem(ValidationProblem.Severity.WARNING, Messages.getString("ListWhitespaceValidationRule.1"), problemOffset, problemLength);
            }
            String after = matcher.group(5);
            if (after == null) continue;
            int problemOffset = matcher.start();
            int problemLength = Math.max(2, matcher.end(2) - problemOffset);
            return new ValidationProblem(ValidationProblem.Severity.WARNING, Messages.getString("ListWhitespaceValidationRule.2"), problemOffset, problemLength);
        }
        return null;
    }

    private boolean containsNonSpace(String spaces) {
        int x = 0;
        while (x < spaces.length()) {
            if (spaces.charAt(x) != ' ') {
                return true;
            }
            ++x;
        }
        return false;
    }
}

