/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rm.jaxb.control.core.IMatchable;
import org.eclipse.ptp.internal.rm.jaxb.control.core.IStreamParserTokenizer;
import org.eclipse.ptp.internal.rm.jaxb.control.core.data.RegexImpl;
import org.eclipse.ptp.internal.rm.jaxb.control.core.data.TargetImpl;
import org.eclipse.ptp.internal.rm.jaxb.control.core.exceptions.StreamParserException;
import org.eclipse.ptp.internal.rm.jaxb.control.core.messages.Messages;
import org.eclipse.ptp.internal.rm.jaxb.control.core.utils.DebuggingLogger;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.RegexType;
import org.eclipse.ptp.rm.jaxb.core.data.TargetType;
import org.eclipse.ptp.rm.jaxb.core.data.TokenizerType;

public class ConfigurableRegexTokenizer
implements IStreamParserTokenizer,
Runnable {
    public static final String EXT_ID = "org.eclipse.ptp.rm.jaxb.configurableRegexTokenizer";
    private final TokenizerType tokenizer;
    private int maxLen;
    private Integer save;
    private boolean all;
    private boolean applyToAll;
    private List<IMatchable> toMatch;
    private StringBuffer segment;
    private char delim;
    private RegexImpl exitOn;
    private RegexImpl exitAfter;
    private boolean includeDelim;
    private IStatus status;
    private InputStream in;
    private char[] chars;
    private LinkedList<String> saved;
    private boolean endOfStream;

    private static char getChar(String delim) {
        if (delim.indexOf("\\n") >= 0) {
            return "\n".charAt(0);
        }
        if (delim.indexOf("\\r") >= 0) {
            return "\r".charAt(0);
        }
        if (delim.indexOf("\\t") >= 0) {
            return "\t".charAt(0);
        }
        return delim.charAt(0);
    }

    public ConfigurableRegexTokenizer(TokenizerType tokenizer) {
        this.tokenizer = tokenizer;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void initialize(String uuid, IVariableMap varMap) {
        String d = this.tokenizer.getDelim();
        if (d != null) {
            this.delim = ConfigurableRegexTokenizer.getChar(d);
            this.includeDelim = this.tokenizer.isIncludeDelim();
        } else {
            this.delim = '\u0000';
            this.includeDelim = false;
        }
        this.maxLen = this.tokenizer.getMaxMatchLen();
        this.chars = this.maxLen != 0 ? new char[2 * this.maxLen] : new char[1];
        this.save = this.tokenizer.getSave();
        this.saved = this.save != null ? new LinkedList() : null;
        this.all = this.tokenizer.isAll();
        this.applyToAll = this.tokenizer.isApplyToAll();
        this.toMatch = new ArrayList<IMatchable>();
        List targets = this.tokenizer.getTarget();
        for (TargetType target : targets) {
            this.toMatch.add(new TargetImpl(uuid, target, varMap));
        }
        RegexType reg = this.tokenizer.getExitOn();
        if (reg != null) {
            this.exitOn = new RegexImpl(reg, uuid, varMap);
        }
        if ((reg = this.tokenizer.getExitAfter()) != null) {
            this.exitAfter = new RegexImpl(reg, uuid, varMap);
        }
        this.segment = new StringBuffer();
    }

    public void run() {
        DebuggingLogger.initialize();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(this.in));
            this.read(br);
            this.status = Status.OK_STATUS;
        }
        catch (StreamParserException e) {
            this.status = e.getStatus();
        }
    }

    public void setInputStream(InputStream stream) {
        this.in = stream;
    }

    private boolean checkExit(RegexImpl regex) {
        return regex != null && regex.getMatched(this.segment.toString()) != null;
    }

    private void findNextSegment(BufferedReader in) throws StreamParserException {
        block12: {
            int read;
            this.endOfStream = false;
            int len = this.chars.length == 1 ? 1 : this.chars.length - this.segment.length();
            char[] lookAhead = new char[1];
            while (true) {
                int peek;
                block11: {
                    read = 0;
                    peek = 0;
                    try {
                        read = in.read(this.chars, 0, len);
                        if (read != -1) break block11;
                        this.endOfStream = true;
                        break block12;
                    }
                    catch (EOFException eOFException) {
                        this.endOfStream = true;
                        break block12;
                    }
                    catch (IOException e) {
                        throw new StreamParserException(Messages.ReadSegmentError, e);
                    }
                }
                if (this.chars.length != 1) break;
                if (this.chars[0] == this.delim) {
                    if (this.includeDelim) {
                        this.segment.append(this.delim);
                    }
                    if (this.delim != '\r') break block12;
                    try {
                        in.mark(1);
                        peek = in.read(lookAhead, 0, 1);
                        if (peek == 1 && lookAhead[0] == '\n') {
                            if (this.includeDelim) {
                                this.segment.append('\n');
                            }
                        } else {
                            in.reset();
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        throw new StreamParserException(Messages.ReadSegmentError, e);
                    }
                }
                this.segment.append(this.chars[0]);
            }
            this.segment.append(this.chars, 0, read);
        }
    }

    private void matchTargets() throws StreamParserException {
        IMatchable selected = null;
        for (IMatchable m : this.toMatch) {
            if (!m.doMatch(this.segment) || this.applyToAll) continue;
            if (!m.isSelected()) break;
            selected = m;
            break;
        }
        if (selected != null) {
            Iterator<IMatchable> i = this.toMatch.iterator();
            while (i.hasNext()) {
                IMatchable m = i.next();
                m.setSelected(false);
                if (m != selected) continue;
                i.remove();
            }
            this.toMatch.add(0, selected);
        }
    }

    private void postProcessTargets() throws StreamParserException {
        for (IMatchable m : this.toMatch) {
            m.postProcess();
        }
    }

    private void read(BufferedReader in) throws StreamParserException {
        boolean exit = false;
        while (!exit) {
            this.findNextSegment(in);
            if (this.checkExit(this.exitOn)) break;
            if (this.checkExit(this.exitAfter)) {
                exit = true;
            }
            if (this.all) {
                if (this.save != null) {
                    if (this.segment.length() > 0) {
                        while (this.saved.size() >= this.save) {
                            this.saved.removeFirst();
                        }
                        this.saved.addLast(this.segment.toString());
                    }
                    this.reset();
                }
                if (!this.endOfStream) continue;
                break;
            }
            this.matchTargets();
            this.reset();
            if (this.endOfStream) break;
        }
        if (this.all) {
            while (!this.saved.isEmpty()) {
                this.segment.append(this.saved.removeFirst());
                this.matchTargets();
                this.reset();
            }
        }
        this.postProcessTargets();
    }

    private void reset() {
        if (this.chars.length == 1) {
            this.segment.setLength(0);
        } else if (this.segment.length() == this.chars.length) {
            this.segment.delete(0, this.maxLen);
        }
    }
}

