/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.feedback.actions.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.etfw.feedback.IFeedbackItem;
import org.eclipse.ptp.etfw.feedback.IFeedbackParser;
import org.eclipse.ptp.internal.etfw.feedback.util.ViewActivator;
import org.eclipse.ui.handlers.HandlerUtil;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ShowFeedbackHandler
extends AbstractHandler {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASSNAME = "class";
    private IStructuredSelection selection = null;
    private static final boolean traceOn = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection sel = this.getSelection(event);
        if (this.isRemote(this.selection)) {
            // empty if block
        }
        IFeedbackParser parser = null;
        for (IResource obj : sel) {
            if (!(obj instanceof IFile)) continue;
            IFile file = (IFile)obj;
            String name = file.getName();
            file.getLocation();
            if (!name.endsWith(".xml")) continue;
            parser = this.findFeedbackParser(file);
            List<IFeedbackItem> items = parser.getFeedbackItems(file);
            parser.createMarkers(items, parser.getMarkerID());
        }
        if (parser != null) {
            ViewActivator.activateView(parser.getViewID());
        }
        return null;
    }

    private IFeedbackParser findFeedbackParser(File file) {
        Node node;
        String rootNode;
        FileInputStream xmlIn;
        try {
            xmlIn = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found: " + file.getAbsolutePath());
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Node document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (xmlIn != null) {
                document = builder.parse(xmlIn);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("TransformDocXMLParser IOException: " + e.getMessage());
        }
        if ((rootNode = (node = document.getFirstChild()).getNodeName()).equals("xml") || rootNode.equals("xml-stylesheet")) {
            Node next;
            node = next = node.getNextSibling();
            rootNode = node.getNodeName();
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.etfw.feedback", "parser").getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extn = extensions[i];
            String extLabel = extn.getLabel();
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement ice = configElements[j];
                String nodeName = ice.getAttribute("nodeName");
                if (rootNode.equals(nodeName)) {
                    String className = ice.getAttribute(ATTR_CLASSNAME);
                    String name = ice.getAttribute(ATTR_NAME);
                    Object obj = null;
                    try {
                        obj = ice.createExecutableExtension(ATTR_CLASSNAME);
                        if (obj instanceof IFeedbackParser) {
                            IFeedbackParser fp = (IFeedbackParser)obj;
                            return fp;
                        }
                    }
                    catch (CoreException e) {
                        System.out.println("Failed to create class " + className);
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public IStructuredSelection getSelection(ExecutionEvent event) {
        ISelection curSel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (curSel instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)curSel;
        } else {
            System.out.println("no selection.");
        }
        return this.selection;
    }

    private boolean isRemote(IStructuredSelection selection) {
        IAdaptable iAdaptable;
        IResource resource;
        IProject proj;
        Object s1 = selection.getFirstElement();
        return s1 instanceof IAdaptable && ShowFeedbackHandler.isRemote(proj = (resource = (IResource)(iAdaptable = (IAdaptable)s1).getAdapter(IResource.class)).getProject());
    }

    private IFeedbackParser findFeedbackParser(IFile file) {
        Node node;
        String rootNode;
        InputStream xmlIn;
        try {
            xmlIn = file.getContents();
        }
        catch (CoreException coreException) {
            System.out.println("CoreException getting inputstream: " + file);
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e1) {
            System.out.println("Failed to set parser feature to enable remote DTD files");
            e1.printStackTrace();
        }
        Node document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (xmlIn != null) {
                document = builder.parse(xmlIn);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("TransformDocXMLParser IOException: " + e.getMessage());
        }
        if ((rootNode = (node = document.getFirstChild()).getNodeName()).equals("xml") || rootNode.equals("xml-stylesheet")) {
            Node next;
            node = next = node.getNextSibling();
            rootNode = node.getNodeName();
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.etfw.feedback", "parser").getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extn = extensions[i];
            String extLabel = extn.getLabel();
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement ice = configElements[j];
                String nodeName = ice.getAttribute("nodeName");
                if (rootNode.equals(nodeName)) {
                    String className = ice.getAttribute(ATTR_CLASSNAME);
                    String name = ice.getAttribute(ATTR_NAME);
                    Object obj = null;
                    try {
                        obj = ice.createExecutableExtension(ATTR_CLASSNAME);
                        if (obj instanceof IFeedbackParser) {
                            IFeedbackParser fp = (IFeedbackParser)obj;
                            return fp;
                        }
                    }
                    catch (CoreException e) {
                        System.out.println("Failed to create class " + className);
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static boolean isRemote(IProject project) {
        String[] natureIDs;
        try {
            natureIDs = project.getDescription().getNatureIds();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        int i = 0;
        while (i < natureIDs.length) {
            String id = natureIDs[i];
            if (id.equals("org.eclipse.ptp.rdt.core.remoteNature")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

