/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.sharing;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.sharing.ExistingOrNewPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.IConfigurationWizardExtension;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.MoveProjectOperation;

public class SharingWizard
extends Wizard
implements IConfigurationWizard,
IConfigurationWizardExtension {
    IProject[] projects;
    private ExistingOrNewPage existingPage;

    public SharingWizard() {
        this.setWindowTitle(UIText.SharingWizard_windowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IProject[] p) {
        this.projects = new IProject[p.length];
        System.arraycopy(p, 0, this.projects, 0, p.length);
    }

    public void init(IWorkbench workbench, IProject p) {
        this.projects = new IProject[]{p};
    }

    public void addPages() {
        this.existingPage = new ExistingOrNewPage(this);
        this.addPage((IWizardPage)this.existingPage);
    }

    public boolean performFinish() {
        if (!this.existingPage.getInternalMode()) {
            try {
                final Map<IProject, File> projectsToMove = this.existingPage.getProjects(true);
                final Repository selectedRepository = this.existingPage.getSelectedRepsoitory();
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        for (Map.Entry entry : projectsToMove.entrySet()) {
                            IPath currentLocation;
                            Path targetLocation = new Path(((File)entry.getValue()).getPath());
                            if (!targetLocation.equals((Object)(currentLocation = ((IProject)entry.getKey()).getLocation()))) {
                                MoveProjectOperation op = new MoveProjectOperation((IProject)entry.getKey(), ((File)entry.getValue()).toURI(), UIText.SharingWizard_MoveProjectActionLabel);
                                try {
                                    IStatus result = op.execute(monitor, null);
                                    if (!result.isOK()) {
                                        throw new RuntimeException();
                                    }
                                }
                                catch (ExecutionException e) {
                                    if (e.getCause() != null) {
                                        throw new InvocationTargetException(e.getCause());
                                    }
                                    throw new InvocationTargetException(e);
                                }
                            }
                            try {
                                new ConnectProviderOperation((IProject)entry.getKey(), selectedRepository.getDirectory()).execute(monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                Activator.handleError(UIText.SharingWizard_failed, e.getCause(), true);
                return false;
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }
        final ConnectProviderOperation op = new ConnectProviderOperation(this.existingPage.getProjects(true));
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        op.execute(monitor);
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                HashSet<File> filesToAdd = new HashSet<File>();
                                for (Map.Entry<IProject, File> entry : SharingWizard.this.existingPage.getProjects(true).entrySet()) {
                                    filesToAdd.add(entry.getValue());
                                }
                                for (File file : filesToAdd) {
                                    Activator.getDefault().getRepositoryUtil().addConfiguredRepository(file);
                                }
                            }
                        });
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
            });
            return true;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if (e instanceof CoreException) {
                IStatus status = ((CoreException)e).getStatus();
                e = status.getException();
            }
            Activator.handleError(UIText.SharingWizard_failed, e, true);
            return false;
        }
    }

    public boolean canFinish() {
        return this.existingPage.isPageComplete();
    }
}

