/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index;

import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IndexLocationFactory {
    public static IPath getPath(IIndexFileLocation location) {
        String fp = location.getFullPath();
        if (fp != null) {
            return new Path(fp);
        }
        return IndexLocationFactory.getAbsolutePath(location);
    }

    public static IPath getAbsolutePath(IIndexFileLocation location) {
        return UNCPathConverter.toPath(location.getURI());
    }

    public static IIndexFileLocation getIFLExpensive(String absolutePath) {
        return IndexLocationFactory.getIFLExpensive(null, absolutePath);
    }

    public static IIndexFileLocation getIFLExpensive(ICProject cproject, String absolutePath) {
        IProject preferredProject = cproject == null ? null : cproject.getProject();
        IFile file = ResourceLookup.selectFileForLocation((IPath)new Path(absolutePath), (IProject)preferredProject);
        if (file != null && file.exists()) {
            return IndexLocationFactory.getWorkspaceIFL(file);
        }
        return IndexLocationFactory.getExternalIFL(absolutePath);
    }

    public static IIndexFileLocation getExternalIFL(String absolutePath) {
        return IndexLocationFactory.getExternalIFL((IPath)new Path(absolutePath));
    }

    public static IIndexFileLocation getExternalIFL(IPath absolutePath) {
        return new IndexFileLocation(UNCPathConverter.getInstance().toURI(absolutePath), null);
    }

    public static IIndexFileLocation getWorkspaceIFL(IFile file) {
        URI locationURI = file.getLocationURI();
        if (locationURI != null) {
            return new IndexFileLocation(locationURI, file.getFullPath().toString());
        }
        return null;
    }

    public static IIndexFileLocation getIFL(ITranslationUnit tu) {
        IResource res = tu.getResource();
        if (res instanceof IFile) {
            return IndexLocationFactory.getWorkspaceIFL((IFile)res);
        }
        IPath location = tu.getLocation();
        if (location != null) {
            return IndexLocationFactory.getExternalIFL(location);
        }
        return null;
    }
}

