/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.PartServiceImpl;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartActivationHistory {
    private PartServiceImpl partService;
    private EModelService modelService;
    private LinkedList<MPart> generalActivationHistory = new LinkedList();

    PartActivationHistory(PartServiceImpl partService, EModelService modelService) {
        this.partService = partService;
        this.modelService = modelService;
    }

    public void clear() {
        this.generalActivationHistory.clear();
    }

    void activate(MPart part, boolean activateBranch) {
        IEclipseContext context = part.getContext();
        if (activateBranch) {
            context.activateBranch();
        } else {
            IEclipseContext parent = context.getParent();
            do {
                context.activate();
                context = parent;
            } while ((parent = parent.getParent()).get(MWindow.class) != null);
        }
        this.prepend(part);
    }

    void append(MPart part) {
        if (!this.generalActivationHistory.contains(part)) {
            this.generalActivationHistory.addLast(part);
        }
    }

    void prepend(MPart part) {
        this.generalActivationHistory.remove(part);
        this.generalActivationHistory.addFirst(part);
    }

    boolean isValid(MUIElement element) {
        if (element == null || !element.isToBeRendered() || !element.isVisible()) {
            return false;
        }
        if (element instanceof MApplication) {
            return true;
        }
        MElementContainer parent = element.getParent();
        if (parent == null && element instanceof MWindow) {
            parent = (MUIElement)((EObject)element).eContainer();
        }
        if (parent == null) {
            return this.isValid((MUIElement)this.partService.getLocalPlaceholder(element));
        }
        return this.isValid((MUIElement)parent);
    }

    boolean isValid(MPerspective perspective, MUIElement element) {
        if (element instanceof MApplication) {
            return true;
        }
        if (element == null || !element.isToBeRendered() || !element.isVisible()) {
            return false;
        }
        MElementContainer parent = element.getParent();
        if (parent == null) {
            for (MPlaceholder placeholder : this.modelService.findElements((MUIElement)perspective, null, MPlaceholder.class, null)) {
                if (placeholder.getRef() != element) continue;
                return this.isValid(perspective, (MUIElement)placeholder);
            }
            if (element instanceof MWindow) {
                return this.isValid(perspective, (MUIElement)((EObject)element).eContainer());
            }
            return false;
        }
        if (parent instanceof MGenericStack && parent.getSelectedElement() != element) {
            return false;
        }
        return this.isValid(perspective, (MUIElement)parent);
    }

    private MArea isInArea(MUIElement element) {
        MPlaceholder placeholder = element.getCurSharedRef();
        if (placeholder == null) {
            MElementContainer parent = element.getParent();
            if (parent == null) {
                parent = (MUIElement)((EObject)element).eContainer();
            }
            return parent instanceof MApplication ? null : (parent instanceof MArea ? (MArea)parent : this.isInArea((MUIElement)parent));
        }
        MElementContainer parent = placeholder.getParent();
        if (parent == null) {
            parent = (MUIElement)((EObject)placeholder).eContainer();
        }
        return parent instanceof MApplication ? null : (parent instanceof MArea ? (MArea)parent : this.isInArea((MUIElement)parent));
    }

    private MPart getActivationCandidate(MPart part) {
        Collection<MPart> candidates = ((EPartService)part.getContext().get(EPartService.class)).getParts();
        return this.findActivationCandidate(candidates, part);
    }

    private MPart findActivationCandidate(Collection<MPart> candidates, MPart currentlyActivePart) {
        candidates.remove(currentlyActivePart);
        MPlaceholder activePlaceholder = this.partService.getLocalPlaceholder((MUIElement)currentlyActivePart);
        for (MPart candidate : candidates) {
            MElementContainer parent;
            if (!this.isValid((MUIElement)candidate)) continue;
            MPlaceholder placeholder = this.partService.getLocalPlaceholder((MUIElement)candidate);
            MElementContainer mElementContainer = parent = placeholder == null ? candidate.getParent() : placeholder.getParent();
            if (parent instanceof MGenericStack) {
                MUIElement selection = parent.getSelectedElement();
                if (selection == activePlaceholder || selection == currentlyActivePart) {
                    return candidate;
                }
                if (selection != candidate && selection != placeholder) continue;
                return candidate;
            }
            return candidate;
        }
        return null;
    }

    MPart getActivationCandidate(Collection<MPart> validParts) {
        ArrayList<MPart> validCandidates = new ArrayList<MPart>();
        for (MPart validPart : this.generalActivationHistory) {
            if (!validParts.contains(validPart)) continue;
            validCandidates.add(validPart);
        }
        MPart candidate = this.findActivationCandidate(validCandidates);
        if (candidate == null) {
            validParts.removeAll(validCandidates);
            return this.findActivationCandidate(validParts);
        }
        return candidate;
    }

    private MPart findActivationCandidate(Collection<MPart> candidates) {
        for (MPart candidate : candidates) {
            MElementContainer parent;
            if (!this.isValid((MUIElement)candidate)) continue;
            MPlaceholder placeholder = this.partService.getLocalPlaceholder((MUIElement)candidate);
            MElementContainer mElementContainer = parent = placeholder == null ? candidate.getParent() : placeholder.getParent();
            if (parent instanceof MGenericStack) {
                MUIElement selection = parent.getSelectedElement();
                if (selection != candidate && selection != placeholder) continue;
                return candidate;
            }
            return candidate;
        }
        return null;
    }

    MPart getNextActivationCandidate(Collection<MPart> validParts, MPart part) {
        MArea area = this.isInArea((MUIElement)part);
        if (area != null) {
            MPart candidate = this.getSiblingActivationCandidate(part);
            if (candidate != null) {
                return candidate;
            }
            candidate = this.findActivationCandidate(this.modelService.findElements((MUIElement)area, null, MPart.class, null), part);
            if (candidate != null) {
                return candidate;
            }
        }
        ArrayList<MPart> validCandidates = new ArrayList<MPart>();
        for (MPart validPart : this.generalActivationHistory) {
            if (!validParts.contains(validPart)) continue;
            validCandidates.add(validPart);
        }
        MPart candidate = this.findActivationCandidate(validCandidates, part);
        return candidate == null ? this.getActivationCandidate(part) : candidate;
    }

    void forget(MWindow window, MPart part, boolean full) {
        if (full) {
            this.generalActivationHistory.remove(part);
        } else {
            for (MPlaceholder placeholder : this.modelService.findElements((MUIElement)window, null, MPlaceholder.class, null)) {
                if (placeholder.getRef() != part || !placeholder.isToBeRendered()) continue;
                return;
            }
            this.generalActivationHistory.remove(part);
        }
    }

    MPart getActivationCandidate(MPerspective perspective) {
        for (MPart candidate : this.generalActivationHistory) {
            if (!this.partService.isInContainer((MElementContainer<?>)perspective, (MUIElement)candidate) || !this.isValid(perspective, (MUIElement)candidate)) continue;
            return candidate;
        }
        ArrayList<String> activeTag = new ArrayList<String>();
        activeTag.add("activeOnClose");
        List<MPart> activeCandidates = this.modelService.findElements((MUIElement)perspective, null, MPart.class, activeTag);
        if (activeCandidates.size() > 0) {
            activeCandidates.get(0).getTags().remove("activeOnClose");
            MPart candidate = activeCandidates.get(0);
            if (this.partService.isInContainer((MElementContainer<?>)perspective, (MUIElement)candidate) && this.isValid(perspective, (MUIElement)candidate)) {
                return candidate;
            }
        }
        Collection<MPart> candidates = ((EPartService)perspective.getContext().get(EPartService.class)).getParts();
        for (MPart candidate : candidates) {
            if (!this.isValid(perspective, (MUIElement)candidate)) continue;
            return candidate;
        }
        return null;
    }

    private MPart getSiblingActivationCandidate(MPart part) {
        MPlaceholder placeholder = part.getCurSharedRef();
        MUIElement candidate = this.getSiblingSelectionCandidate(part, (MUIElement)(placeholder == null ? part : placeholder));
        return (MPart)(candidate instanceof MPlaceholder ? ((MPlaceholder)candidate).getRef() : candidate);
    }

    private MUIElement getSiblingSelectionCandidate(MPart part, MUIElement element) {
        List siblings = element.getParent().getChildren();
        for (MPart previouslyActivatedPart : this.generalActivationHistory) {
            if (previouslyActivatedPart == part || !this.isValid((MUIElement)previouslyActivatedPart)) continue;
            if (siblings.contains(previouslyActivatedPart)) {
                return previouslyActivatedPart;
            }
            MPlaceholder placeholder = this.partService.getLocalPlaceholder((MUIElement)previouslyActivatedPart);
            if (placeholder == null || !placeholder.isToBeRendered() || !siblings.contains(placeholder)) continue;
            return placeholder;
        }
        return null;
    }

    MUIElement getSiblingSelectionCandidate(MPart part) {
        MPlaceholder placeholder = part.getCurSharedRef();
        return this.getSiblingSelectionCandidate(part, (MUIElement)(placeholder == null ? part : placeholder));
    }
}

