/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.ui.propertyTesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ptp.rm.lml.monitor.core.IMonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControlManager;
import org.eclipse.ptp.rm.lml.monitor.core.listeners.IMonitorChangedListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;

public class MonitorPropertyTester
extends PropertyTester {
    private static final String NAMESPACE = "org.eclipse.ptp.rm.monitor";
    private static final String IS_ACTIVE = "isActive";

    public MonitorPropertyTester() {
        MonitorControlManager.getInstance().addMonitorChangedListener(new IMonitorChangedListener(){

            public void monitorAdded(IMonitorControl[] monitors) {
            }

            public void monitorRemoved(IMonitorControl[] monitors) {
            }

            public void monitorUpdated(IMonitorControl[] monitors) {
                IEvaluationService service;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (service = (IEvaluationService)window.getService(IEvaluationService.class)) != null) {
                    service.requestEvaluation("org.eclipse.ptp.rm.monitor.isActive");
                }
            }
        });
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IMonitorControl) {
            IMonitorControl monitor = (IMonitorControl)receiver;
            if (IS_ACTIVE.equals(property)) {
                return monitor.isActive() == this.toBoolean(expectedValue);
            }
        }
        return false;
    }

    protected boolean toBoolean(Object expectedValue) {
        if (expectedValue instanceof Boolean) {
            return (Boolean)expectedValue;
        }
        return true;
    }
}

