/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ImplicitsAnalysis;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;

public class CPPClassScope
extends CPPScope
implements ICPPClassScope {
    private ICPPMethod[] implicits;

    public CPPClassScope(ICPPASTCompositeTypeSpecifier physicalNode) {
        super(physicalNode);
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }

    public void createImplicitMembers() {
        CPPImplicitMethod m;
        CPPImplicitConstructor m2;
        ICPPASTCompositeTypeSpecifier compTypeSpec = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName name = compTypeSpec.getName().getLastName();
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof ICPPClassType)) {
            return;
        }
        ICPPClassType clsType = (ICPPClassType)binding;
        if (clsType instanceof ICPPClassTemplate) {
            clsType = (ICPPClassType)((Object)((ICPPClassTemplate)clsType).asDeferredInstance());
        }
        char[] className = name.getLookupKey();
        CPPReferenceType pType = new CPPReferenceType(SemanticUtil.constQualify(clsType), false);
        IParameter[] ps = new ICPPParameter[]{new CPPParameter(pType, 0)};
        int i = 0;
        ImplicitsAnalysis ia = new ImplicitsAnalysis(compTypeSpec, clsType);
        this.implicits = new ICPPMethod[ia.getImplicitsToDeclareCount()];
        if (!ia.hasUserDeclaredConstructor()) {
            m2 = new CPPImplicitConstructor(this, className, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY);
            this.implicits[i++] = m2;
            this.addBinding(m2);
        }
        if (!ia.hasUserDeclaredCopyConstructor()) {
            m2 = new CPPImplicitConstructor(this, className, (ICPPParameter[])ps);
            this.implicits[i++] = m2;
            this.addBinding(m2);
        }
        if (!ia.hasUserDeclaredCopyAssignmentOperator()) {
            CPPReferenceType refType = new CPPReferenceType(clsType, false);
            ICPPFunctionType ft = CPPVisitor.createImplicitFunctionType(refType, ps, false, false);
            m = new CPPImplicitMethod(this, OverloadableOperator.ASSIGN.toCharArray(), ft, (ICPPParameter[])ps);
            this.implicits[i++] = m;
            this.addBinding(m);
        }
        if (!ia.hasUserDeclaredDestructor()) {
            ICPPFunctionType ft = CPPVisitor.createImplicitFunctionType(new CPPBasicType(IBasicType.Kind.eUnspecified, 0), ICPPParameter.EMPTY_CPPPARAMETER_ARRAY, false, false);
            char[] dtorName = CharArrayUtils.concat("~".toCharArray(), className);
            m = new CPPImplicitMethod(this, dtorName, ft, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY);
            this.implicits[i++] = m;
            this.addBinding(m);
        }
    }

    @Override
    public IScope getParent() {
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        return CPPVisitor.getContainingNonTemplateScope(compName);
    }

    @Override
    public void addBinding(IBinding binding) {
        if (binding instanceof ICPPConstructor) {
            this.addConstructor(binding);
            return;
        }
        super.addBinding(binding);
    }

    @Override
    public void addName(IASTName name) {
        IASTNode parent;
        if (!name.isActive()) {
            return;
        }
        if (name instanceof ICPPASTQualifiedName) {
            IBinding b = this.getClassType();
            ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
            ICPPASTNameSpecifier[] qualifier = qname.getQualifier();
            int i = qualifier.length;
            while (--i >= 0) {
                char[] segmentName;
                if (b == null) {
                    return;
                }
                if (qualifier[i] instanceof IASTName) {
                    segmentName = ((IASTName)((Object)qualifier[i])).getLookupKey();
                } else {
                    IBinding segmentBinding = qualifier[i].resolveBinding();
                    if (segmentBinding == null) {
                        return;
                    }
                    segmentName = segmentBinding.getNameCharArray();
                }
                if (!CharArrayUtils.equals(segmentName, b.getNameCharArray())) {
                    return;
                }
                b = b.getOwner();
            }
            if (qname.isFullyQualified() && b != null) {
                return;
            }
        }
        if ((parent = name.getParent()) instanceof IASTDeclarator && CPPVisitor.isConstructor(this, (IASTDeclarator)parent)) {
            this.addConstructor(name);
            return;
        }
        super.addName(name);
    }

    private void addConstructor(Object constructor) {
        Object o;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if ((o = this.bindings.get(CONSTRUCTOR_KEY)) != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(constructor);
            } else {
                ObjectSet<Object> set = new ObjectSet<Object>(2);
                set.put(o);
                set.put(constructor);
                this.bindings.put(CONSTRUCTOR_KEY, set);
            }
        } else {
            this.bindings.put(CONSTRUCTOR_KEY, constructor);
        }
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        char[] c = name.getLookupKey();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        if (compName instanceof ICPPASTTemplateId) {
            compName = ((ICPPASTTemplateId)compName).getTemplateName();
        }
        if (CharArrayUtils.equals(c, compName.getLookupKey())) {
            return compName.resolveBinding();
        }
        return super.getBinding(name, resolve, fileSet);
    }

    @Override
    public IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        char[] c = lookup.getLookupKey();
        boolean prefixLookup = lookup.isPrefixLookup();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        if (compName instanceof ICPPASTTemplateId) {
            compName = ((ICPPASTTemplateId)compName).getTemplateName();
        }
        IBinding[] result = null;
        if (!prefixLookup && CharArrayUtils.equals(c, compName.getLookupKey()) || prefixLookup && ContentAssistMatcherFactory.getInstance().match(c, compName.getLookupKey())) {
            IASTName lookupName = lookup.getLookupName();
            if (CPPClassScope.shallReturnConstructors(lookupName, prefixLookup)) {
                result = ArrayUtil.addAll(IBinding.class, result, this.getConstructors(lookupName, lookup.isResolve()));
            }
            result = ArrayUtil.append(IBinding.class, result, compName.resolveBinding());
        }
        result = ArrayUtil.addAll(IBinding.class, result, super.getBindings(lookup));
        return ArrayUtil.trim(IBinding.class, result);
    }

    protected static boolean shouldResolve(boolean force, IASTName candidate, IASTName forName) {
        if (!force || candidate == forName) {
            return false;
        }
        if (forName == null) {
            return true;
        }
        return forName.isReference() || CPPSemantics.declaredBefore(candidate, forName, false);
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        return this.getConstructors(null, true);
    }

    private ICPPConstructor[] getConstructors(IASTName forName, boolean forceResolve) {
        this.populateCache();
        CharArrayObjectMap nameMap = this.bindings;
        if (nameMap == null) {
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
        Object o = nameMap.get(CONSTRUCTOR_KEY);
        if (o != null) {
            IBinding binding = null;
            if (o instanceof ObjectSet) {
                ObjectSet set = (ObjectSet)o;
                ICPPConstructor[] bs = ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
                int i = 0;
                while (i < set.size()) {
                    Object obj = set.keyAt(i);
                    if (obj instanceof IASTName) {
                        IASTName n = (IASTName)obj;
                        IBinding iBinding = binding = CPPClassScope.shouldResolve(forceResolve, n, forName) ? n.resolveBinding() : n.getBinding();
                        if (binding instanceof ICPPConstructor) {
                            bs = ArrayUtil.append(bs, (ICPPConstructor)binding);
                        }
                    } else if (obj instanceof ICPPConstructor) {
                        bs = ArrayUtil.append(bs, (ICPPConstructor)obj);
                    }
                    ++i;
                }
                return ArrayUtil.trim(ICPPConstructor.class, bs);
            }
            if (o instanceof IASTName) {
                if (CPPClassScope.shouldResolve(forceResolve, (IASTName)o, forName) || ((IASTName)o).getBinding() != null) {
                    nameMap.put(CONSTRUCTOR_KEY, o);
                    binding = ((IASTName)o).resolveBinding();
                }
            } else if (o instanceof IBinding) {
                binding = (IBinding)o;
            }
            if (binding != null && binding instanceof ICPPConstructor) {
                return new ICPPConstructor[]{(ICPPConstructor)binding};
            }
        }
        return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
    }

    @Override
    public IBinding[] find(String name) {
        char[] n = name.toCharArray();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        if (compName instanceof ICPPASTTemplateId) {
            compName = ((ICPPASTTemplateId)compName).getTemplateName();
        }
        if (CharArrayUtils.equals(compName.getLookupKey(), n)) {
            return new IBinding[]{compName.resolveBinding()};
        }
        return super.find(name);
    }

    public static boolean shallReturnConstructors(IASTName name, boolean isPrefixLookup) {
        if (name == null) {
            return false;
        }
        if (!isPrefixLookup) {
            return CPPVisitor.isConstructorDeclaration(name);
        }
        IASTNode node = name.getParent();
        if (node instanceof ICPPASTTemplateId) {
            return false;
        }
        if (node instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)node).getLastName() == name) {
                node = node.getParent();
            } else {
                return false;
            }
        }
        if (node instanceof IASTDeclSpecifier) {
            IASTNode parent = node.getParent();
            return parent instanceof IASTTypeId && parent.getParent() instanceof ICPPASTNewExpression;
        }
        return !(node instanceof IASTFieldReference);
    }

    @Override
    public ICPPClassType getClassType() {
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName name = compSpec.getName();
        IBinding binding = name.resolveBinding();
        if (binding instanceof ICPPClassType) {
            return (ICPPClassType)binding;
        }
        return new CPPClassType.CPPClassTypeProblem((IASTNode)name, 16, name.toCharArray());
    }

    @Override
    public ICPPMethod[] getImplicitMethods() {
        if (this.implicits == null) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        return this.implicits;
    }

    @Override
    public IName getScopeName() {
        IASTNode node = this.getPhysicalNode();
        if (node instanceof ICPPASTCompositeTypeSpecifier) {
            return ((ICPPASTCompositeTypeSpecifier)node).getName();
        }
        return null;
    }
}

