/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.lsf.ui.widgets;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.rm.ibm.lsf.ui.LSFCommand;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.LSFQueryDialog;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.IWidgetDescriptor2;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class LSFQueryControl
extends Composite {
    protected String[] columnLabels;
    protected Vector<String[]> commandResponse;
    protected LSFQueryDialog dialog;
    private final List<ModifyListener> modifyListeners = new LinkedList<ModifyListener>();
    protected String selectedValues = "";
    protected String queryTitle;
    protected final IWidgetDescriptor2 widgetDescriptor;

    public LSFQueryControl(Composite parent, IWidgetDescriptor2 wd) {
        super(parent, wd.getStyle());
        this.widgetDescriptor = wd;
        this.setLayout((Layout)new FillLayout());
        this.setLayoutData(wd.getLayoutData());
        Button button = new Button((Composite)this, 8);
        button.setText(wd.getFixedText());
        button.setToolTipText(wd.getToolTipText());
        this.commandResponse = new Vector();
        this.configureQueryButton(button, wd.getRemoteConnection());
    }

    public void addModifyListener(ModifyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.modifyListeners.add(listener);
    }

    protected abstract void configureQueryButton(Button var1, IRemoteConnection var2);

    protected abstract void getQueryResponse(IRemoteConnection var1);

    public String getSelectedValue() {
        return this.selectedValues;
    }

    protected void notifyListeners() {
        for (ModifyListener listener : this.modifyListeners) {
            listener.modifyText(null);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.modifyListeners.remove(listener);
    }

    public void setSelectedValues(String value) {
        this.selectedValues = value;
    }

    public boolean widgetSelected() {
        return this.selectedValues != null;
    }

    protected void processCommandResponse(LSFCommand command, IStatus runStatus) {
        switch (runStatus.getSeverity()) {
            case 0: {
                this.dialog = new LSFQueryDialog(this.getShell(), this.queryTitle, command.getColumnLabels(), command.getCommandResponse(), true);
                this.dialog.setSelectedValue(this.selectedValues);
                int selection = this.dialog.open();
                if (selection != 0) break;
                this.selectedValues = this.dialog.getSelectedValues();
                this.notifyListeners();
                break;
            }
            case 1: {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.InformationalMessage, (String)runStatus.getMessage());
                break;
            }
            case 2: {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.WarningMessageLabel, (String)runStatus.getMessage());
                break;
            }
            case 4: {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ErrorMessage, (String)runStatus.getMessage());
            }
        }
    }
}

