/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.ui.search.CSearchElement;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class LineSearchElement
extends CSearchElement {
    private final int fOffset;
    private final int fNumber;
    private final String fContent;
    private final Match[] fMatches;
    private static final MatchesComparator MATCHES_COMPARATOR = new MatchesComparator();

    private LineSearchElement(IIndexFileLocation file, Match[] matches, int number, String content, int offset) {
        super(file);
        this.fMatches = matches;
        this.fNumber = number;
        int index = 0;
        int length = content.length();
        int firstMatchOffset = matches[0].getOffset();
        while (offset < firstMatchOffset && length > 0) {
            if (!Character.isWhitespace(content.charAt(index))) break;
            ++index;
            ++offset;
            --length;
        }
        this.fOffset = offset;
        this.fContent = content.substring(index).trim();
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLineNumber() {
        return this.fNumber;
    }

    public String getContent() {
        return this.fContent;
    }

    public Match[] getMatches() {
        return this.fMatches;
    }

    public String toString() {
        return String.valueOf(this.fNumber) + ": " + this.fContent;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LineSearchElement)) {
            return false;
        }
        LineSearchElement other = (LineSearchElement)obj;
        return this.fOffset == other.fOffset && super.equals(obj) && this.fMatches.equals(other.fMatches);
    }

    @Override
    public int hashCode() {
        return this.fOffset + 31 * (super.hashCode() + 31 * this.fMatches.hashCode());
    }

    public static LineSearchElement[] createElements(IIndexFileLocation fileLocation, Match[] matches) {
        AbstractCharArray buf;
        Arrays.sort(matches, MATCHES_COMPARATOR);
        LineSearchElement[] result = new LineSearchElement[]{};
        FileContent content = FileContent.create((IIndexFileLocation)fileLocation);
        if (content != null && (buf = ((InternalFileContent)content).getSource()) != null) {
            result = LineSearchElement.collectLineElements(buf, matches, fileLocation);
        }
        return result;
    }

    public static LineSearchElement[] createElements(IIndexFileLocation fileLocation, Match[] matches, IDocument document) {
        Arrays.sort(matches, MATCHES_COMPARATOR);
        ArrayList<LineSearchElement> result = new ArrayList<LineSearchElement>();
        ArrayList<Match> matchCollector = new ArrayList<Match>();
        int minOffset = 0;
        int lineNumber = 0;
        int lineOffset = 0;
        int lineLength = 0;
        int lineEndOffset = 0;
        try {
            Match[] matchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                int offset = match.getOffset();
                if (offset < lineEndOffset) {
                    if (offset < minOffset) {
                        matchCollector.add(match);
                        minOffset = offset + match.getLength();
                    }
                } else {
                    if (!matchCollector.isEmpty()) {
                        String content = document.get(lineOffset, lineLength);
                        Match[] lineMatches = matchCollector.toArray(new Match[matchCollector.size()]);
                        result.add(new LineSearchElement(fileLocation, lineMatches, lineNumber + 1, content, lineOffset));
                        matchCollector.clear();
                    }
                    lineNumber = document.getLineOfOffset(offset);
                    lineOffset = document.getLineOffset(lineNumber);
                    lineLength = document.getLineLength(lineNumber);
                    lineEndOffset = lineOffset + lineLength;
                    matchCollector.add(match);
                }
                ++n2;
            }
            if (!matchCollector.isEmpty()) {
                String content = document.get(lineOffset, lineLength);
                Match[] lineMatches = matchCollector.toArray(new Match[matchCollector.size()]);
                result.add(new LineSearchElement(fileLocation, lineMatches, lineNumber + 1, content, lineOffset));
                matchCollector.clear();
            }
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
        }
        return result.toArray(new LineSearchElement[result.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private static LineSearchElement[] collectLineElements(AbstractCharArray buf, Match[] matches, IIndexFileLocation fileLocation) {
        result = new ArrayList<LineSearchElement>();
        matchCollector = new ArrayList<Match>();
        skipLF = false;
        lineNumber = 1;
        lineOffset = 0;
        i = 0;
        match = matches[i];
        matchOffset = match.getOffset();
        pos = 0;
        while (buf.isValidOffset(pos)) {
            if (matchOffset <= pos && match != null) {
                matchCollector.add(match);
                minOffset = matchOffset + match.getLength();
                match = null;
                matchOffset = 0x7FFFFFFF;
                ++i;
                while (i < matches.length) {
                    nextMatch = matches[i];
                    nextOffset = nextMatch.getOffset();
                    if (nextOffset >= minOffset) {
                        match = nextMatch;
                        matchOffset = nextOffset;
                        break;
                    }
                    ++i;
                }
            }
            c = buf.get(pos);
            if (!skipLF) ** GOTO lbl-1000
            skipLF = false;
            if (c == '\n') {
                lineOffset = pos + 1;
            } else if (c == '\n' || c == '\r') {
                if (!matchCollector.isEmpty()) {
                    lineLength = pos - lineOffset;
                    lineMatches = matchCollector.toArray(new Match[matchCollector.size()]);
                    lineChars = new char[lineLength];
                    buf.arraycopy(lineOffset, lineChars, 0, lineLength);
                    lineContent = new String(lineChars);
                    result.add(new LineSearchElement(fileLocation, lineMatches, lineNumber, lineContent, lineOffset));
                    matchCollector.clear();
                    if (match == null) break;
                }
                ++lineNumber;
                lineOffset = pos + 1;
                if (c == '\r') {
                    skipLF = true;
                }
            }
            ++pos;
        }
        if (!matchCollector.isEmpty()) {
            lineLength = buf.getLength() - lineOffset;
            lineMatches = matchCollector.toArray(new Match[matchCollector.size()]);
            lineChars = new char[lineLength];
            buf.arraycopy(lineOffset, lineChars, 0, lineLength);
            lineContent = new String(lineChars);
            result.add(new LineSearchElement(fileLocation, lineMatches, lineNumber, lineContent, lineOffset));
        }
        return result.toArray(new LineSearchElement[result.size()]);
    }

    public static final class Match {
        private final int fOffset;
        private final int fLength;
        private final boolean fIsPolymorphicCall;
        private final ICElement fEnclosingElement;
        private final boolean fIsWriteAccess;

        public Match(int offset, int length, boolean isPolymorphicCall, ICElement enclosingElement, boolean isWriteAccess) {
            this.fOffset = offset;
            this.fLength = length;
            this.fIsPolymorphicCall = isPolymorphicCall;
            this.fEnclosingElement = enclosingElement;
            this.fIsWriteAccess = isWriteAccess;
        }

        public int getOffset() {
            return this.fOffset;
        }

        public int getLength() {
            return this.fLength;
        }

        public boolean isPolymorphicCall() {
            return this.fIsPolymorphicCall;
        }

        public ICElement getEnclosingElement() {
            return this.fEnclosingElement;
        }

        public boolean isWriteAccess() {
            return this.fIsWriteAccess;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Match)) {
                return false;
            }
            Match m = (Match)obj;
            return this.fOffset == m.fOffset && this.fLength == m.fLength;
        }

        public int hashCode() {
            return 31 * this.fOffset + this.fLength;
        }
    }

    private static final class MatchesComparator
    implements Comparator<Match> {
        private MatchesComparator() {
        }

        @Override
        public int compare(Match m1, Match m2) {
            int diff = m1.getOffset() - m2.getOffset();
            if (diff == 0) {
                diff = m2.getLength() - m1.getLength();
            }
            return diff;
        }
    }
}

