/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.IPJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJob;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStatus;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStatusMap;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStreamMonitor;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStreamsProxy;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlCorePlugin;
import org.eclipse.ptp.internal.rm.jaxb.control.core.RemoteServicesDelegate;
import org.eclipse.ptp.internal.rm.jaxb.control.core.messages.Messages;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.JobStatusMap;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;

public class CommandJobStatus
implements ICommandJobStatus {
    private final ILaunchController control;
    private final ICommandJob open;
    private final String launchMode;
    private final IVariableMap fVarMap;
    private String jobId;
    private String owner;
    private String queue;
    private String state;
    private String stateDetail;
    private String remoteOutputPath;
    private String remoteErrorPath;
    private ICommandJobStreamsProxy proxy;
    private IRemoteProcess process;
    private PProcesses fProcesses;
    private boolean initialized;
    private boolean waitEnabled;
    private boolean dirty;
    private boolean fFilesChecked;
    private long lastRequestedUpdate;

    public CommandJobStatus(ICommandJob open, ILaunchController control, IVariableMap map, String mode) {
        this(null, "UNDETERMINED", open, control, map, mode);
    }

    public CommandJobStatus(String jobId, String state, ICommandJob open, ILaunchController control, IVariableMap map, String mode) {
        this.jobId = jobId;
        this.normalizeState(state);
        this.open = open;
        this.control = control;
        this.fVarMap = map;
        this.launchMode = mode;
        this.waitEnabled = true;
        this.lastRequestedUpdate = 0L;
        this.initialized = false;
        this.dirty = false;
        this.fFilesChecked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        CommandJobStatus commandJobStatus = this;
        synchronized (commandJobStatus) {
            block9: {
                block8: {
                    block7: {
                        if (this.getStateRank(this.stateDetail) <= 4) break block7;
                        return false;
                    }
                    this.waitEnabled = false;
                    if (this.open == null) break block8;
                    this.open.terminate();
                    this.open.getJobStatus().setState("CANCELED");
                    return true;
                }
                this.notifyAll();
                if (this.process == null || this.process.isCompleted()) break block9;
                this.process.destroy();
                if (this.proxy != null) {
                    this.proxy.close();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelWait() {
        CommandJobStatus commandJobStatus = this;
        synchronized (commandJobStatus) {
            this.waitEnabled = false;
            this.notifyAll();
        }
    }

    private boolean canUpdateState(String newState) {
        int currRank;
        int prevRank = this.getStateRank(this.stateDetail);
        if (prevRank >= (currRank = this.getStateRank(newState))) {
            if (prevRank == 0) {
                return true;
            }
            if (prevRank != 4 || currRank != 3) {
                return false;
            }
        }
        return true;
    }

    private FileReadyChecker checkForReady(String path, int block, IProgressMonitor monitor) {
        FileReadyChecker t = new FileReadyChecker(String.valueOf(Messages.CommandJobStatus_Checking_output_file) + path);
        t.block = block;
        t.path = path;
        t.callerMonitor = monitor;
        t.schedule();
        return t;
    }

    private void checkProcessStateForTermination() {
        if (this.process != null && this.process.isCompleted()) {
            this.setState(this.process.exitValue() == 0 ? "COMPLETED" : "FAILED");
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPJobStatus.class) {
            if (this.fProcesses != null) {
                return this;
            }
            if (this.jobId != null && this.control != null) {
                String link;
                AttributeType nProcsAttr = this.fVarMap.get("mpiNumberOfProcesses");
                if (nProcsAttr != null && (link = nProcsAttr.getLinkValueTo()) != null) {
                    nProcsAttr = this.fVarMap.get(link);
                }
                if (nProcsAttr != null) {
                    int nProcs = 0;
                    try {
                        nProcs = Integer.parseInt(nProcsAttr.getValue().toString());
                    }
                    catch (Exception exception) {}
                    if (nProcs > 0) {
                        this.fProcesses = new PProcesses(nProcs);
                        return this;
                    }
                }
            }
        }
        return null;
    }

    public String getControlId() {
        return this.control.getControlId();
    }

    public String getErrorPath() {
        return this.remoteErrorPath;
    }

    public synchronized String getJobId() {
        return this.jobId;
    }

    public synchronized long getLastUpdateRequest() {
        return this.lastRequestedUpdate;
    }

    public String getLaunchMode() {
        return this.launchMode;
    }

    public int getNumberOfProcesses() {
        return this.fProcesses != null ? this.fProcesses.getNumberOfProcesses() : 0;
    }

    public String getOutputPath() {
        return this.remoteOutputPath;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getProcessState(int proc) {
        return this.fProcesses != null ? this.fProcesses.getProcessState(proc) : "";
    }

    public String getQueueName() {
        return this.queue;
    }

    public synchronized String getState() {
        if (this.stateDetail != "CANCELED") {
            this.checkProcessStateForTermination();
        }
        return this.state;
    }

    public synchronized String getStateDetail() {
        if (this.stateDetail != "CANCELED") {
            this.checkProcessStateForTermination();
        }
        return this.stateDetail;
    }

    private int getStateRank(String state) {
        if ("SUBMITTED".equals(state)) {
            return 1;
        }
        if ("RUNNING".equals(state)) {
            return 4;
        }
        if ("SUSPENDED".equals(state)) {
            return 3;
        }
        if ("COMPLETED".equals(state)) {
            return 5;
        }
        if ("QUEUED_ACTIVE".equals(state)) {
            return 2;
        }
        if ("SYSTEM_ON_HOLD".equals(state)) {
            return 3;
        }
        if ("USER_ON_HOLD".equals(state)) {
            return 3;
        }
        if ("USER_SYSTEM_ON_HOLD".equals(state)) {
            return 3;
        }
        if ("SYSTEM_SUSPENDED".equals(state)) {
            return 3;
        }
        if ("USER_SUSPENDED".equals(state)) {
            return 3;
        }
        if ("USER_SYSTEM_SUSPENDED".equals(state)) {
            return 3;
        }
        if ("FAILED".equals(state)) {
            return 6;
        }
        if ("CANCELED".equals(state)) {
            return 6;
        }
        if ("JOB_OUTERR_READY".equals(state)) {
            return 7;
        }
        return 0;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.proxy;
    }

    public void initialize(String jobId) {
        if (this.initialized) {
            return;
        }
        this.jobId = jobId;
        String path = null;
        this.remoteOutputPath = null;
        this.remoteErrorPath = null;
        AttributeType a = this.fVarMap.get("stdout_remote_path");
        if (a != null && (path = (String)a.getValue()) != null && !"".equals(path)) {
            this.remoteOutputPath = this.fVarMap.getString(jobId, path);
        }
        if ((a = this.fVarMap.get("stderr_remote_path")) != null && (path = (String)a.getValue()) != null && !"".equals(path)) {
            this.remoteErrorPath = this.fVarMap.getString(jobId, path);
        }
        this.initialized = true;
    }

    public boolean isInteractive() {
        return this.process != null;
    }

    private boolean isReached(String state, String waitUntil) {
        int j;
        int i = this.getStateRank(state);
        return i >= (j = this.getStateRank(waitUntil));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWaitEnabled() {
        boolean w = true;
        CommandJobStatus commandJobStatus = this;
        synchronized (commandJobStatus) {
            w = this.waitEnabled;
        }
        return w;
    }

    public void rerun() {
        if (this.getState().equals("RUNNING") && this.isInteractive()) {
            this.open.rerun();
        }
    }

    public void maybeWaitForHandlerFiles(int blockForSecs, IProgressMonitor monitor) {
        if (this.fFilesChecked) {
            return;
        }
        FileReadyChecker tout = null;
        FileReadyChecker terr = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (this.remoteOutputPath != null) {
            tout = this.checkForReady(this.remoteOutputPath, blockForSecs, (IProgressMonitor)progress.newChild(5));
        }
        if (this.remoteErrorPath != null) {
            terr = this.checkForReady(this.remoteErrorPath, blockForSecs, (IProgressMonitor)progress.newChild(5));
        }
        if (tout == null && terr == null) {
            this.fFilesChecked = true;
            return;
        }
        if (tout != null) {
            try {
                tout.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (terr != null) {
            try {
                terr.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (tout != null && tout.ready || terr != null && terr.ready) {
            this.setState("JOB_OUTERR_READY");
        }
        this.fFilesChecked = true;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setProcess(IRemoteProcess process) {
        this.process = process;
    }

    public void setProcessOutput(BitSet procs, String output) {
        if (this.fProcesses != null) {
            this.fProcesses.setProcessOutput(procs, output);
        }
    }

    public void setProcessState(BitSet procs, String state) {
        if (this.fProcesses != null) {
            this.fProcesses.setProcessState(procs, state);
        }
    }

    public void setProxy(ICommandJobStreamsProxy proxy) {
        this.proxy = proxy;
    }

    public void setQueueName(String name) {
        this.queue = name;
    }

    public synchronized void setState(String state) {
        if (!this.canUpdateState(state)) {
            return;
        }
        this.dirty = false;
        String previousDetail = this.stateDetail;
        this.normalizeState(state);
        if (previousDetail == null || !previousDetail.equals(this.stateDetail)) {
            this.dirty = true;
            JobManager.getInstance().fireJobChanged((IJobStatus)this);
        }
    }

    private void normalizeState(String newState) {
        if ("UNDETERMINED".equals(newState)) {
            this.state = "UNDETERMINED";
            this.stateDetail = "UNDETERMINED";
        } else if ("SUBMITTED".equals(newState)) {
            this.state = "SUBMITTED";
            this.stateDetail = "SUBMITTED";
        } else if ("RUNNING".equals(newState)) {
            this.state = "RUNNING";
            this.stateDetail = "RUNNING";
        } else if ("SUSPENDED".equals(newState)) {
            this.state = "SUSPENDED";
            this.stateDetail = "SUSPENDED";
        } else if ("COMPLETED".equals(newState)) {
            this.state = "COMPLETED";
            this.stateDetail = "COMPLETED";
        } else if ("QUEUED_ACTIVE".equals(newState)) {
            this.state = "SUBMITTED";
            this.stateDetail = "QUEUED_ACTIVE";
        } else if ("SYSTEM_ON_HOLD".equals(newState)) {
            this.state = "SUBMITTED";
            this.stateDetail = "SYSTEM_ON_HOLD";
        } else if ("USER_ON_HOLD".equals(newState)) {
            this.state = "SUBMITTED";
            this.stateDetail = "USER_ON_HOLD";
        } else if ("USER_SYSTEM_ON_HOLD".equals(newState)) {
            this.state = "SUBMITTED";
            this.stateDetail = "USER_SYSTEM_ON_HOLD";
        } else if ("SYSTEM_SUSPENDED".equals(newState)) {
            this.state = "SUSPENDED";
            this.stateDetail = "SYSTEM_SUSPENDED";
        } else if ("USER_SUSPENDED".equals(newState)) {
            this.state = "SUSPENDED";
            this.stateDetail = "USER_SUSPENDED";
        } else if ("USER_SYSTEM_SUSPENDED".equals(newState)) {
            this.state = "SUSPENDED";
            this.stateDetail = "USER_SYSTEM_SUSPENDED";
        } else if ("FAILED".equals(newState)) {
            this.state = "COMPLETED";
            this.stateDetail = "FAILED";
        } else if ("CANCELED".equals(newState)) {
            this.state = "COMPLETED";
            this.stateDetail = "CANCELED";
        } else if ("JOB_OUTERR_READY".equals(newState)) {
            this.state = "COMPLETED";
            this.stateDetail = "JOB_OUTERR_READY";
        }
    }

    public synchronized void setUpdateRequestTime(long update) {
        this.lastRequestedUpdate = update;
    }

    public synchronized boolean stateChanged() {
        boolean changed = this.dirty && !"UNDETERMINED".equals(this.state);
        this.dirty = false;
        return changed;
    }

    public String toString() {
        ArrayList<String> s = new ArrayList<String>();
        s.add(this.jobId);
        s.add(this.owner);
        s.add(this.queue);
        s.add(this.state);
        s.add(this.stateDetail);
        s.add(this.remoteOutputPath);
        s.add(this.remoteErrorPath);
        return ((Object)s).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobId(String uuid, String waitUntil, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        while (!(progress.isCanceled() || !this.isWaitEnabled() || this.jobId != null && this.isReached(this.state, waitUntil))) {
            CommandJobStatus commandJobStatus = this;
            synchronized (commandJobStatus) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            progress.setWorkRemaining(10);
            if (this.isInteractive() && this.isWaitEnabled() && this.process.isCompleted() && this.process.exitValue() != 0) {
                throw CoreExceptionUtils.newException((String)(String.valueOf(uuid) + ":" + " " + "FAILED"), null);
            }
            AttributeType a = this.fVarMap.get(uuid);
            if (a == null) continue;
            this.jobId = a.getName();
            String v = (String)a.getValue();
            if (v != null) {
                this.setState(v);
            }
            if (this.jobId != null && this.stateChanged()) {
                this.fVarMap.put(this.jobId, a);
                ICommandJobStatusMap map = JobStatusMap.getInstance(this.control);
                if (map != null) {
                    map.addJobStatus(this.jobId, this);
                }
            }
            if (this.stateDetail != "FAILED") continue;
            throw CoreExceptionUtils.newException((String)(String.valueOf(uuid) + ":" + " " + "FAILED"), null);
        }
    }

    private class FileReadyChecker
    extends Job {
        private boolean ready;
        private int block;
        private String path;
        private IProgressMonitor callerMonitor;

        public FileReadyChecker(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.ready = false;
            long timeout = this.block * 1000;
            RemoteServicesDelegate d = null;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)120);
            try {
                d = RemoteServicesDelegate.getDelegate(CommandJobStatus.this.control.getRemoteServicesId(), CommandJobStatus.this.control.getConnectionName(), (IProgressMonitor)progress.newChild(20));
                if (d.getRemoteFileManager() == null) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
            }
            catch (CoreException ce) {
                IStatus iStatus = CoreExceptionUtils.getErrorStatus((String)ce.getMessage(), (Throwable)ce);
                return iStatus;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
            long start = System.currentTimeMillis();
            long last = 0L;
            long elapsed = 0L;
            double increment = 0.0;
            do {
                try {
                    this.ready = RemoteServicesDelegate.isStable(d.getRemoteFileManager(), this.path, 3, (IProgressMonitor)progress.newChild(20));
                }
                catch (Throwable t) {
                    JAXBControlCorePlugin.log(t);
                }
                if (this.ready || (elapsed = System.currentTimeMillis() - start) >= timeout) break;
                increment = (double)(elapsed - last) / (double)timeout * 100.0;
                last = elapsed;
                progress.worked((int)increment);
            } while (!progress.isCanceled() && !this.callerMonitor.isCanceled());
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    private class PProcesses {
        private final Map<String, BitSet> fProcState = new HashMap<String, BitSet>();
        private final int fNumProcs;

        public PProcesses(int nprocs) {
            this.fNumProcs = nprocs;
            this.fProcState.put("COMPLETED", new BitSet(nprocs));
            this.fProcState.put("RUNNING", new BitSet(nprocs));
            this.fProcState.put("SUSPENDED", new BitSet(nprocs));
        }

        public int getNumberOfProcesses() {
            return this.fNumProcs;
        }

        public String getProcessState(int proc) {
            for (String state : this.fProcState.keySet()) {
                if (!this.fProcState.get(state).get(proc)) continue;
                return state;
            }
            return "UNDETERMINED";
        }

        public void setProcessOutput(BitSet procs, String output) {
            ICommandJobStreamMonitor monitor = (ICommandJobStreamMonitor)CommandJobStatus.this.getStreamsProxy().getOutputStreamMonitor();
            monitor.append(output);
        }

        public void setProcessState(BitSet procs, String newState) {
            for (String state : this.fProcState.keySet()) {
                if (state.equals(newState)) {
                    this.fProcState.get(state).or(procs);
                    continue;
                }
                this.fProcState.get(state).andNot(procs);
            }
        }
    }
}

