/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFormatException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeAddress;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeCharPointer;
import org.eclipse.ptp.internal.debug.core.pdi.aif.AIFTypeString;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFTypeCharPointer
extends AIFTypeString
implements IAIFTypeCharPointer {
    private IAIFType fAddrType;

    public IAIFTypeAddress getAddressType() {
        return (IAIFTypeAddress)this.fAddrType;
    }

    public String parse(String fmt) throws AIFFormatException {
        fmt = AIFFactory.parseType(fmt);
        IAIFType type = AIFFactory.getType();
        if (!(type instanceof IAIFTypeAddress)) {
            throw new AIFFormatException(Messages.AIFTypeCharPointer_0);
        }
        this.fAddrType = type;
        return fmt;
    }

    public int sizeof() {
        return this.getAddressType().sizeof() + super.sizeof();
    }

    public String toString() {
        return String.valueOf('p') + this.getAddressType().toString();
    }
}

