/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ems.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.internal.ems.ui.AsyncRepopulationStrategy;
import org.eclipse.ptp.internal.ems.ui.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public final class SearchableSelectionList
extends Composite {
    private final Composite fMainGroup;
    private Label fInstructionsLabel;
    private Text fSearchBoxText;
    private Table fAvailableTable;
    private Table fSelectedTable;
    private TableColumn fSelectedColumn;
    private TableColumn fAvailableColumn;
    private Button fSetDefaultsButton;
    private Button fReloadButton;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;
    private Set<String> fAvailableItems = Collections.emptySet();
    private List<String> fSelectedItems = Collections.emptyList();

    public SearchableSelectionList(Composite parent) {
        super(parent, 0);
        GridLayout g = new GridLayout(4, false);
        g.marginHeight = 0;
        g.marginWidth = 0;
        this.setLayout((Layout)g);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.fMainGroup = this;
        this.createInstructionalMessage();
        this.createTableWithSearchBox();
        this.createAddRemoveButtons();
        this.createTable();
        this.createRightButtons();
        this.createLowerButtons();
        this.layout();
    }

    public void addClearButtonSelectonListener(SelectionListener listener) {
    }

    public void addDefaultButtonSelectonListener(SelectionListener listener) {
        this.fSetDefaultsButton.addSelectionListener(listener);
    }

    public void addReloadButtonSelectonListener(SelectionListener listener) {
        this.fReloadButton.addSelectionListener(listener);
    }

    public void asyncRepopulate(AsyncRepopulationStrategy strategy) {
        this.setItems(Collections.<String>emptyList(), Collections.<String>emptyList());
        TableItem tableItem = new TableItem(this.fAvailableTable, 0);
        tableItem.setText(1, strategy.getMessage());
        tableItem.setForeground(this.getDisplay().getSystemColor(33));
        this.setEnabled(false);
        AsyncRepopulationJob job = new AsyncRepopulationJob(strategy);
        job.setPriority(10);
        job.schedule();
    }

    private boolean canMoveDown(Table table) {
        int[] indices = table.getSelectionIndices();
        return indices.length > 0 && indices[indices.length - 1] < table.getItemCount() - 1;
    }

    private boolean canMoveUp(Table table) {
        int[] indices = table.getSelectionIndices();
        return indices.length > 0 && indices[indices.length - 1] > indices.length - 1;
    }

    private Pattern compilePattern() {
        String patternText = this.fSearchBoxText.getText().trim();
        if (patternText.equals("")) {
            return null;
        }
        patternText = "\\Q" + patternText.replace("\\E", "\\\\E") + "\\E";
        patternText = patternText.replace("*", "\\E.*\\Q");
        patternText = patternText.replace("?", "\\E.?\\Q");
        return Pattern.compile(patternText, 2);
    }

    private void createAddRemoveButtons() {
        Composite buttons = new Composite(this.fMainGroup, 0);
        buttons.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(0x1000000, 128, false, false);
        gd.widthHint = 100;
        buttons.setLayoutData((Object)gd);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText(Messages.SearchableSelectionList_Add);
        this.fAddButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fAddButton.setEnabled(false);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices;
                ArrayList<TableItem> added = new ArrayList<TableItem>();
                int[] nArray = indices = SearchableSelectionList.this.fAvailableTable.getSelectionIndices();
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    String moduleName = SearchableSelectionList.this.fAvailableTable.getItem(index).getText();
                    SearchableSelectionList.this.fSelectedItems.add(moduleName);
                    TableItem newItem = new TableItem(SearchableSelectionList.this.fSelectedTable, 0);
                    newItem.setText(moduleName);
                    added.add(newItem);
                    SearchableSelectionList.this.fAvailableItems.remove(moduleName);
                    ++n2;
                }
                SearchableSelectionList.this.fAvailableTable.remove(indices);
                SearchableSelectionList.this.fSelectedTable.setSelection(added.toArray(new TableItem[0]));
                SearchableSelectionList.this.fSelectedTable.setFocus();
                SearchableSelectionList.this.updateEnablement();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setText(Messages.SearchableSelectionList_Remove);
        this.fRemoveButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<String> added = new ArrayList<String>();
                TableItem[] tableItemArray = SearchableSelectionList.this.fSelectedTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    String moduleName = item.getText(0);
                    SearchableSelectionList.this.fSelectedItems.remove(moduleName);
                    SearchableSelectionList.this.fAvailableItems.add(moduleName);
                    added.add(moduleName);
                    ++n2;
                }
                SearchableSelectionList.this.refresh();
                for (String name : added) {
                    int index = 0;
                    while (index < SearchableSelectionList.this.fAvailableTable.getItemCount()) {
                        if (SearchableSelectionList.this.fAvailableTable.getItem(index).getText().equals(name)) {
                            SearchableSelectionList.this.fAvailableTable.select(index);
                        }
                        ++index;
                    }
                }
                SearchableSelectionList.this.fAvailableTable.setFocus();
                SearchableSelectionList.this.updateEnablement();
            }
        });
    }

    private void createInstructionalMessage() {
        this.fInstructionsLabel = new Label(this.fMainGroup, 64);
        this.fInstructionsLabel.setLayoutData((Object)new GridData(4, 128, true, false, 4, 2));
    }

    private void createLowerButtons() {
        this.fReloadButton = new Button(this.fMainGroup, 8);
        this.fReloadButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.fReloadButton.setText(Messages.SearchableChecklist_ReloadList);
    }

    private void createRightButtons() {
        Composite buttons = new Composite(this.fMainGroup, 0);
        buttons.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(0x1000000, 128, false, false);
        gd.widthHint = 100;
        buttons.setLayoutData((Object)gd);
        this.fUpButton = new Button(buttons, 8);
        this.fUpButton.setText(Messages.SearchableSelectionList_Up);
        this.fUpButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fUpButton.setEnabled(false);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = SearchableSelectionList.this.fSelectedTable.getSelectionIndices();
                Arrays.sort(indices);
                if (SearchableSelectionList.this.canMoveUp(SearchableSelectionList.this.fSelectedTable)) {
                    int[] nArray = indices;
                    int n = indices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int index = nArray[n2];
                        TableItem fromItem = SearchableSelectionList.this.fSelectedTable.getItem(index);
                        TableItem toItem = SearchableSelectionList.this.fSelectedTable.getItem(index - 1);
                        String swap = fromItem.getText();
                        fromItem.setText(toItem.getText());
                        toItem.setText(swap);
                        SearchableSelectionList.this.fSelectedTable.deselect(index);
                        SearchableSelectionList.this.fSelectedTable.select(index - 1);
                        Collections.swap(SearchableSelectionList.this.fSelectedItems, index, index - 1);
                        ++n2;
                    }
                }
            }
        });
        this.fDownButton = new Button(buttons, 8);
        this.fDownButton.setText(Messages.SearchableSelectionList_Down);
        this.fDownButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fDownButton.setEnabled(false);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = SearchableSelectionList.this.fSelectedTable.getSelectionIndices();
                Arrays.sort(indices);
                if (SearchableSelectionList.this.canMoveDown(SearchableSelectionList.this.fSelectedTable)) {
                    int i = indices.length - 1;
                    while (i >= 0) {
                        int index = indices[i];
                        TableItem fromItem = SearchableSelectionList.this.fSelectedTable.getItem(index);
                        TableItem toItem = SearchableSelectionList.this.fSelectedTable.getItem(index + 1);
                        String swap = fromItem.getText();
                        fromItem.setText(toItem.getText());
                        toItem.setText(swap);
                        SearchableSelectionList.this.fSelectedTable.deselect(index);
                        SearchableSelectionList.this.fSelectedTable.select(index + 1);
                        Collections.swap(SearchableSelectionList.this.fSelectedItems, index, index + 1);
                        --i;
                    }
                }
            }
        });
        this.fSetDefaultsButton = new Button(buttons, 8);
        this.fSetDefaultsButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fSetDefaultsButton.setText(Messages.SearchableSelectionList_Set_Default);
    }

    private void createTable() {
        this.fSelectedTable = new Table(this.fMainGroup, 2562);
        GridData gd = new GridData(4, 4, false, true);
        gd.widthHint = 200;
        gd.minimumWidth = 50;
        this.fSelectedTable.setLayoutData((Object)gd);
        this.fSelectedTable.setLinesVisible(false);
        this.fSelectedTable.setHeaderVisible(true);
        this.fSelectedTable.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Table table = (Table)event.widget;
                Rectangle area = table.getClientArea();
                TableColumn col = table.getColumn(0);
                col.setWidth(area.width);
            }
        });
        this.fSelectedTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchableSelectionList.this.fAvailableTable.deselectAll();
                SearchableSelectionList.this.updateEnablement();
            }
        });
        this.fSelectedColumn = new TableColumn(this.fSelectedTable, 0);
    }

    private void createTableWithSearchBox() {
        Label filter = new Label(this.fMainGroup, 64);
        filter.setText(Messages.SearchableChecklist_SearchBoxLabel);
        filter.setForeground(this.getDisplay().getSystemColor(17));
        new Label(this.fMainGroup, 0);
        new Label(this.fMainGroup, 0);
        new Label(this.fMainGroup, 0);
        this.fSearchBoxText = new Text(this.fMainGroup, 900);
        this.fSearchBoxText.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fSearchBoxText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchableSelectionList.this.refresh();
                SearchableSelectionList.this.updateEnablement();
            }
        });
        new Label(this.fMainGroup, 0);
        new Label(this.fMainGroup, 0);
        new Label(this.fMainGroup, 0);
        this.fAvailableTable = new Table(this.fMainGroup, 2562);
        GridData gd = new GridData(4, 4, false, false);
        gd.widthHint = 200;
        gd.heightHint = 100;
        gd.minimumWidth = 50;
        gd.minimumHeight = 50;
        this.fAvailableTable.setLayoutData((Object)gd);
        this.fAvailableTable.setLinesVisible(false);
        this.fAvailableTable.setHeaderVisible(true);
        this.fAvailableTable.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Table table = (Table)event.widget;
                Rectangle area = table.getClientArea();
                TableColumn col = table.getColumn(0);
                col.setWidth(area.width);
            }
        });
        this.fAvailableTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchableSelectionList.this.fSelectedTable.deselectAll();
                SearchableSelectionList.this.updateEnablement();
            }
        });
        this.fAvailableColumn = new TableColumn(this.fAvailableTable, 0);
    }

    public List<String> getAllItems() {
        return Collections.unmodifiableList(Arrays.asList(this.fAvailableItems.toArray(new String[0])));
    }

    public List<String> getSelectedItems() {
        return Collections.unmodifiableList(this.fSelectedItems);
    }

    private boolean matches(Pattern pattern, String moduleName) {
        if (pattern == null) {
            return true;
        }
        Matcher matcher = pattern.matcher(moduleName);
        if (matcher.find()) {
            return matcher.start() == 0;
        }
        return false;
    }

    private void refresh() {
        TableItem item;
        this.fAvailableTable.removeAll();
        Pattern pattern = this.compilePattern();
        for (String moduleName : this.fAvailableItems) {
            if (!this.matches(pattern, moduleName)) continue;
            item = new TableItem(this.fAvailableTable, 0);
            item.setText(0, moduleName);
        }
        this.fSelectedTable.removeAll();
        for (String moduleName : this.fSelectedItems) {
            if (!this.matches(pattern, moduleName)) continue;
            item = new TableItem(this.fSelectedTable, 0);
            item.setText(0, moduleName);
        }
        this.layout();
    }

    public void setColumnHeaders(String availableColumnHeader, String selectedColumnHeader) {
        this.fAvailableColumn.setText(availableColumnHeader);
        this.fSelectedColumn.setText(selectedColumnHeader);
        this.layout(true, true);
    }

    public void setComparator(Comparator<String> comparator) {
    }

    public void setEnabledAndVisible(boolean value) {
        this.setEnabled(value);
        this.setVisible(value);
        this.layout(true, true);
    }

    public void setInstructions(String message) {
        this.fInstructionsLabel.setText(message);
        this.layout(true, true);
    }

    public void setInstructions(String message, int widthHint) {
        GridData gd = (GridData)this.fInstructionsLabel.getLayoutData();
        gd.widthHint = widthHint;
        this.setInstructions(message);
    }

    public void setItems(List<String> availableItems, List<String> selectedItems) {
        this.fAvailableItems = new TreeSet<String>(availableItems);
        this.fSelectedItems = new ArrayList<String>(selectedItems);
        this.fAvailableItems.removeAll(this.fSelectedItems);
        this.refresh();
    }

    public void setTitle(String description) {
        this.layout(true, true);
    }

    private void updateEnablement() {
        this.fAddButton.setEnabled(this.fAvailableTable.getSelectionCount() > 0);
        this.fRemoveButton.setEnabled(this.fSelectedTable.getSelectionCount() > 0);
        this.fUpButton.setEnabled(this.canMoveUp(this.fSelectedTable));
        this.fDownButton.setEnabled(this.canMoveDown(this.fSelectedTable));
    }

    private final class AsyncRepopulationJob
    extends Job {
        private final AsyncRepopulationStrategy strategy;

        public AsyncRepopulationJob(AsyncRepopulationStrategy strategy) {
            super(strategy.getMessage());
            this.strategy = strategy;
        }

        protected IStatus run(IProgressMonitor monitor) {
            List<String> modulesToSelect;
            List<String> modules;
            try {
                modules = this.strategy.computeItems(monitor);
                modulesToSelect = this.strategy.computeSelectedItems(monitor);
            }
            catch (Exception e) {
                if (!SearchableSelectionList.this.isDisposed()) {
                    SearchableSelectionList.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!SearchableSelectionList.this.fAvailableTable.isDisposed()) {
                                SearchableSelectionList.this.fAvailableTable.getItem(0).setText(1, String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
                            }
                        }
                    });
                }
                return new Status(4, "org.eclipse.ptp.ems.ui", 4, e.getLocalizedMessage(), (Throwable)e);
            }
            if (!SearchableSelectionList.this.isDisposed()) {
                SearchableSelectionList.this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SearchableSelectionList.this.fAvailableTable.isDisposed()) {
                            SearchableSelectionList.this.setItems(modules, modulesToSelect);
                            AsyncRepopulationJob.this.strategy.afterRepopulation();
                            SearchableSelectionList.this.layout(true, true);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

