/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.sdm.core;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.IPJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIManagerFactory;
import org.eclipse.ptp.debug.core.pdi.model.IPDIModelFactory;
import org.eclipse.ptp.debug.core.pdi.request.IPDIRequestFactory;
import org.eclipse.ptp.internal.debug.core.pdi.Session;
import org.eclipse.ptp.internal.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.internal.debug.sdm.core.SDMEventFactory;
import org.eclipse.ptp.internal.debug.sdm.core.SDMManagerFactory;
import org.eclipse.ptp.internal.debug.sdm.core.SDMModelFactory;
import org.eclipse.ptp.internal.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.internal.debug.sdm.core.SDMRequestFactory;
import org.eclipse.ptp.internal.debug.sdm.core.messages.Messages;
import org.eclipse.ptp.internal.debug.sdm.core.pdi.PDIDebugger;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDMDebugger
implements IPDebugger {
    private static final String WORKING_DIR = ".eclipsesettings";
    private static final String SDM = "sdm";
    private static final String BUNDLE_PREFIX = "org.eclipse.ptp.";
    private static final String OS = "os";
    private final IPDIDebugger fPdiDebugger = new PDIDebugger();
    private final IPDIModelFactory fModelFactory = new SDMModelFactory();
    private final IPDIManagerFactory fManagerFactory = new SDMManagerFactory();
    private final IPDIEventFactory fEventFactory = new SDMEventFactory();
    private final IPDIRequestFactory fRequestFactory = new SDMRequestFactory();

    public synchronized void cleanup(IPLaunch launch) {
    }

    public synchronized IPDISession createDebugSession(long timeout, IPLaunch launch, IProgressMonitor monitor) throws CoreException {
        Session session;
        int jobSize = this.getJobSize(launch);
        try {
            session = new Session(this.fManagerFactory, this.fRequestFactory, this.fEventFactory, this.fModelFactory, launch.getLaunchConfiguration(), timeout, this.fPdiDebugger, launch.getJobId(), jobSize);
        }
        catch (PDIException e) {
            throw this.newCoreException(e.getLocalizedMessage());
        }
        return session;
    }

    private String deploySDM(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean useBuiltin = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_USE_BUILTIN_SDM", false);
        if (useBuiltin) {
            IRemoteConnection remoteConnection;
            IRemoteServices remoteServices;
            String remoteId = LaunchUtils.getRemoteServicesId((ILaunchConfiguration)configuration);
            String connectionName = LaunchUtils.getConnectionName((ILaunchConfiguration)configuration);
            if (remoteId != null && connectionName != null && (remoteServices = RemoteServices.getRemoteServices((String)remoteId, (IProgressMonitor)progress.newChild(10))) != null && (remoteConnection = remoteServices.getConnectionManager().getConnection(connectionName)) != null) {
                if (!remoteConnection.isOpen()) {
                    try {
                        progress.subTask(Messages.SDMDebugger_Opening_connection);
                        remoteConnection.open((IProgressMonitor)progress.newChild(10));
                    }
                    catch (RemoteConnectionException e) {
                        throw new CoreException((IStatus)new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), Messages.SDMDebugger_Could_not_open_connection, (Throwable)e));
                    }
                }
                if (remoteConnection.isOpen()) {
                    IRemoteFileManager fileManager;
                    Bundle bundle;
                    String osName = this.normalize(remoteConnection.getProperty("os.name"));
                    String osArch = remoteConnection.getProperty("os.arch");
                    if (osName != null && osArch != null && (bundle = Platform.getBundle((String)(BUNDLE_PREFIX + osName))) != null && (fileManager = remoteConnection.getFileManager()) != null) {
                        IPath destDirPath = new Path(remoteConnection.getWorkingDirectory()).append(WORKING_DIR);
                        IFileStore destDir = fileManager.getResource(destDirPath.toString());
                        destDir.mkdir(0, (IProgressMonitor)progress.newChild(1));
                        IFileStore local = null;
                        IPath srcPath = new Path(OS).append(osName).append(osArch).append(SDM);
                        URL jarURL = FileLocator.find((Bundle)bundle, (IPath)srcPath, null);
                        if (jarURL != null) {
                            try {
                                jarURL = FileLocator.toFileURL((URL)jarURL);
                                local = EFS.getStore((URI)URIUtil.toURI((URL)jarURL));
                            }
                            catch (Exception e) {
                                throw new CoreException((IStatus)new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), Messages.SDMDebugger_Could_not_locate_SDM_exectuable, (Throwable)e));
                            }
                        }
                        if (local != null) {
                            IFileStore destPath = destDir.getChild(SDM);
                            IFileInfo destInfo = destPath.fetchInfo(0, (IProgressMonitor)progress.newChild(10));
                            IFileInfo localInfo = local.fetchInfo(0, (IProgressMonitor)progress.newChild(10));
                            if (!destInfo.exists() || destInfo.getLength() != localInfo.getLength()) {
                                progress.subTask(Messages.SDMDebugger_Copying_SDM_to_target_system);
                                local.copy(destPath, 2, (IProgressMonitor)progress.newChild(70));
                            }
                            if (!(destInfo = destPath.fetchInfo(0, (IProgressMonitor)progress.newChild(10))).getAttribute(4)) {
                                destInfo.setAttribute(4, true);
                                destInfo.setAttribute(0x20000000, false);
                                destPath.putInfo(destInfo, 1024, (IProgressMonitor)progress.newChild(10));
                            }
                            return destPath.toURI().getPath();
                        }
                    }
                }
            }
        }
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_EXECUTABLE", "");
    }

    private int getJobSize(IPLaunch launch) {
        IPJobStatus pJob;
        int nprocs = 1;
        IJobStatus job = JobManager.getInstance().getJob(launch.getJobControl().getControlId(), launch.getJobId());
        if (job != null && (pJob = (IPJobStatus)job.getAdapter(IPJobStatus.class)) != null && (nprocs = pJob.getNumberOfProcesses()) == 0) {
            nprocs = 1;
        }
        return nprocs;
    }

    private IRemoteConnection getRemoteConnection(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String name;
        IRemoteServices services;
        String remId = configuration.getAttribute("org.eclipse.ptp.launch.REMOTE_SERVICES_ID", null);
        if (remId != null && (services = RemoteServices.getRemoteServices((String)remId, (IProgressMonitor)monitor)) != null && (name = configuration.getAttribute("org.eclipse.ptp.launch.CONNECTION_NAME", null)) != null) {
            return services.getConnectionManager().getConnection(name);
        }
        return null;
    }

    public synchronized void initialize(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String dbgPath;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
        ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
        ArrayList<String> dbgArgs = new ArrayList<String>();
        try {
            this.fPdiDebugger.initialize(configuration, dbgArgs, (IProgressMonitor)progress.newChild(10));
        }
        catch (PDIException e) {
            throw this.newCoreException(e.getLocalizedMessage());
        }
        String localAddress = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", "localhost");
        dbgArgs.add("--host=" + localAddress);
        String debuggerBackend = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND", null);
        if (debuggerBackend != null) {
            dbgArgs.add("--debugger=" + debuggerBackend);
        }
        if ((dbgPath = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND_PATH", null)) != null) {
            dbgArgs.add("--debugger_path=" + dbgPath);
        }
        if (Preferences.getBoolean((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUG_ENABLED)) {
            dbgArgs.add("--debug=" + Preferences.getInt((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUG_LEVEL));
        }
        String dbgExePath = this.deploySDM(configuration, (IProgressMonitor)progress.newChild(10));
        this.verifyResource(dbgExePath, configuration, (IProgressMonitor)progress.newChild(10));
        workingCopy.setAttribute("org.eclipse.ptp.launch.DEBUGGER_ARGS", this.stringify(dbgArgs));
        workingCopy.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", dbgExePath);
        workingCopy.doSave();
    }

    private CoreException newCoreException(String message) {
        Status status = new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), message, null);
        return new CoreException((IStatus)status);
    }

    private String normalize(String osName) {
        return osName.toLowerCase().replaceAll("\\s", "");
    }

    private String stringify(List<String> list) {
        String result = "";
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + list.get(i);
            ++i;
        }
        return result;
    }

    private IPath verifyResource(String path, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRemoteConnection conn = this.getRemoteConnection(configuration, monitor);
        if (monitor.isCanceled()) {
            throw this.newCoreException(Messages.SDMDebugger_Operation_canceled_by_user);
        }
        if (conn == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_2));
        }
        IRemoteFileManager fileManager = conn.getFileManager();
        if (fileManager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_3));
        }
        if (!fileManager.getResource(path).fetchInfo().exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", NLS.bind((String)Messages.SDMDebugger_5, (Object[])new Object[]{path})));
        }
        return new Path(path);
    }
}

