/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.typehierarchy;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.IIndexLocationConverterFactory;

public class TypeHierarchyUtil {
    public static IBinding findTypeBinding(IBinding memberBinding) {
        if (memberBinding instanceof IEnumerator) {
            IType type = ((IEnumerator)memberBinding).getType();
            if (type instanceof IBinding) {
                return (IBinding)type;
            }
        } else {
            if (memberBinding instanceof ICPPMember) {
                return ((ICPPMember)memberBinding).getClassOwner();
            }
            if (memberBinding instanceof IField) {
                return ((IField)memberBinding).getCompositeTypeOwner();
            }
        }
        return null;
    }

    public static boolean isValidInput(IBinding binding) {
        return TypeHierarchyUtil.isValidTypeInput(binding) || binding instanceof ICPPMember || binding instanceof IEnumerator || binding instanceof IField;
    }

    public static boolean isValidTypeInput(IBinding binding) {
        return binding instanceof ICompositeType || binding instanceof IEnumeration || binding instanceof ITypedef;
    }

    public static ICElement findDeclaration(ICProject project, IIndex index, IASTName name, IBinding binding, IIndexLocationConverterFactory converter, ICProjectFactory projectFactory) throws CoreException {
        if (name != null && name.isDefinition()) {
            return IndexQueries.getCElementForName(project, index, name, converter, projectFactory);
        }
        ICElement[] elems = IndexQueries.findAllDefinitions(index, binding, converter, project, projectFactory);
        if (elems.length > 0) {
            return elems[0];
        }
        return IndexQueries.findAnyDeclaration(index, project, binding, converter, projectFactory);
    }

    public static ICElement findDefinition(ICProject project, IIndex index, IASTName name, IBinding binding, IIndexLocationConverterFactory converter, ICProjectFactory projectFactory) throws CoreException {
        if (name != null && name.isDefinition()) {
            return IndexQueries.getCElementForName(project, index, name, converter, projectFactory);
        }
        ICElement[] elems = IndexQueries.findAllDefinitions(index, binding, converter, project, projectFactory);
        if (elems.length > 0) {
            return elems[0];
        }
        return IndexQueries.findAnyDeclaration(index, project, binding, converter, projectFactory);
    }
}

