/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.ui.utils;

import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.cell.AttributeViewerEditingSupport;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.providers.TableDataContentProvider;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.providers.TreeDataContentProvider;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.providers.ViewerDataCellLabelProvider;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.sorters.AttributeViewerSorter;
import org.eclipse.ptp.internal.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.ptp.rm.jaxb.core.data.ColumnDataType;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlWidgetBuilderUtils {
    public static void setupAttributeTable(CheckboxTableViewer viewer, List<ColumnDataType> columnData, ISelectionChangedListener listener, boolean sortByName, boolean tooltip, boolean headerVisible, boolean linesVisible) {
        ControlWidgetBuilderUtils.setupSpecific(viewer, columnData, (Boolean)sortByName, headerVisible, linesVisible);
        ControlWidgetBuilderUtils.setupCommon((ColumnViewer)viewer, columnData, listener, tooltip);
    }

    public static void setupAttributeTree(CheckboxTreeViewer viewer, List<ColumnDataType> columnData, ISelectionChangedListener listener, boolean sortByName, boolean tooltip, boolean headerVisible, boolean linesVisible) {
        ControlWidgetBuilderUtils.setupSpecific(viewer, columnData, (Boolean)sortByName, headerVisible, linesVisible);
        ControlWidgetBuilderUtils.setupCommon((ColumnViewer)viewer, columnData, listener, tooltip);
    }

    private static SelectionAdapter getAttributeViewerSelectionAdapter(final ColumnViewer viewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeViewerSorter sorter = (AttributeViewerSorter)viewer.getSorter();
                if (sorter != null) {
                    sorter.toggle();
                    viewer.refresh();
                }
            }
        };
    }

    private static void setupCommon(ColumnViewer viewer, List<ColumnDataType> columnData, ISelectionChangedListener listener, boolean tooltip) {
        String[] columnProperties = new String[columnData.size()];
        int i = 0;
        while (i < columnData.size()) {
            ColumnDataType columnDescriptor = columnData.get(i);
            columnProperties[i] = columnDescriptor.getName();
            ++i;
        }
        viewer.setColumnProperties(columnProperties);
        if (tooltip) {
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        }
        if (listener != null) {
            viewer.addSelectionChangedListener(listener);
        }
        viewer.setLabelProvider((IBaseLabelProvider)new ViewerDataCellLabelProvider(columnData));
    }

    private static void setupSpecific(CheckboxTableViewer viewer, List<ColumnDataType> columnData, Boolean sortOnName, boolean headerVisible, boolean linesVisible) {
        int i = 0;
        while (i < columnData.size()) {
            ColumnDataType columnDescriptor = columnData.get(i);
            TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)viewer, 0);
            TableColumn column = viewerColumn.getColumn();
            String name = columnDescriptor.getName();
            column.setText(name);
            column.setMoveable(columnDescriptor.isMoveable());
            column.setResizable(columnDescriptor.isResizable());
            String tt = columnDescriptor.getTooltip();
            if (tt != null) {
                column.setToolTipText(tt);
            }
            if (-1 != columnDescriptor.getWidth()) {
                column.setWidth(columnDescriptor.getWidth());
            }
            if (columnDescriptor.getAlignment() != null) {
                column.setAlignment(WidgetBuilderUtils.getStyle((String)columnDescriptor.getAlignment()));
            }
            if ("Name".equals(name) && sortOnName != null && sortOnName.booleanValue()) {
                viewer.setSorter((ViewerSorter)new AttributeViewerSorter());
                column.addSelectionListener((SelectionListener)ControlWidgetBuilderUtils.getAttributeViewerSelectionAdapter((ColumnViewer)viewer));
            }
            if ("Value".equals(columnDescriptor.getName())) {
                viewerColumn.setEditingSupport((EditingSupport)new AttributeViewerEditingSupport((ColumnViewer)viewer));
            }
            ++i;
        }
        viewer.setContentProvider((IContentProvider)new TableDataContentProvider());
        viewer.getTable().setHeaderVisible(headerVisible);
        viewer.getTable().setLinesVisible(linesVisible);
    }

    private static void setupSpecific(CheckboxTreeViewer viewer, List<ColumnDataType> columnData, Boolean sortOnName, boolean headerVisible, boolean linesVisible) {
        int i = 0;
        while (i < columnData.size()) {
            ColumnDataType columnDescriptor = columnData.get(i);
            TreeViewerColumn viewerColumn = new TreeViewerColumn((TreeViewer)viewer, 0);
            TreeColumn column = viewerColumn.getColumn();
            String name = columnDescriptor.getName();
            column.setText(name);
            column.setMoveable(columnDescriptor.isMoveable());
            column.setResizable(columnDescriptor.isResizable());
            String tt = columnDescriptor.getTooltip();
            if (tt != null) {
                column.setToolTipText(tt);
            }
            if (-1 != columnDescriptor.getWidth()) {
                column.setWidth(columnDescriptor.getWidth());
            }
            if (columnDescriptor.getAlignment() != null) {
                column.setAlignment(WidgetBuilderUtils.getStyle((String)columnDescriptor.getAlignment()));
            }
            if ("Name".equals(name) && sortOnName != null && sortOnName.booleanValue()) {
                viewer.setSorter((ViewerSorter)new AttributeViewerSorter());
                column.addSelectionListener((SelectionListener)ControlWidgetBuilderUtils.getAttributeViewerSelectionAdapter((ColumnViewer)viewer));
            }
            if ("Value".equals(columnDescriptor.getName())) {
                viewerColumn.setEditingSupport((EditingSupport)new AttributeViewerEditingSupport((ColumnViewer)viewer));
            }
            ++i;
        }
        viewer.setContentProvider((IContentProvider)new TreeDataContentProvider());
        viewer.getTree().setHeaderVisible(headerVisible);
        viewer.getTree().setLinesVisible(linesVisible);
    }
}

