/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.jobs.IJobListener;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.core.JAXBInitializationUtils;
import org.eclipse.ptp.internal.rm.lml.core.JAXBUtil;
import org.eclipse.ptp.internal.rm.lml.monitor.core.LMLMonitorCorePlugin;
import org.eclipse.ptp.internal.rm.lml.monitor.core.messages.Messages;
import org.eclipse.ptp.remote.server.core.RemoteServerManager;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorDriverType;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorType;
import org.eclipse.ptp.rm.jaxb.core.data.SimpleCommandType;
import org.eclipse.ptp.rm.jaxb.core.data.lml.LayoutRoot;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.core.elements.CommandType;
import org.eclipse.ptp.rm.lml.core.elements.DriverType;
import org.eclipse.ptp.rm.lml.core.elements.ObjectFactory;
import org.eclipse.ptp.rm.lml.core.elements.RequestType;
import org.eclipse.ptp.rm.lml.da.server.core.LMLDAServer;
import org.eclipse.ptp.rm.lml.monitor.core.IMonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControlManager;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.core.RemoteServicesUtils;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class MonitorControl
implements IMonitorControl {
    private final String fControlId;
    private final LMLManager fLMLManager = LMLManager.getInstance();
    private final JobListener fJobListener = new JobListener();
    private final ConnectionChangeListener fConnectionListener = new ConnectionChangeListener();
    private final List<JobStatusData> fSavedJobs = new ArrayList<JobStatusData>();
    private String fSavedLayout;
    private MonitorJob fMonitorJob;
    private String fConfigurationName;
    private boolean fActive;
    private boolean cacheActive;
    private String fRemoteServicesId;
    private String fConnectionName;
    private static final String XML = "xml";
    private static final String JOBS_ATTR = "jobs";
    private static final String JOB_ATTR = "job";
    private static final String LAYOUT_ATTR = "layout";
    private static final String LAYOUT_STRING_ATTR = "layoutString";
    private static final String MONITOR_STATE = "monitorState";
    private static final String MONITOR_ATTR = "monitor";
    private static final String REMOTE_SERVICES_ID_ATTR = "remoteServicesId";
    private static final String CONNECTION_NAME_ATTR = "connectionName";
    private static final String CONFIGURATION_NAME_ATTR = "configurationName";

    private void setActive(boolean active) {
        this.fActive = active;
        MonitorControlManager.getInstance().fireMonitorUpdated(new IMonitorControl[]{this});
    }

    public static void checkForOutputFile(JobStatusData data, boolean isError, ILaunchController controller, IProgressMonitor monitor) {
        String path = isError ? data.getString("stderrRemotePath") : data.getString("stdoutRemotePath");
        if (path != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
            IFileStore store = RemoteServicesUtils.getRemoteFileWithProgress((String)controller.getRemoteServicesId(), (String)controller.getConnectionName(), (String)path, (IProgressMonitor)progress.newChild(10));
            try {
                if (store.fetchInfo(0, (IProgressMonitor)progress.newChild(10)).exists()) {
                    if (isError) {
                        data.setErrReady(true);
                    } else {
                        data.setOutReady(true);
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private static void checkOutputFile(JobStatusData jobData, ILaunchController controller) {
        MonitorControl.checkOutputFiles(new JobStatusData[]{jobData}, controller);
    }

    private static void checkOutputFiles(final JobStatusData[] jobData, final ILaunchController controller) {
        Job job = new Job(Messages.MonitorControl_Check_job_output){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
                JobStatusData[] jobStatusDataArray = jobData;
                int n = jobData.length;
                int n2 = 0;
                while (n2 < n) {
                    JobStatusData data = jobStatusDataArray[n2];
                    MonitorControl.checkForOutputFile(data, true, controller, (IProgressMonitor)progress.newChild(10));
                    MonitorControl.checkForOutputFile(data, false, controller, (IProgressMonitor)progress.newChild(10));
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public MonitorControl(String controlId) {
        this.fControlId = controlId;
    }

    @Override
    public void dispose() {
        try {
            this.getSaveLocation().delete();
        }
        catch (Exception e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
    }

    @Override
    public String getConfigurationName() {
        return this.fConfigurationName;
    }

    @Override
    public String getConnectionName() {
        return this.fConnectionName;
    }

    @Override
    public String getControlId() {
        return this.fControlId;
    }

    @Override
    public boolean isCacheActive() {
        return this.cacheActive;
    }

    public boolean getDefaultForceUpdate() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ptp.rm.lml.monitor.core");
        boolean result = preferences.getBoolean("forceUpdate", false);
        return result;
    }

    @Override
    public String getRemoteServicesId() {
        return this.fRemoteServicesId;
    }

    @Override
    public String getSystemType() {
        return MonitorControlManager.getSystemType(this.fConfigurationName);
    }

    public int getUpdateInterval() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ptp.rm.lml.monitor.core");
        int prefUpdateInterval = preferences.getInt("updateInterval", 60);
        return prefUpdateInterval;
    }

    @Override
    public boolean isActive() {
        return this.fActive;
    }

    @Override
    public boolean load() throws CoreException {
        FileReader reader;
        this.fSavedJobs.clear();
        try {
            reader = new FileReader(this.getSaveLocation());
        }
        catch (FileNotFoundException e) {
            throw CoreExceptionUtils.newException((String)e.getMessage(), (Throwable)e);
        }
        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
        boolean active = this.loadState((IMemento)memento);
        IMemento layout = memento.getChild(LAYOUT_ATTR);
        if (layout != null) {
            this.fSavedLayout = layout.getString(LAYOUT_STRING_ATTR);
        }
        IMemento jobs = memento.getChild(JOBS_ATTR);
        this.loadJobs(jobs, this.fSavedJobs);
        return active;
    }

    @Override
    public void refresh() {
        if (this.fMonitorJob != null) {
            this.fMonitorJob.refresh();
        }
    }

    @Override
    public void save() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)MONITOR_ATTR);
        String layout = this.fLMLManager.getCurrentLayout(this.getControlId());
        JobStatusData[] jobs = this.fLMLManager.getUserJobs(this.getControlId());
        this.saveState((IMemento)memento);
        if (layout != null) {
            IMemento layoutMemento = memento.createChild(LAYOUT_ATTR);
            layoutMemento.putString(LAYOUT_STRING_ATTR, layout);
        }
        if (jobs != null && jobs.length > 0) {
            IMemento jobsMemento = memento.createChild(JOBS_ATTR);
            JobStatusData[] jobStatusDataArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                JobStatusData status = jobStatusDataArray[n2];
                this.saveJob(status, jobsMemento);
                ++n2;
            }
        }
        try {
            FileWriter writer = new FileWriter(this.getSaveLocation());
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
    }

    @Override
    public void setConfigurationName(String name) {
        this.fConfigurationName = name;
    }

    @Override
    public void setConnectionName(String connName) {
        this.fConnectionName = connName;
    }

    @Override
    public void setRemoteServicesId(String id) {
        this.fRemoteServicesId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(IProgressMonitor monitor) throws CoreException {
        if (!this.isActive()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
            ILaunchController controller = LaunchControllerManager.getInstance().getLaunchController(this.getRemoteServicesId(), this.getConnectionName(), this.getConfigurationName());
            if (controller == null) {
                throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), Messages.MonitorControl_UnableToLocateLaunchController));
            }
            try {
                this.load();
            }
            catch (CoreException e) {
                LMLMonitorCorePlugin.log(e.getLocalizedMessage());
            }
            IRemoteConnection conn = this.getRemoteConnection((IProgressMonitor)progress.newChild(10));
            if (conn == null) {
                throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), NLS.bind((String)Messages.MonitorControl_UnableToLocateConnection, (Object)this.getConnectionName())));
            }
            if (conn == null || progress.isCanceled()) {
                return;
            }
            if (!conn.isOpen()) {
                try {
                    conn.open((IProgressMonitor)progress.newChild(10));
                }
                catch (RemoteConnectionException e) {
                    throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), e.getMessage()));
                }
                if (!conn.isOpen()) {
                    throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), Messages.LMLResourceManagerMonitor_unableToOpenConnection));
                }
            }
            if (this.fSavedLayout == null) {
                this.fSavedLayout = MonitorControlManager.getSystemLayout(this.fConfigurationName);
            }
            MonitorControl.checkOutputFiles(this.fSavedJobs.toArray(new JobStatusData[0]), controller);
            this.fLMLManager.openLgui(this.getControlId(), conn.getUsername(), this.getMonitorConfigurationRequestType(controller), this.fSavedLayout, this.fSavedJobs.toArray(new JobStatusData[0]));
            this.setCacheActive(!this.getDefaultForceUpdate());
            MonitorControl monitorControl = this;
            synchronized (monitorControl) {
                this.fMonitorJob = new MonitorJob(conn);
                this.fMonitorJob.schedule();
            }
            this.setActive(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws CoreException {
        if (this.fMonitorJob != null) {
            MonitorControl monitorControl = this;
            synchronized (monitorControl) {
                this.fMonitorJob.askForStop();
                try {
                    this.fMonitorJob.join();
                }
                catch (InterruptedException interruptedException) {}
                this.fMonitorJob = null;
            }
        }
    }

    private void addJob(IJobStatus status) {
        ILaunchController controller = LaunchControllerManager.getInstance().getLaunchController(status.getControlId());
        if (controller != null) {
            String[][] attrs = new String[][]{{"controlId", status.getControlId()}, {"queueName", status.getQueueName()}, {"owner", status.getOwner()}, {"stdoutRemotePath", status.getOutputPath()}, {"stderrRemotePath", status.getErrorPath()}, {"interactive", Boolean.toString(status.isInteractive())}};
            JobStatusData data = new JobStatusData(status.getJobId(), attrs);
            data.setState(status.getState());
            data.setStateDetail(status.getStateDetail());
            if ("JOB_OUTERR_READY".equals(status.getStateDetail())) {
                MonitorControl.checkOutputFile(data, controller);
            }
            this.fLMLManager.addUserJob(this.getControlId(), status.getJobId(), data);
        }
    }

    private RequestType getMonitorConfigurationRequestType(ILaunchController controller) {
        LayoutRoot lmlLayout;
        MonitorType monitor = controller.getConfiguration().getMonitorData();
        if (monitor != null && (lmlLayout = monitor.getLayout()) != null) {
            org.eclipse.ptp.rm.jaxb.core.data.lml.RequestType rmRequest = lmlLayout.getRequest();
            Class<org.eclipse.ptp.rm.jaxb.core.data.lml.RequestType> rmRequestClass = org.eclipse.ptp.rm.jaxb.core.data.lml.RequestType.class;
            String rmRequestString = JAXBInitializationUtils.marshalData((Object)rmRequest, rmRequestClass, (String)"request");
            RequestType lmlCoreRequest = (RequestType)JAXBUtil.getInstance().unmarshalFragment(rmRequestString, RequestType.class);
            if (lmlCoreRequest != null) {
                return lmlCoreRequest;
            }
        }
        ObjectFactory lmlFactory = new ObjectFactory();
        RequestType request = lmlFactory.createRequestType();
        DriverType driver = lmlFactory.createDriverType();
        driver.setName(this.getSystemType());
        if (monitor != null) {
            List driverCommands = driver.getCommand();
            for (MonitorDriverType monitorDriver : monitor.getDriver()) {
                for (SimpleCommandType monitorCmd : monitorDriver.getCmd()) {
                    CommandType cmd = new CommandType();
                    cmd.setName(monitorCmd.getName());
                    cmd.setExec(monitorCmd.getExec());
                    driverCommands.add(cmd);
                }
            }
        }
        request.getDriver().add(driver);
        return request;
    }

    private IRemoteConnection getRemoteConnection(IProgressMonitor monitor) throws CoreException {
        IRemoteServices services = RemoteServices.getRemoteServices((String)this.getRemoteServicesId(), (IProgressMonitor)monitor);
        if (services != null) {
            IRemoteConnectionManager connMgr = services.getConnectionManager();
            return connMgr.getConnection(this.getConnectionName());
        }
        throw CoreExceptionUtils.newException((String)Messages.MonitorControl_unableToOpenRemoteConnection, null);
    }

    private File getSaveLocation() {
        return LMLMonitorCorePlugin.getDefault().getStateLocation().append(this.getControlId()).addFileExtension(XML).toFile();
    }

    private void loadJobs(IMemento memento, List<JobStatusData> jobs) {
        if (memento != null) {
            IMemento[] children;
            IMemento[] iMementoArray = children = memento.getChildren(JOB_ATTR);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                String[] keys = child.getAttributeKeys();
                String[][] attrs = new String[keys.length][2];
                int i = 0;
                while (i < keys.length) {
                    attrs[i][0] = keys[i];
                    attrs[i][1] = child.getString(keys[i]);
                    ++i;
                }
                JobStatusData jobData = new JobStatusData(child.getID(), attrs);
                jobs.add(jobData);
                ++n2;
            }
        }
    }

    private boolean loadState(IMemento memento) {
        this.setRemoteServicesId(memento.getString(REMOTE_SERVICES_ID_ATTR));
        this.setConnectionName(memento.getString(CONNECTION_NAME_ATTR));
        this.setConfigurationName(memento.getString(CONFIGURATION_NAME_ATTR));
        return memento.getBoolean(MONITOR_STATE);
    }

    private void saveJob(JobStatusData job, IMemento memento) {
        IMemento jobMemento = memento.createChild(JOB_ATTR, job.getJobId());
        for (String key : job.getKeys()) {
            jobMemento.putString(key, job.getString(key));
        }
    }

    private void saveState(IMemento memento) {
        memento.putString(REMOTE_SERVICES_ID_ATTR, this.getRemoteServicesId());
        memento.putString(CONNECTION_NAME_ATTR, this.getConnectionName());
        memento.putString(CONFIGURATION_NAME_ATTR, this.getConfigurationName());
        memento.putBoolean(MONITOR_STATE, this.isActive());
    }

    private void updateJob(IJobStatus status) {
        ILaunchController controller;
        if (status.getControlId().equals(this.getControlId()) && (controller = LaunchControllerManager.getInstance().getLaunchController(status.getControlId())) != null) {
            JobStatusData data = this.fLMLManager.getUserJob(status.getControlId(), status.getJobId());
            if (data != null && !data.isRemoved() && "JOB_OUTERR_READY".equals(status.getStateDetail())) {
                MonitorControl.checkOutputFile(data, controller);
            }
            this.fLMLManager.updateUserJob(this.getControlId(), status.getJobId(), status.getState(), status.getStateDetail());
        }
    }

    @Override
    public void setCacheActive(boolean active) {
        this.cacheActive = active;
        this.fLMLManager.setCachingMode(this.getControlId(), this.cacheActive);
        MonitorControlManager.getInstance().fireMonitorUpdated(new IMonitorControl[]{this});
    }

    private class ConnectionChangeListener
    implements IRemoteConnectionChangeListener {
        private ConnectionChangeListener() {
        }

        public void connectionChanged(IRemoteConnectionChangeEvent event) {
            int type = event.getType();
            MonitorJob job = MonitorControl.this.fMonitorJob;
            if (job != null && (type == 1 || type == 4)) {
                job.askForStop();
            }
        }
    }

    private class JobListener
    implements IJobListener {
        private JobListener() {
        }

        public void jobAdded(IJobStatus status) {
            MonitorControl.this.addJob(status);
        }

        public void jobChanged(IJobStatus status) {
            MonitorControl.this.updateJob(status);
        }
    }

    private class MonitorJob
    extends Job {
        private final LMLDAServer fServer;
        private final IRemoteConnection fConnection;
        private int waitCount;
        private boolean stopReqested;

        public MonitorJob(IRemoteConnection conn) {
            super(Messages.LMLResourceManagerMonitor_LMLMonitorJob);
            this.setSystem(true);
            this.fConnection = conn;
            this.fServer = (LMLDAServer)RemoteServerManager.getServer((String)LMLDAServer.SERVER_ID, (IRemoteConnection)conn);
            this.fServer.setWorkDir(new Path(conn.getWorkingDirectory()).append(".eclipsesettings").toString());
        }

        public void askForStop() {
            if (this.fServer.serverIsRunning()) {
                this.fServer.cancel();
            }
            this.stopReqested = true;
            this.wakeUp();
        }

        public void refresh() {
            this.waitCount = 0;
            this.wakeUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.fConnection.addConnectionChangeListener((IRemoteConnectionChangeListener)MonitorControl.this.fConnectionListener);
            JobManager.getInstance().addListener((IJobListener)MonitorControl.this.fJobListener);
            try {
                try {
                    block18: {
                        block17: {
                            if (!true) break block17;
                            if (this.stopReqested) return Status.OK_STATUS;
                            if (subMon.isCanceled()) break block18;
                        }
                        do {
                            IStatus status;
                            this.fServer.startServer((IProgressMonitor)subMon.newChild(20));
                            if (!subMon.isCanceled()) {
                                this.fServer.waitForServerStart((IProgressMonitor)subMon.newChild(20));
                                if (!subMon.isCanceled() && this.fServer.serverIsRunning()) {
                                    LMLManager.getInstance().update(MonitorControl.this.getControlId(), this.fServer.getInputStream(), this.fServer.getOutputStream());
                                }
                            }
                            if (!this.stopReqested && (status = this.fServer.waitForServerFinish((IProgressMonitor)subMon.newChild(40))) == Status.OK_STATUS) {
                                this.waitCount = MonitorControl.this.getUpdateInterval() * 1000;
                                while (!this.stopReqested && !subMon.isCanceled() && this.waitCount > 0) {
                                    MonitorJob monitorJob = this;
                                    synchronized (monitorJob) {
                                        try {
                                            ((Object)((Object)this)).wait(100L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    this.waitCount -= 100;
                                }
                            }
                            if (this.stopReqested) return Status.OK_STATUS;
                        } while (!subMon.isCanceled());
                    }
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.ptp.rm.lml.monitor.core", e.getLocalizedMessage(), (Throwable)e);
                    MonitorControl.this.save();
                    MonitorControl.this.fLMLManager.closeLgui(MonitorControl.this.getControlId());
                    this.fConnection.removeConnectionChangeListener((IRemoteConnectionChangeListener)MonitorControl.this.fConnectionListener);
                    JobManager.getInstance().removeListener((IJobListener)MonitorControl.this.fJobListener);
                    MonitorControl.this.setActive(false);
                    return status;
                }
            }
            finally {
                MonitorControl.this.save();
                MonitorControl.this.fLMLManager.closeLgui(MonitorControl.this.getControlId());
                this.fConnection.removeConnectionChangeListener((IRemoteConnectionChangeListener)MonitorControl.this.fConnectionListener);
                JobManager.getInstance().removeListener((IJobListener)MonitorControl.this.fJobListener);
                MonitorControl.this.setActive(false);
            }
        }
    }
}

